/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.ui;

import com.google.api.client.util.Base64;
import com.google.api.services.fetchasgoogle_pa.model.AppIndexingApiData;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.api.services.fetchasgoogle_pa.model.ReferencedResource;
import com.google.appindexing.fetchasgoogle.SupportedLanguage;
import com.google.common.base.Ascii;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.icons.AllIcons;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultPanel
extends JPanel {
    private JPanel myRootPanel;
    private JPanel myBlockedResourcesPanel;
    private JPanel myTitlePanel;
    private JPanel myDetailsPanel;
    private JSeparator mySeparator;
    private JPanel myScreenshotPanel;
    private JPanel myLeftPanel;
    private JBLabel myDateLabel;
    private HyperlinkLabel myDeepLinkUrl;
    private JBLabel myLanguageLabel;
    private JBLabel myBlockedResourcesDropDownIcon;
    private JBLabel myBlockedResourcesCountLabel;
    private JPanel myBlockedResourcesDetailsPanel;
    private JBLabel myBlockedResourcesIcon;
    private HyperlinkLabel myBlockedResourcesLearnMore;
    private JPanel myBlockedResourcesItemsPanel;
    private JBLabel myDetailsDropDownIcon;
    private JBLabel myDetailsStatusIcon;
    private JBLabel myDetailsMessageLabel;
    private JBLabel myAiaDropDownIcon;
    private JBLabel myAiaStatusIcon;
    private JBLabel myAiaMessageLabel;
    private JBLabel myCrawlerStatusIcon;
    private JBLabel myCrawlerMessageLabel;
    private JPanel myAiaItemsPanel;
    private JBLabel myAiaTitleLabel;
    private HyperlinkLabel myAiaAppUriLabel;
    private HyperlinkLabel myAiaWebUrlLabel;
    private HyperlinkLabel myCrawlerLearnMore;
    private JPanel myDetailsItemsPanel;
    private JBLabel myBlockedResourcesMessageLabel;
    private JBScrollPane myScreenshotScrollPane;
    private JBLabel myScreenshotLabel;

    private ResultPanel(@NotNull Date dateCreated, @NotNull String deepLink, @NotNull SupportedLanguage.Language language) {
        if (dateCreated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dateCreated", "com/google/appindexing/ui/ResultPanel", "<init>"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/ui/ResultPanel", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/google/appindexing/ui/ResultPanel", "<init>"));
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.initializeTitle(dateCreated, deepLink, language);
        this.add(this.myRootPanel);
    }

    public static ResultPanel buildFromSuccessFetch(@NotNull Date dateCreated, @NotNull String deepLink, @NotNull SupportedLanguage.Language language, @NotNull FetchResponse response) {
        if (dateCreated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dateCreated", "com/google/appindexing/ui/ResultPanel", "buildFromSuccessFetch"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/ui/ResultPanel", "buildFromSuccessFetch"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/google/appindexing/ui/ResultPanel", "buildFromSuccessFetch"));
        }
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/google/appindexing/ui/ResultPanel", "buildFromSuccessFetch"));
        }
        ResultPanel panel = new ResultPanel(dateCreated, deepLink, language);
        FetchAsGoogleResult result = new FetchAsGoogleResult(deepLink, response);
        panel.initializeDetailsPanel(response.getAppIndexingApiData(), result);
        panel.initializeBlockedResources(ResultPanel.getBlockedResources(response));
        Icon screenshot = ResultPanel.getScreenshot(response);
        if (screenshot != null) {
            panel.initializeScreenShot(screenshot);
        } else {
            panel.myScreenshotPanel.setVisible(false);
        }
        return panel;
    }

    public static ResultPanel buildFromFailedFetch(@NotNull Date dateCreated, @NotNull String deepLink, @NotNull SupportedLanguage.Language language, @NotNull String message) {
        if (dateCreated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dateCreated", "com/google/appindexing/ui/ResultPanel", "buildFromFailedFetch"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/ui/ResultPanel", "buildFromFailedFetch"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/google/appindexing/ui/ResultPanel", "buildFromFailedFetch"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/google/appindexing/ui/ResultPanel", "buildFromFailedFetch"));
        }
        ResultPanel panel = new ResultPanel(dateCreated, deepLink, language);
        FetchAsGoogleResult result = new FetchAsGoogleResult(message);
        panel.initializeDetailsPanel(null, result);
        panel.initializeBlockedResources(null);
        panel.myScreenshotPanel.setVisible(false);
        return panel;
    }

    private static List<String> parseResources(@Nullable List<ReferencedResource> resources) {
        ArrayList urls = Lists.newArrayList();
        if (resources == null) {
            return urls;
        }
        for (ReferencedResource r : resources) {
            JsonElement url;
            byte[] arr = Base64.decodeBase64((String)r.getResponse());
            String crawlerResponse = new String(arr);
            JsonElement json = new JsonParser().parse(crawlerResponse);
            if (!(json instanceof JsonObject) || (url = ((JsonObject)json).get("url")) == null) continue;
            urls.add(url.getAsString());
        }
        return urls;
    }

    @NotNull
    private static Icon getIcon(Result result) {
        switch (result) {
            case OK: {
                Icon icon = AllIcons.RunConfigurations.TestPassed;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel", "getIcon"));
                }
                return icon;
            }
            case WARNING: {
                Icon icon = AllIcons.RunConfigurations.TestFailed;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel", "getIcon"));
                }
                return icon;
            }
        }
        Icon icon = AllIcons.RunConfigurations.TestError;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel", "getIcon"));
        }
        return icon;
    }

    private static void bind(@NotNull JLabel iconLabel, @NotNull JPanel jPanel, JComponent ... components) {
        if (iconLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconLabel", "com/google/appindexing/ui/ResultPanel", "bind"));
        }
        if (jPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jPanel", "com/google/appindexing/ui/ResultPanel", "bind"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/google/appindexing/ui/ResultPanel", "bind"));
        }
        ClickListener clickListener = new ClickListener(iconLabel, jPanel);
        for (JComponent component : components) {
            component.addMouseListener(clickListener);
        }
    }

    @NotNull
    private static List<ReferencedResource> getBlockedResources(@NotNull FetchResponse response) {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/google/appindexing/ui/ResultPanel", "getBlockedResources"));
        }
        ArrayList ret = Lists.newArrayList();
        if (response.getReferencedResource() != null) {
            for (ReferencedResource r : response.getReferencedResource()) {
                if (r.getFetchStatus().equals("FETCHED")) continue;
                ret.add(r);
            }
        }
        ArrayList arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel", "getBlockedResources"));
        }
        return arrayList;
    }

    @Nullable
    private static Icon getScreenshot(FetchResponse response) {
        if (response.getScreenshotData() == null) {
            return null;
        }
        try {
            return new ImageIcon(ImageIO.read(new ByteArrayInputStream(response.decodeScreenshotData())));
        }
        catch (IOException e) {
            return null;
        }
    }

    private void initializeTitle(@NotNull Date dateCreated, @NotNull String deepLink, @NotNull SupportedLanguage.Language language) {
        if (dateCreated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dateCreated", "com/google/appindexing/ui/ResultPanel", "initializeTitle"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/ui/ResultPanel", "initializeTitle"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/google/appindexing/ui/ResultPanel", "initializeTitle"));
        }
        this.myDateLabel.setText(dateCreated.toString());
        this.myDeepLinkUrl.setHyperlinkText(deepLink);
        this.myDeepLinkUrl.setHyperlinkTarget(deepLink);
        this.myLanguageLabel.setText(language.getName());
    }

    private void initializeDetailsPanel(@Nullable AppIndexingApiData aiaData, @NotNull FetchAsGoogleResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/appindexing/ui/ResultPanel", "initializeDetailsPanel"));
        }
        this.myDetailsStatusIcon.setIcon(ResultPanel.getIcon(result.getOverallResult()));
        this.myDetailsMessageLabel.setText(result.getOverallMessage());
        this.myCrawlerStatusIcon.setIcon(ResultPanel.getIcon(result.getCrawlResult()));
        this.myCrawlerMessageLabel.setText(result.getCrawlMessage());
        this.myCrawlerLearnMore.setHyperlinkText("Learn more");
        this.myCrawlerLearnMore.setHyperlinkTarget("https://g.co/AppIndexing/AndroidStudio");
        this.myAiaStatusIcon.setIcon(ResultPanel.getIcon(result.getAiaResult()));
        this.myAiaMessageLabel.setText(result.getAiaMessage());
        if (aiaData != null) {
            this.myAiaTitleLabel.setText(aiaData.getTitle());
            this.myAiaAppUriLabel.setHyperlinkTarget(aiaData.getAppUri());
            this.myAiaAppUriLabel.setHyperlinkText(aiaData.getAppUri());
            this.myAiaWebUrlLabel.setHyperlinkTarget(aiaData.getWebUrl());
            this.myAiaWebUrlLabel.setHyperlinkText(aiaData.getWebUrl());
            this.myAiaDropDownIcon.setIcon(AllIcons.Nodes.TreeDownArrow);
            ResultPanel.bind((JLabel)this.myAiaDropDownIcon, this.myAiaItemsPanel, new JComponent[]{this.myAiaDropDownIcon, this.myAiaMessageLabel, this.myAiaStatusIcon});
        } else {
            Dimension d = new Dimension(AllIcons.Nodes.TreeDownArrow.getIconWidth(), AllIcons.Nodes.TreeDownArrow.getIconHeight());
            this.myAiaDropDownIcon.setPreferredSize(d);
            this.myAiaItemsPanel.setVisible(false);
        }
        this.myDetailsDropDownIcon.setIcon(AllIcons.Nodes.TreeDownArrow);
        ResultPanel.bind((JLabel)this.myDetailsDropDownIcon, this.myDetailsItemsPanel, new JComponent[]{this.myDetailsDropDownIcon, this.myDetailsMessageLabel, this.myDetailsStatusIcon});
    }

    private void initializeBlockedResources(@Nullable List<ReferencedResource> resources) {
        List<String> urls = ResultPanel.parseResources(resources);
        if (urls.isEmpty()) {
            this.mySeparator.setVisible(false);
            this.myBlockedResourcesPanel.setVisible(false);
            return;
        }
        this.myBlockedResourcesCountLabel.setText(String.format("%d blocked", urls.size()));
        this.myBlockedResourcesDropDownIcon.setIcon(AllIcons.Nodes.TreeDownArrow);
        this.myBlockedResourcesIcon.setIcon(AllIcons.RunConfigurations.TestTerminated);
        this.myBlockedResourcesLearnMore.setHyperlinkTarget("https://g.co/AppIndexing/AndroidStudio");
        this.myBlockedResourcesLearnMore.setHyperlinkText("Learn more");
        GridLayout gridLayout = new GridLayout(urls.size(), 1, 0, 5);
        this.myBlockedResourcesItemsPanel.setLayout(gridLayout);
        for (String url : urls) {
            String text = Ascii.truncate((CharSequence)url, (int)80, (String)"...");
            HyperlinkLabel link = new HyperlinkLabel(text);
            link.setHyperlinkTarget(url);
            this.myBlockedResourcesItemsPanel.add((Component)link);
        }
        ResultPanel.bind((JLabel)this.myBlockedResourcesDropDownIcon, this.myBlockedResourcesDetailsPanel, new JComponent[]{this.myBlockedResourcesMessageLabel, this.myBlockedResourcesDropDownIcon, this.myBlockedResourcesIcon});
    }

    public void initializeScreenShot(@NotNull Icon screenShot) {
        if (screenShot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenShot", "com/google/appindexing/ui/ResultPanel", "initializeScreenShot"));
        }
        this.myScreenshotLabel.setPreferredSize(new Dimension(screenShot.getIconWidth(), screenShot.getIconHeight()));
        this.myScreenshotLabel.setIcon(screenShot);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel3;
        JSeparator jSeparator;
        HyperlinkLabel hyperlinkLabel2;
        JBLabel jBLabel5;
        HyperlinkLabel hyperlinkLabel3;
        HyperlinkLabel hyperlinkLabel4;
        JBLabel jBLabel6;
        JPanel jPanel4;
        JBLabel jBLabel7;
        JBLabel jBLabel8;
        JBLabel jBLabel9;
        JBLabel jBLabel10;
        JPanel jPanel5;
        JBLabel jBLabel11;
        JBLabel jBLabel12;
        JBLabel jBLabel13;
        JPanel jPanel6;
        HyperlinkLabel hyperlinkLabel5;
        JBLabel jBLabel14;
        JBLabel jBLabel15;
        JPanel jPanel7;
        JPanel jPanel8;
        JBLabel jBLabel16;
        JBScrollPane jBScrollPane;
        JPanel jPanel9;
        JPanel jPanel10;
        this.myRootPanel = jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        this.myScreenshotPanel = jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        jPanel9.setFocusTraversalPolicyProvider(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel10.add((Component)jPanel9, gridBagConstraints);
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-5789785)), "App Preview via Google Search", 0, 0, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridBagLayout());
        ((Component)jPanel11).setBackground(new Color(-5789785));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 20, 0, 20);
        jPanel9.add((Component)jPanel11, gridBagConstraints2);
        JBLabel jBLabel17 = new JBLabel();
        jBLabel17.setIcon(new ImageIcon(this.getClass().getResource("/com/google/appindexing/icons/phone_top.png")));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 3;
        gridBagConstraints3.insets = new Insets(0, 20, 0, 20);
        jPanel11.add((Component)jBLabel17, gridBagConstraints3);
        JBLabel jBLabel18 = new JBLabel();
        jBLabel18.setIcon(new ImageIcon(this.getClass().getResource("/com/google/appindexing/icons/phone_bottom.png")));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 3;
        gridBagConstraints4.insets = new Insets(0, 20, 0, 20);
        jPanel11.add((Component)jBLabel18, gridBagConstraints4);
        JBLabel jBLabel19 = new JBLabel();
        jBLabel19.setIcon(new ImageIcon(this.getClass().getResource("/com/google/appindexing/icons/phone_left.png")));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.insets = new Insets(0, 20, 0, 0);
        jPanel11.add((Component)jBLabel19, gridBagConstraints5);
        JBLabel jBLabel20 = new JBLabel();
        jBLabel20.setIcon(new ImageIcon(this.getClass().getResource("/com/google/appindexing/icons/phone_right.png")));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.insets = new Insets(0, 0, 0, 20);
        jPanel11.add((Component)jBLabel20, gridBagConstraints6);
        this.myScreenshotScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setMinimumSize(new Dimension(320, 566));
        jBScrollPane.setPreferredSize(new Dimension(320, 566));
        jBScrollPane.setMaximumSize(new Dimension(320, 566));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 1;
        jPanel11.add((Component)jBScrollPane, gridBagConstraints7);
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myScreenshotLabel = jBLabel16 = new JBLabel();
        jBLabel16.setOpaque(true);
        jBScrollPane.setViewportView((Component)jBLabel16);
        this.myLeftPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.fill = 1;
        jPanel10.add((Component)jPanel8, gridBagConstraints8);
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-5789785)), "Test Result Details", 0, 0, null, null));
        this.myTitlePanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel21 = new JBLabel();
        jBLabel21.setText("Language:");
        jPanel7.add((Component)jBLabel21, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel22 = new JBLabel();
        jBLabel22.setText("Date:");
        jPanel7.add((Component)jBLabel22, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel23 = new JBLabel();
        jBLabel23.setText("URL:");
        jPanel7.add((Component)jBLabel23, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguageLabel = jBLabel15 = new JBLabel();
        jBLabel15.setText("(language)");
        jPanel7.add((Component)jBLabel15, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myDateLabel = jBLabel14 = new JBLabel();
        jBLabel14.setText("(date)");
        jPanel7.add((Component)jBLabel14, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myDeepLinkUrl = hyperlinkLabel5 = new HyperlinkLabel();
        jPanel7.add((Component)hyperlinkLabel5, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDetailsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDetailsDropDownIcon = jBLabel13 = new JBLabel();
        jPanel6.add((Component)jBLabel13, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDetailsStatusIcon = jBLabel12 = new JBLabel();
        jPanel6.add((Component)jBLabel12, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myDetailsMessageLabel = jBLabel11 = new JBLabel();
        jBLabel11.setText("Passing Fetches");
        jPanel6.add((Component)jBLabel11, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDetailsItemsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(1, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myAiaDropDownIcon = jBLabel10 = new JBLabel();
        jPanel5.add((Component)jBLabel10, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAiaStatusIcon = jBLabel9 = new JBLabel();
        jPanel5.add((Component)jBLabel9, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAiaMessageLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("This page sends Google app indexing api data");
        jPanel5.add((Component)jBLabel8, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCrawlerStatusIcon = jBLabel7 = new JBLabel();
        jPanel5.add((Component)jBLabel7, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAiaItemsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 2, 1, 2, 0, 3, 1, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel24 = new JBLabel();
        jBLabel24.setText("Title:");
        jPanel12.add((Component)jBLabel24, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel12.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAiaTitleLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("title");
        jPanel12.add((Component)jBLabel6, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel25 = new JBLabel();
        jBLabel25.setText("App URI:");
        jPanel13.add((Component)jBLabel25, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel13.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAiaAppUriLabel = hyperlinkLabel4 = new HyperlinkLabel();
        jPanel13.add((Component)hyperlinkLabel4, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel14, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel26 = new JBLabel();
        jBLabel26.setText("Web URL:");
        jPanel14.add((Component)jBLabel26, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel14.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAiaWebUrlLabel = hyperlinkLabel3 = new HyperlinkLabel();
        jPanel14.add((Component)hyperlinkLabel3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel15, new GridConstraints(0, 2, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCrawlerMessageLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Google can index this app page");
        jPanel15.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCrawlerLearnMore = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel15.add((Component)hyperlinkLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel15.add((Component)spacer6, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel8.add((Component)spacer7, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySeparator = jSeparator = new JSeparator();
        jPanel8.add((Component)jSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myBlockedResourcesPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myBlockedResourcesDropDownIcon = jBLabel4 = new JBLabel();
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel3.add((Component)spacer8, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBlockedResourcesIcon = jBLabel3 = new JBLabel();
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBlockedResourcesMessageLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Blocked Resources");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBlockedResourcesCountLabel = jBLabel = new JBLabel();
        jBLabel.setText("%d blocked");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBlockedResourcesDetailsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 2, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel27 = new JBLabel();
        jBLabel27.setText("Google could not fetch all resources for this page.");
        jPanel2.add((Component)jBLabel27, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel2.add((Component)spacer9, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBlockedResourcesLearnMore = hyperlinkLabel = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myBlockedResourcesItemsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class FetchAsGoogleResult {
        @NotNull
        private Result myOverallResult;
        @NotNull
        private Result myCrawlResult;
        @NotNull
        private Result myAiaResult;
        @Nullable
        private String myOverallMessage;
        @Nullable
        private String myCrawlMessage;
        @Nullable
        private String myAiaMessage;

        public FetchAsGoogleResult(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/google/appindexing/ui/ResultPanel$FetchAsGoogleResult", "<init>"));
            }
            this.myOverallResult = Result.ERROR;
            this.myCrawlResult = Result.ERROR;
            this.myAiaResult = Result.ERROR;
            this.myOverallMessage = message;
            this.myCrawlMessage = "Google can not index this page using Googlebot crawling";
            this.myAiaMessage = "Google can not index this page using the App Indexing API";
        }

        public FetchAsGoogleResult(@NotNull String deepLink, @NotNull FetchResponse response) {
            if (deepLink == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/ui/ResultPanel$FetchAsGoogleResult", "<init>"));
            }
            if (response == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "com/google/appindexing/ui/ResultPanel$FetchAsGoogleResult", "<init>"));
            }
            if (response.getAppIndexingApiData() != null) {
                AppIndexingApiData aiaData = response.getAppIndexingApiData();
                if (!FetchAsGoogleResult.match(deepLink, aiaData.getAppUri())) {
                    this.myAiaResult = Result.WARNING;
                    this.myAiaMessage = "The App URI below doesn't match the URL opened";
                } else if (aiaData.getTitle().isEmpty()) {
                    this.myAiaResult = Result.WARNING;
                    this.myAiaMessage = "Google can not index this page using the App Indexing API, because the title is empty";
                } else {
                    this.myAiaResult = Result.OK;
                    this.myAiaMessage = "Google can index this page using the App Indexing API";
                }
            } else {
                this.myAiaResult = Result.WARNING;
                this.myAiaMessage = "Google can not index this page using the App Indexing API";
            }
            if (ResultPanel.getBlockedResources(response).isEmpty()) {
                this.myCrawlResult = Result.OK;
                this.myCrawlMessage = "Google can index this page using Googlebot crawling";
            } else {
                this.myCrawlResult = Result.WARNING;
                this.myCrawlMessage = "Google can index this page using Googlebot crawling but identified blocked resources";
            }
            if (this.myAiaResult == Result.OK && this.myCrawlResult == Result.OK) {
                this.myOverallResult = Result.OK;
                this.myOverallMessage = "Google can index this page";
            } else if (this.myAiaResult == Result.OK) {
                this.myOverallResult = Result.OK;
                this.myOverallMessage = "Google can index this page using one of the following methods";
                if (this.myCrawlResult == Result.ERROR) {
                    this.myCrawlResult = Result.WARNING;
                    this.myCrawlMessage = "Google still can not access the page content";
                }
            } else if (this.myCrawlResult == Result.OK) {
                this.myOverallResult = Result.OK;
                this.myOverallMessage = "Google can index this page using one of the following methods";
            } else if (this.myCrawlResult == Result.WARNING) {
                this.myOverallResult = Result.WARNING;
                this.myOverallMessage = "Google can partially index this page using one of the following methods";
            } else {
                this.myOverallResult = Result.ERROR;
                this.myOverallMessage = "Google can not index this page";
            }
        }

        private static boolean match(String deepLink, String appUri) {
            String[] arr1 = deepLink.split("\\W+");
            String[] arr2 = appUri.split("\\W+");
            int i = arr1.length - 1;
            for (int j = arr2.length - 1; i >= 0 && j >= 0 && arr1[i].equalsIgnoreCase(arr2[j]); --i, --j) {
            }
            return i == -1;
        }

        @NotNull
        public Result getOverallResult() {
            Result result = this.myOverallResult;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel$FetchAsGoogleResult", "getOverallResult"));
            }
            return result;
        }

        @NotNull
        public Result getCrawlResult() {
            Result result = this.myCrawlResult;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel$FetchAsGoogleResult", "getCrawlResult"));
            }
            return result;
        }

        @NotNull
        public Result getAiaResult() {
            Result result = this.myAiaResult;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/ResultPanel$FetchAsGoogleResult", "getAiaResult"));
            }
            return result;
        }

        @Nullable
        public String getOverallMessage() {
            return this.myOverallMessage;
        }

        @Nullable
        public String getCrawlMessage() {
            return this.myCrawlMessage;
        }

        @Nullable
        public String getAiaMessage() {
            return this.myAiaMessage;
        }
    }

    private static class ClickListener
    extends MouseAdapter {
        final JLabel myIconLabel;
        final JPanel myJPanel;

        ClickListener(@NotNull JLabel iconLabel, @NotNull JPanel jPanel) {
            if (iconLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconLabel", "com/google/appindexing/ui/ResultPanel$ClickListener", "<init>"));
            }
            if (jPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jPanel", "com/google/appindexing/ui/ResultPanel$ClickListener", "<init>"));
            }
            this.myIconLabel = iconLabel;
            this.myJPanel = jPanel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.myJPanel.setVisible(!this.myJPanel.isVisible());
            if (this.myJPanel.isVisible()) {
                this.myIconLabel.setIcon(AllIcons.Nodes.TreeDownArrow);
            } else {
                this.myIconLabel.setIcon(AllIcons.Nodes.TreeRightArrow);
            }
        }
    }

    static enum Result {
        UNKNOWN,
        OK,
        WARNING,
        ERROR;

    }
}

