/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.appindexing.editor.AppIndexingVirtualFile;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleClient;
import com.google.appindexing.fetchasgoogle.SupportedLanguage;
import com.google.appindexing.fetchasgoogle.UploadedApkManager;
import com.google.appindexing.util.ManifestUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchAsGoogleTask
implements Runnable {
    private static final Logger logger = Logger.getInstance(FetchAsGoogleTask.class);
    private Status myStatus;
    private ErrorCode myErrorCode;
    private Project myProject;
    private String myDeepLink;
    private SupportedLanguage.Language myLanguage;
    private AppIndexingVirtualFile myVirtualFile;
    private FetchAsGoogleClient myFetchAsGoogleClient;
    private ApkHolder myApkHolder;
    private FetchResponse myFetchResponse;
    private Date myCreatedTime;
    private UploadedApkManager myUploadedApkManager;
    private Helper myHelper;

    public static FetchAsGoogleTask createFetchAsGoogleTask(@NotNull Project project, @NotNull Module module, @NotNull String deepLink, @NotNull SupportedLanguage.Language language) throws FetchAsGoogleClient.FetchAsGoogleException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "createFetchAsGoogleTask"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "createFetchAsGoogleTask"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "createFetchAsGoogleTask"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "createFetchAsGoogleTask"));
        }
        return new FetchAsGoogleTask(project, deepLink, language, FetchAsGoogleClient.createInstance(), UploadedApkManager.INSTANCE, new Helper(project, module));
    }

    FetchAsGoogleTask(@NotNull Project project, @NotNull String deepLink, @NotNull SupportedLanguage.Language language, @NotNull FetchAsGoogleClient fetchAsGoogleClient, @NotNull UploadedApkManager uploadedApkManager, @NotNull Helper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "<init>"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "<init>"));
        }
        if (fetchAsGoogleClient == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchAsGoogleClient", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "<init>"));
        }
        if (uploadedApkManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uploadedApkManager", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "<init>"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "<init>"));
        }
        this.myStatus = Status.NOT_STARTED;
        this.myProject = project;
        this.myDeepLink = deepLink;
        this.myLanguage = language;
        this.myCreatedTime = new Date();
        this.myFetchAsGoogleClient = fetchAsGoogleClient;
        this.myUploadedApkManager = uploadedApkManager;
        this.myHelper = helper;
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getStatus"));
        }
        return status;
    }

    @NotNull
    public ErrorCode getErrorCode() {
        ErrorCode errorCode = this.myErrorCode;
        if (errorCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getErrorCode"));
        }
        return errorCode;
    }

    @NotNull
    public Date getCreatedTime() {
        Date date = this.myCreatedTime;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getCreatedTime"));
        }
        return date;
    }

    @NotNull
    public SupportedLanguage.Language getLanguage() {
        SupportedLanguage.Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getLanguage"));
        }
        return language;
    }

    public FetchResponse getFetchResponse() {
        return this.myFetchResponse;
    }

    private void changeStatus(@NotNull Status newStatus) {
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "changeStatus"));
        }
        this.changeStatus(newStatus, null);
    }

    private void changeStatus(@NotNull Status newStatus, @Nullable ErrorCode errorCode) {
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "changeStatus"));
        }
        this.myStatus = newStatus;
        if (errorCode != null) {
            this.myErrorCode = errorCode;
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                FetchAsGoogleTask.this.myVirtualFile.fireContentChange();
            }
        }, ModalityState.any());
    }

    @NotNull
    private static ErrorCode getMappingErrorCode(FetchAsGoogleClient.FetchAsGoogleException e) {
        switch (e.getErrorCode()) {
            case UPLOAD_ERROR: {
                ErrorCode errorCode = ErrorCode.UPLOAD_APK_FAILED;
                if (errorCode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getMappingErrorCode"));
                }
                return errorCode;
            }
            case FETCH_ERROR: {
                ErrorCode errorCode = ErrorCode.FETCH_RESULT_FAILED;
                if (errorCode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getMappingErrorCode"));
                }
                return errorCode;
            }
            case NO_CREDENTIAL: {
                ErrorCode errorCode = ErrorCode.NEED_SIGNIN;
                if (errorCode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getMappingErrorCode"));
                }
                return errorCode;
            }
            case INTENT_URL_NOT_SUPPORTED: {
                ErrorCode errorCode = ErrorCode.INTENT_URL_NOT_SUPPORTED;
                if (errorCode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getMappingErrorCode"));
                }
                return errorCode;
            }
        }
        ErrorCode errorCode = ErrorCode.UNKNOWN;
        if (errorCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask", "getMappingErrorCode"));
        }
        return errorCode;
    }

    @Override
    public void run() {
        this.myVirtualFile = new AppIndexingVirtualFile(this.myDeepLink, this);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)FetchAsGoogleTask.this.myProject);
                fileEditorManager.openFile((VirtualFile)FetchAsGoogleTask.this.myVirtualFile, true);
            }
        }, ModalityState.any());
        this.changeStatus(Status.BUILDING_APK);
        if (!this.myHelper.buildApk()) {
            this.changeStatus(Status.FAIL, ErrorCode.BUILD_APK_FAILED);
            return;
        }
        try {
            this.changeStatus(Status.UPLOADING_APK);
            if (!this.uploadApkIfNeeded()) {
                this.changeStatus(Status.FAIL, ErrorCode.UPLOAD_APK_FAILED);
                return;
            }
            this.changeStatus(Status.FETCHING_RESULT);
            this.myFetchResponse = this.myFetchAsGoogleClient.fetchAsGoogle(this.myDeepLink, this.myApkHolder, this.myLanguage.getCode());
            this.changeStatus(Status.SUCCESS);
        }
        catch (FetchAsGoogleClient.FetchAsGoogleException e) {
            this.changeStatus(Status.FAIL, FetchAsGoogleTask.getMappingErrorCode(e));
            logger.warn((Throwable)e);
        }
        catch (IOException ex) {
            this.changeStatus(Status.FAIL, ErrorCode.NETWORK_ERROR);
            logger.warn((Throwable)ex);
        }
        catch (Exception exx) {
            this.changeStatus(Status.FAIL, ErrorCode.UNKNOWN);
            logger.warn((Throwable)exx);
        }
    }

    private boolean uploadApkIfNeeded() throws FetchAsGoogleClient.FetchAsGoogleException, IOException {
        File apkFile = this.myHelper.getApkFile();
        if (apkFile == null || !apkFile.exists()) {
            return false;
        }
        String packageId = this.myHelper.getPackageId();
        if (packageId == null || packageId.isEmpty()) {
            return false;
        }
        byte[] apkHash = this.myUploadedApkManager.hashApk(apkFile);
        if (apkHash == null) {
            logger.warn("Couldn't get apk file hash");
            return false;
        }
        this.myApkHolder = this.myUploadedApkManager.getApkHolder(apkHash);
        if (this.myApkHolder == null) {
            this.myApkHolder = this.myFetchAsGoogleClient.uploadApk(packageId, apkFile);
            this.myUploadedApkManager.addUploadedApk(apkHash, this.myApkHolder);
        }
        return true;
    }

    static class Helper {
        private Project myProject;
        private Module myModule;
        private static final Logger logger = Logger.getInstance(Helper.class);

        public Helper(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper", "<init>"));
            }
            this.myProject = project;
            this.myModule = module;
        }

        public boolean buildApk() {
            final AtomicBoolean success = new AtomicBoolean();
            try {
                String errorMsg;
                final Semaphore done = new Semaphore();
                done.down();
                final AtomicReference errorMsgRef = new AtomicReference();
                GradleSyncState syncState = GradleSyncState.getInstance((Project)this.myProject);
                if (syncState.isSyncNeeded() != ThreeState.NO) {
                    GradleProjectImporter.getInstance().syncProjectSynchronously(this.myProject, false, (GradleSyncListener)new GradleSyncListener.Adapter(){

                        public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper$1", "syncFailed"));
                            }
                            if (errorMessage == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper$1", "syncFailed"));
                            }
                            errorMsgRef.set(errorMessage);
                        }
                    });
                }
                if ((errorMsg = (String)errorMsgRef.get()) != null) {
                    logger.warn("Unable to launch task. Project sync failed with message: " + errorMsg);
                    return false;
                }
                final GradleInvoker gradleInvoker = GradleInvoker.getInstance((Project)this.myProject);
                final GradleInvoker.AfterGradleInvocationTask afterTask = new GradleInvoker.AfterGradleInvocationTask(){

                    public void execute(@NotNull GradleInvocationResult result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/appindexing/fetchasgoogle/FetchAsGoogleTask$Helper$2", "execute"));
                        }
                        success.set(result.isBuildSuccessful());
                        gradleInvoker.removeAfterGradleInvocationTask((GradleInvoker.AfterGradleInvocationTask)this);
                        done.up();
                    }
                };
                if (this.myProject.isDisposed()) {
                    done.up();
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            gradleInvoker.addAfterGradleInvocationTask(afterTask);
                            gradleInvoker.assemble(new Module[]{Helper.this.myModule}, GradleInvoker.TestCompileType.NONE);
                        }
                    });
                    done.waitFor();
                }
            }
            catch (Throwable t) {
                return false;
            }
            return success.get();
        }

        @Nullable
        public File getApkFile() {
            AndroidGradleModel model;
            File apkFile = null;
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
            if (facet != null && (model = AndroidGradleModel.get((AndroidFacet)facet)) != null) {
                AndroidArtifact artifact = model.getMainArtifact();
                for (AndroidArtifactOutput output : artifact.getOutputs()) {
                    OutputFile file = output.getMainOutputFile();
                    apkFile = file.getOutputFile();
                }
            }
            return apkFile;
        }

        @Nullable
        public String getPackageId() {
            final AtomicReference packageId = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    XmlTag rootTag;
                    XmlFile manifestFile = ManifestUtils.getAndroidManifestPsi(Helper.this.myModule);
                    if (manifestFile != null && (rootTag = manifestFile.getRootTag()) != null) {
                        packageId.set(rootTag.getAttributeValue("package"));
                    }
                }
            }, ModalityState.any());
            return (String)packageId.get();
        }
    }

    public static enum ErrorCode {
        UNKNOWN,
        BUILD_APK_FAILED,
        UPLOAD_APK_FAILED,
        FETCH_RESULT_FAILED,
        NEED_SIGNIN,
        NETWORK_ERROR,
        INTENT_URL_NOT_SUPPORTED;

    }

    public static enum Status {
        NOT_STARTED,
        BUILDING_APK,
        UPLOADING_APK,
        FETCHING_RESULT,
        SUCCESS,
        FAIL;

    }
}

