/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.api;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StatementFilter
extends JavaRecursiveElementVisitor {
    private String myFilterString;
    private List<PsiStatement> myStatements;

    public StatementFilter(@NotNull String filterString) {
        if (filterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterString", "com/google/appindexing/api/StatementFilter", "<init>"));
        }
        this.myStatements = Lists.newArrayList();
        this.myFilterString = CharMatcher.WHITESPACE.removeFrom((CharSequence)filterString);
    }

    @NotNull
    public List<PsiStatement> getStatements() {
        List<PsiStatement> list = this.myStatements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/api/StatementFilter", "getStatements"));
        }
        return list;
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        if (CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        if (CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    @NotNull
    public static List<PsiStatement> filterCodeBlock(@NotNull String filterString, @NotNull PsiCodeBlock codeBlock) {
        if (filterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterString", "com/google/appindexing/api/StatementFilter", "filterCodeBlock"));
        }
        if (codeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBlock", "com/google/appindexing/api/StatementFilter", "filterCodeBlock"));
        }
        StatementFilter filter = new StatementFilter(filterString);
        codeBlock.accept((PsiElementVisitor)filter);
        List<PsiStatement> list = filter.getStatements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/api/StatementFilter", "filterCodeBlock"));
        }
        return list;
    }

    @NotNull
    public static List<PsiStatement> filterStatements(@NotNull String filterString, @NotNull List<PsiStatement> statements) {
        if (filterString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterString", "com/google/appindexing/api/StatementFilter", "filterStatements"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/google/appindexing/api/StatementFilter", "filterStatements"));
        }
        StatementFilter filter = new StatementFilter(filterString);
        for (PsiStatement statement : statements) {
            statement.accept((PsiElementVisitor)filter);
        }
        List<PsiStatement> list = filter.getStatements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/api/StatementFilter", "filterStatements"));
        }
        return list;
    }
}

