/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import gnu.trove.TObjectObjectProcedure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Streamable;

abstract class ObjectObjectMultiMaplet<K, V extends Streamable>
implements Streamable {
    ObjectObjectMultiMaplet() {
    }

    abstract boolean containsKey(K var1);

    abstract Collection<V> get(K var1);

    abstract void put(K var1, V var2);

    abstract void put(K var1, Collection<V> var2);

    abstract void replace(K var1, Collection<V> var2);

    abstract void putAll(ObjectObjectMultiMaplet<K, V> var1);

    abstract void replaceAll(ObjectObjectMultiMaplet<K, V> var1);

    abstract void remove(K var1);

    abstract void removeFrom(K var1, V var2);

    abstract void removeAll(K var1, Collection<V> var2);

    abstract void close();

    abstract void forEachEntry(TObjectObjectProcedure<K, Collection<V>> var1);

    abstract void flush(boolean var1);

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        final ArrayList keys = new ArrayList();
        this.forEachEntry(new TObjectObjectProcedure<K, Collection<V>>(){

            public boolean execute(K a, Collection<V> b) {
                String keyStr = a instanceof File && !SystemInfo.isFileSystemCaseSensitive ? ((File)a).getPath().toLowerCase(Locale.US) : a.toString();
                keys.add(Pair.create(a, (Object)keyStr));
                return true;
            }
        });
        Collections.sort(keys, new Comparator<Pair<K, String>>(){

            @Override
            public int compare(Pair<K, String> o1, Pair<K, String> o2) {
                return ((String)o1.second).compareTo((String)o2.second);
            }
        });
        for (Pair a : keys) {
            Collection<V> b = this.get(a.first);
            stream.print("  Key: ");
            stream.println((String)a.second);
            stream.println("  Values:");
            LinkedList<String> list = new LinkedList<String>();
            for (Streamable value : b) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream s = new PrintStream(baos);
                value.toStream(context, s);
                list.add(baos.toString());
            }
            Collections.sort(list);
            for (String l : list) {
                stream.print(l);
            }
            stream.println("  End Of Values");
        }
    }
}

