/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.Annotation;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Comment;
import lombok.ast.DescribedNode;
import lombok.ast.EnumConstantTemplate;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.JavadocContainer;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeBody;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeMember;
import lombok.ast.TypeMemberMixin;

public class EnumConstant
extends AbstractNode
implements TypeMember,
DescribedNode,
JavadocContainer {
    private AbstractNode javadoc = null;
    ListAccessor<Annotation, EnumConstant> annotations = ListAccessor.of(this, Annotation.class, "EnumConstant.annotations");
    private AbstractNode name = this.adopt(new Identifier());
    ListAccessor<Expression, EnumConstant> arguments = ListAccessor.of(this, Expression.class, "EnumConstant.arguments");
    private AbstractNode body = null;

    public EnumTypeBody upToEnumTypeBody() {
        if (!(this.getParent() instanceof EnumTypeBody)) {
            return null;
        }
        EnumTypeBody out = (EnumTypeBody)this.getParent();
        if (!out.rawConstants().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public TypeBody upToTypeBody() {
        if (!(this.getParent() instanceof TypeBody)) {
            return null;
        }
        TypeBody out = (TypeBody)this.getParent();
        if (!out.rawMembers().contains(this)) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public EnumConstant astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public EnumConstant rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    public RawListAccessor<Annotation, EnumConstant> rawAnnotations() {
        return this.annotations.asRaw();
    }

    public StrictListAccessor<Annotation, EnumConstant> astAnnotations() {
        return this.annotations.asStrict();
    }

    public Identifier astName() {
        if (!(this.name instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.name;
    }

    public EnumConstant astName(Identifier name) {
        return this.rawName(name);
    }

    private EnumConstant rawName(Node name) {
        if (name == this.name) {
            return this;
        }
        if (name != null) {
            this.adopt((AbstractNode)name);
        }
        if (this.name != null) {
            this.disown(this.name);
        }
        this.name = (AbstractNode)name;
        return this;
    }

    public RawListAccessor<Expression, EnumConstant> rawArguments() {
        return this.arguments.asRaw();
    }

    public StrictListAccessor<Expression, EnumConstant> astArguments() {
        return this.arguments.asStrict();
    }

    public NormalTypeBody astBody() {
        if (!(this.body instanceof NormalTypeBody)) {
            return null;
        }
        return (NormalTypeBody)this.body;
    }

    public EnumConstant astBody(NormalTypeBody body) {
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public EnumConstant rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        result.addAll(this.annotations.backingList());
        if (this.name != null) {
            result.add(this.name);
        }
        result.addAll(this.arguments.backingList());
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.rawAnnotations().replace(original, replacement)) {
            return true;
        }
        if (this.name == original) {
            if (replacement instanceof Identifier) {
                this.astName((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        if (this.rawArguments().replace(original, replacement)) {
            return true;
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.rawAnnotations().remove(child)) {
            return true;
        }
        if (this.name == child) {
            this.disown((AbstractNode)child);
            this.name = null;
            return true;
        }
        if (this.rawArguments().remove(child)) {
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitEnumConstant(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        for (AbstractNode child : this.annotations.asIterable()) {
            child.accept(visitor);
        }
        if (this.name != null) {
            this.name.accept(visitor);
        }
        for (AbstractNode child : this.arguments.asIterable()) {
            child.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public EnumConstant copy() {
        EnumConstant result = new EnumConstant();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        for (AbstractNode n : this.annotations.backingList()) {
            result.rawAnnotations().addToEnd(n == null ? null : n.copy());
        }
        if (this.name != null) {
            result.rawName(this.name.copy());
        }
        for (AbstractNode n : this.arguments.backingList()) {
            result.rawArguments().addToEnd(n == null ? null : n.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return EnumConstantTemplate.getDescription(this);
    }

    public TypeDeclaration upUpToTypeDeclaration() {
        return TypeMemberMixin.upUpToTypeDeclaration(this);
    }
}

