/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.BinaryExpressionTemplate;
import lombok.ast.BinaryOperator;
import lombok.ast.DescribedNode;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.Node;
import lombok.ast.Position;

public class BinaryExpression
extends AbstractNode
implements Expression,
DescribedNode {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode left = null;
    private BinaryOperator operator = null;
    private String rawOperator;
    private String errorReasonForOperator = "missing operator";
    private AbstractNode right = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public Expression astLeft() {
        if (!(this.left instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.left);
    }

    public BinaryExpression astLeft(Expression left) {
        if (left == null) {
            throw new NullPointerException("left is mandatory");
        }
        return this.rawLeft(left);
    }

    public Node rawLeft() {
        return this.left;
    }

    public BinaryExpression rawLeft(Node left) {
        if (left == this.left) {
            return this;
        }
        if (left != null) {
            this.adopt((AbstractNode)left);
        }
        if (this.left != null) {
            this.disown(this.left);
        }
        this.left = (AbstractNode)left;
        return this;
    }

    public BinaryOperator astOperator() {
        if (this.errorReasonForOperator != null) {
            return null;
        }
        return this.operator;
    }

    public BinaryExpression astOperator(BinaryOperator operator) {
        if (operator == null) {
            throw new NullPointerException("operator is mandatory");
        }
        this.errorReasonForOperator = null;
        this.operator = operator;
        this.rawOperator = BinaryExpressionTemplate.generateOperator(operator);
        return this;
    }

    public String rawOperator() {
        return this.rawOperator;
    }

    public String getErrorReasonForOperator() {
        return this.errorReasonForOperator;
    }

    public BinaryExpression rawOperator(String operator) {
        this.rawOperator = operator;
        this.operator = null;
        this.errorReasonForOperator = null;
        try {
            this.operator = BinaryExpressionTemplate.parseOperator(operator);
        }
        catch (IllegalArgumentException e) {
            this.errorReasonForOperator = e.getMessage() == null ? e.toString() : e.getMessage();
        }
        catch (Exception e) {
            this.errorReasonForOperator = e.toString();
        }
        return this;
    }

    public Expression astRight() {
        if (!(this.right instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.right);
    }

    public BinaryExpression astRight(Expression right) {
        if (right == null) {
            throw new NullPointerException("right is mandatory");
        }
        return this.rawRight(right);
    }

    public Node rawRight() {
        return this.right;
    }

    public BinaryExpression rawRight(Node right) {
        if (right == this.right) {
            return this;
        }
        if (right != null) {
            this.adopt((AbstractNode)right);
        }
        if (this.right != null) {
            this.disown(this.right);
        }
        this.right = (AbstractNode)right;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.left != null) {
            result.add(this.left);
        }
        if (this.right != null) {
            result.add(this.right);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.left == original) {
            this.rawLeft(replacement);
            return true;
        }
        if (this.right == original) {
            this.rawRight(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.left == child) {
            this.disown((AbstractNode)child);
            this.left = null;
            return true;
        }
        if (this.right == child) {
            this.disown((AbstractNode)child);
            this.right = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitBinaryExpression(this)) {
            return;
        }
        if (this.left != null) {
            this.left.accept(visitor);
        }
        if (this.right != null) {
            this.right.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public BinaryExpression copy() {
        BinaryExpression result = new BinaryExpression();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.left != null) {
            result.rawLeft(this.left.copy());
        }
        result.operator = this.operator;
        result.rawOperator = this.rawOperator;
        result.errorReasonForOperator = this.errorReasonForOperator;
        if (this.right != null) {
            result.rawRight(this.right.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return BinaryExpressionTemplate.getDescription(this);
    }

    @Override
    public boolean needsParentheses() {
        return BinaryExpressionTemplate.needsParentheses(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

