/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.annotation.Annotation;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractModelCreationRuleExtractor<T extends Annotation>
extends AbstractAnnotationDrivenModelRuleExtractor<T> {
    protected String determineModelName(MethodRuleDefinition<?, ?> ruleDefinition) {
        String annotationValue = this.getNameFromAnnotation(ruleDefinition);
        String modelName = annotationValue == null || annotationValue.isEmpty() ? ruleDefinition.getMethodName() : annotationValue;
        try {
            ModelPath.validatePath(modelName);
        }
        catch (Exception e) {
            throw new InvalidModelRuleDeclarationException(String.format("Path of declared model element created by rule %s is invalid.", ruleDefinition.getDescriptor()), (Throwable)e);
        }
        return modelName;
    }

    protected abstract String getNameFromAnnotation(MethodRuleDefinition<?, ?> var1);
}

