/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.GithubRepoOrg;
import org.jetbrains.plugins.github.api.GithubUserRaw;

class GithubRepoRaw
implements DataConstructor {
    @Nullable
    public Long id;
    @Nullable
    public String name;
    @Nullable
    public String fullName;
    @Nullable
    public String description;
    @SerializedName(value="private")
    @Nullable
    public Boolean isPrivate;
    @SerializedName(value="fork")
    @Nullable
    public Boolean isFork;
    @Nullable
    public String url;
    @Nullable
    public String htmlUrl;
    @Nullable
    public String cloneUrl;
    @Nullable
    public String gitUrl;
    @Nullable
    public String sshUrl;
    @Nullable
    public String svnUrl;
    @Nullable
    public String mirrorUrl;
    @Nullable
    public String homepage;
    @Nullable
    public String language;
    @Nullable
    public Integer size;
    @Nullable
    public Integer forks;
    @Nullable
    public Integer forksCount;
    @Nullable
    public Integer watchers;
    @Nullable
    public Integer watchersCount;
    @Nullable
    public Integer openIssues;
    @Nullable
    public Integer openIssuesCount;
    @Nullable
    public String masterBranch;
    @Nullable
    public String defaultBranch;
    @Nullable
    public Boolean hasIssues;
    @Nullable
    public Boolean hasWiki;
    @Nullable
    public Boolean hasDownloads;
    @Nullable
    public GithubRepoRaw parent;
    @Nullable
    public GithubRepoRaw source;
    @Nullable
    public GithubUserRaw owner;
    @Nullable
    public GithubUserRaw organization;
    @Nullable
    public Date pushedAt;
    @Nullable
    public Date createdAt;
    @Nullable
    public Date updatedAt;
    @Nullable
    public Permissions permissions;

    GithubRepoRaw() {
    }

    @NotNull
    public GithubRepo createRepo() {
        GithubRepo githubRepo = new GithubRepo(this.name, this.description, this.isPrivate, this.isFork, this.htmlUrl, this.cloneUrl, this.defaultBranch, this.owner.createUser());
        if (githubRepo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw", "createRepo"));
        }
        return githubRepo;
    }

    @NotNull
    public GithubRepoOrg createRepoOrg() {
        GithubRepoOrg githubRepoOrg = new GithubRepoOrg(this.name, this.description, this.isPrivate, this.isFork, this.htmlUrl, this.cloneUrl, this.defaultBranch, this.owner.createUser(), this.permissions.create());
        if (githubRepoOrg == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw", "createRepoOrg"));
        }
        return githubRepoOrg;
    }

    @NotNull
    public GithubRepoDetailed createRepoDetailed() {
        GithubRepo parent = this.parent == null ? null : this.parent.createRepo();
        GithubRepo source = this.source == null ? null : this.source.createRepo();
        GithubRepoDetailed githubRepoDetailed = new GithubRepoDetailed(this.name, this.description, this.isPrivate, this.isFork, this.htmlUrl, this.cloneUrl, this.defaultBranch, this.owner.createUser(), parent, source);
        if (githubRepoDetailed == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw", "createRepoDetailed"));
        }
        return githubRepoDetailed;
    }

    @Override
    @NotNull
    public <T> T create(@NotNull Class<T> resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultClass", "org/jetbrains/plugins/github/api/GithubRepoRaw", "create"));
        }
        if (resultClass == GithubRepo.class) {
            GithubRepo githubRepo = this.createRepo();
            if (githubRepo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw", "create"));
            }
            return (T)githubRepo;
        }
        if (resultClass == GithubRepoOrg.class) {
            GithubRepoOrg githubRepoOrg = this.createRepoOrg();
            if (githubRepoOrg == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw", "create"));
            }
            return (T)githubRepoOrg;
        }
        if (resultClass == GithubRepoDetailed.class) {
            GithubRepoDetailed githubRepoDetailed = this.createRepoDetailed();
            if (githubRepoDetailed == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw", "create"));
            }
            return (T)githubRepoDetailed;
        }
        throw new ClassCastException(this.getClass().getName() + ": bad class type: " + resultClass.getName());
    }

    public static class Permissions {
        @Nullable
        public Boolean admin;
        @Nullable
        public Boolean pull;
        @Nullable
        public Boolean push;

        @NotNull
        public GithubRepoOrg.Permissions create() {
            GithubRepoOrg.Permissions permissions = new GithubRepoOrg.Permissions(this.admin, this.pull, this.push);
            if (permissions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubRepoRaw$Permissions", "create"));
            }
            return permissions;
        }
    }
}

