/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Channel;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.sdkv2.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdkv2.StudioDownloader;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.StudioSdkUtil;
import com.android.tools.idea.sdkv2.StudioSettingsController;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AncestorListenerAdapter;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigurable
implements SearchableConfigurable {
    private SdkUpdaterConfigPanel myPanel;
    private Channel myCurrentChannel;
    private Runnable myChannelChangedCallback;

    @NotNull
    public String getId() {
        if ("AndroidSdkUpdater" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/SdkUpdaterConfigurable", "getId"));
        }
        return "AndroidSdkUpdater";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Updater";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        this.myChannelChangedCallback = new Runnable(){

            @Override
            public void run() {
                Channel channel = StudioSettingsController.getInstance().getChannel();
                if (SdkUpdaterConfigurable.this.myCurrentChannel == null) {
                    SdkUpdaterConfigurable.this.myCurrentChannel = channel;
                }
                if (!Objects.equal((Object)channel, (Object)SdkUpdaterConfigurable.this.myCurrentChannel)) {
                    SdkUpdaterConfigurable.this.myCurrentChannel = channel;
                    SdkUpdaterConfigurable.this.myPanel.refresh();
                }
            }
        };
        this.myPanel = new SdkUpdaterConfigPanel(this.myChannelChangedCallback, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), this);
        JComponent component = this.myPanel.getComponent();
        component.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                SdkUpdaterConfigurable.this.myChannelChangedCallback.run();
            }
        });
        return this.myPanel.getComponent();
    }

    AndroidSdkHandler getSdkHandler() {
        return AndroidSdkUtils.tryToChooseSdkHandler();
    }

    RepoManager getRepoManager() {
        return this.getSdkHandler().getSdkManager((com.android.repository.api.ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
    }

    public boolean isModified() {
        Configurable updatesConfigurable;
        if (this.myPanel.isModified()) {
            return true;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel.getComponent());
        Settings data = (Settings)Settings.KEY.getData(dataContext);
        if (data != null && (updatesConfigurable = data.find("preferences.updates")) != null) {
            return updatesConfigurable.isModified();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply() throws ConfigurationException {
        this.myPanel.saveSources();
        HtmlBuilder message = new HtmlBuilder();
        message.openHtmlBody();
        final ArrayList toDelete = Lists.newArrayList();
        HashMap requestedPackages = Maps.newHashMap();
        for (NodeStateHolder nodeStateHolder : this.myPanel.getStates()) {
            if (nodeStateHolder.getState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
                if (!nodeStateHolder.getPkg().hasLocal()) continue;
                toDelete.add(nodeStateHolder.getPkg().getLocal());
                continue;
            }
            if (nodeStateHolder.getState() != NodeStateHolder.SelectedState.INSTALLED || !nodeStateHolder.getPkg().isUpdate() && nodeStateHolder.getPkg().hasLocal()) continue;
            UpdatablePackage pkg = nodeStateHolder.getPkg();
            requestedPackages.put(pkg.getRemote(), pkg);
        }
        boolean found = false;
        if (!toDelete.isEmpty()) {
            found = true;
            message.add("The following components will be deleted: \n");
            message.beginList();
            for (LocalPackage item : toDelete) {
                message.listItem().add(item.getDisplayName()).add(", Revision: ").add(item.getVersion().toString());
            }
            message.endList();
        }
        if (!requestedPackages.isEmpty()) {
            found = true;
            message.add("The following components will be installed: \n");
            message.beginList();
            HashMultimap hashMultimap = HashMultimap.create();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
            RepositoryPackages packages = this.getRepoManager().getPackages();
            for (RemotePackage item : requestedPackages.keySet()) {
                List packageDependencies = InstallerUtil.computeRequiredPackages((Collection)ImmutableList.of((Object)item), (RepositoryPackages)packages, (com.android.repository.api.ProgressIndicator)progress);
                if (packageDependencies == null) {
                    Messages.showErrorDialog((Project)null, (String)("Unable to resolve dependencies for " + item.getDisplayName()), (String)"Dependency Error");
                    throw new ConfigurationException("Unable to resolve dependencies.");
                }
                for (RemotePackage dependency : packageDependencies) {
                    hashMultimap.put((Object)dependency, (Object)item);
                }
                message.listItem().add(String.format("%1$s %2$s %3$s", item.getDisplayName(), item.getTypeDetails() instanceof DetailsTypes.ApiDetailsType ? "revision" : "version", item.getVersion()));
            }
            for (RemotePackage dependency : hashMultimap.keySet()) {
                if (requestedPackages.containsKey(dependency)) continue;
                HashSet requests = Sets.newHashSet((Iterable)hashMultimap.get((Object)dependency));
                requests.remove(dependency);
                if (requests.isEmpty()) continue;
                message.listItem().add(dependency.getDisplayName()).add(" (Required by ");
                Iterator requestIterator = requests.iterator();
                message.add(((RemotePackage)requestIterator.next()).getDisplayName());
                while (requestIterator.hasNext()) {
                    message.add(", ").add(((RemotePackage)requestIterator.next()).getDisplayName());
                }
                message.add(")");
            }
            message.endList();
        }
        message.closeHtmlBody();
        if (found) {
            ModelWizardDialog modelWizardDialog;
            if (!SdkUpdaterConfigurable.confirmChange(message)) throw new ConfigurationException("Installation was canceled.");
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                    RepoProgressIndicatorAdapter repoProgress = new RepoProgressIndicatorAdapter(progress);
                    FileOp fop = FileOpUtils.create();
                    for (LocalPackage item : toDelete) {
                        StudioSdkUtil.findBestInstaller((RepoPackage)item).uninstall(item, (com.android.repository.api.ProgressIndicator)repoProgress, SdkUpdaterConfigurable.this.getRepoManager(), fop);
                    }
                }
            }, "Uninstalling", false, null, this.myPanel.getComponent());
            if (!requestedPackages.isEmpty() && (modelWizardDialog = SdkQuickfixUtils.createDialogForPackages((Component)this.myPanel.getComponent(), requestedPackages.values())) != null) {
                modelWizardDialog.show();
            }
            this.myPanel.refresh();
            return;
        } else {
            this.myChannelChangedCallback.run();
        }
    }

    private static boolean confirmChange(HtmlBuilder message) {
        String[] options = new String[]{Messages.OK_BUTTON, Messages.CANCEL_BUTTON};
        Icon icon = AllIcons.General.Warning;
        return Messages.showIdeaMessageDialog(null, (String)message.getHtml(), (String)"Confirm Change", (String[])options, (int)0, (Icon)icon, null) == 0;
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
    }
}

