/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.Archive;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.updater.SdkComponentSource;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class UpdateInfoDialog
extends AbstractUpdateDialog {
    private static final String RELEASE_NOTES_URL = "http://developer.android.com/tools/revisions/index.html";
    private final List<RemotePackage> myPackages;
    private final JComponent myComponent;

    protected UpdateInfoDialog(boolean enableLink, List<RemotePackage> packages) {
        super(enableLink);
        this.myPackages = packages;
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
        this.myComponent = new UpdateInfoPanel(this.myPackages).getRootPanel();
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList actions = ContainerUtil.newArrayList();
        actions.add(new AbstractAction("Update Now"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList paths = Lists.newArrayList();
                for (RemotePackage p : UpdateInfoDialog.this.myPackages) {
                    paths.add(p.getPath());
                }
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths((Component)UpdateInfoDialog.this.myComponent, (Collection)paths);
                if (dialog != null) {
                    dialog.show();
                }
                UpdateInfoDialog.this.close(0);
            }
        });
        actions.add(new AbstractAction("Release Notes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)UpdateInfoDialog.RELEASE_NOTES_URL);
            }
        });
        actions.add(new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                List ignores = UpdateSettings.getInstance().getIgnoredBuildNumbers();
                for (RemotePackage p : UpdateInfoDialog.this.myPackages) {
                    ignores.add(SdkComponentSource.getPackageRevisionId((RepoPackage)p));
                }
                UpdateInfoDialog.this.doCancelAction();
            }
        });
        actions.add(this.getCancelAction());
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/UpdateInfoDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getCancelButtonText() {
        return IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
    }

    private class UpdateInfoPanel {
        private JPanel myRootPanel;
        private JBLabel myPackages;
        private JBLabel myDownloadSize;
        private JEditorPane mySettingsLink;

        public UpdateInfoPanel(List<RemotePackage> packages) {
            this.$$$setupUI$$$();
            UpdateInfoDialog.this.configureMessageArea(this.mySettingsLink);
            this.myDownloadSize.setText(WelcomeUIUtils.getSizeLabel((long)this.computeDownloadSize(packages)));
            HtmlBuilder packageHtmlBuilder = new HtmlBuilder();
            packageHtmlBuilder.openHtmlBody();
            packageHtmlBuilder.beginList();
            for (RemotePackage p : packages) {
                packageHtmlBuilder.listItem().add(p.getDisplayName() + " revision " + p.getVersion());
            }
            packageHtmlBuilder.closeHtmlBody();
            this.myPackages.setText(packageHtmlBuilder.getHtml());
        }

        public JPanel getRootPanel() {
            return this.myRootPanel;
        }

        private long computeDownloadSize(List<RemotePackage> packages) {
            long size = 0L;
            for (RemotePackage pkg : packages) {
                Archive arch = pkg.getArchive();
                if (arch == null) continue;
                size += arch.getComplete().getSize();
            }
            return size;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBLabel jBLabel;
            JEditorPane jEditorPane;
            JBLabel jBLabel2;
            JPanel jPanel;
            this.myRootPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBLabel jBLabel3 = new JBLabel();
            jBLabel3.setText("<html>Updates are available for the Android SDK and Tools<br><br>Android SDK updates ensure you have the latest features and enhancements.<br>Android Studio will update the following components:</html>");
            jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 4, 0, 2, 1, 6, null, null, null));
            JBLabel jBLabel4 = new JBLabel();
            jBLabel4.setText("Download Size:");
            jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myDownloadSize = jBLabel2 = new JBLabel();
            jPanel.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.mySettingsLink = jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jPanel.add((Component)jEditorPane, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 3, null, null, null));
            this.myPackages = jBLabel = new JBLabel();
            jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myRootPanel;
        }
    }
}

