/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.manifmerger.ManifestMerger2;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class ProcessManifest
extends ManifestProcessorTask {
    private String minSdkVersion;
    private String targetSdkVersion;
    private Integer maxSdkVersion;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private File reportFile;

    @Override
    protected void doFullTaskAction() {
        File aaptManifestFile = this.getAaptFriendlyManifestOutputFile();
        String aaptFriendlyManifestOutputFilePath = aaptManifestFile == null ? null : aaptManifestFile.getAbsolutePath();
        this.getBuilder().mergeManifests(this.getMainManifest(), this.getManifestOverlays(), Collections.emptyList(), this.getPackageOverride(), this.getVersionCode(), this.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), this.getManifestOutputFile().getAbsolutePath(), aaptFriendlyManifestOutputFilePath, null, ManifestMerger2.MergeType.LIBRARY, this.variantConfiguration.getManifestPlaceholders(), Collections.emptyList(), this.getReportFile());
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    public void setMaxSdkVersion(Integer maxSdkVersion) {
        this.maxSdkVersion = maxSdkVersion;
    }

    public VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    @Input
    @Optional
    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    @InputFile
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getApplicationId();
    }

    @Input
    public int getVersionCode() {
        return this.variantConfiguration.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.variantConfiguration.getVersionName();
    }

    @InputFiles
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return ProcessManifest.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessManifest> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessManifest> getType() {
            return ProcessManifest.class;
        }

        @Override
        public void execute(ProcessManifest processManifest) {
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            final AndroidBuilder androidBuilder = this.scope.getGlobalScope().getAndroidBuilder();
            BaseVariantOutputData variantOutputData = this.scope.getVariantData().getOutputs().get(0);
            variantOutputData.manifestProcessorTask = processManifest;
            processManifest.setAndroidBuilder(androidBuilder);
            processManifest.setVariantName(config.getFullName());
            processManifest.variantConfiguration = config;
            final ProductFlavor mergedFlavor = config.getMergedFlavor();
            ConventionMappingHelper.map((Task)processManifest, "minSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (androidBuilder.isPreviewTarget()) {
                        return androidBuilder.getTargetCodename();
                    }
                    ApiVersion minSdkVersion = mergedFlavor.getMinSdkVersion();
                    if (minSdkVersion == null) {
                        return null;
                    }
                    return minSdkVersion.getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processManifest, "targetSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (androidBuilder.isPreviewTarget()) {
                        return androidBuilder.getTargetCodename();
                    }
                    ApiVersion targetSdkVersion = mergedFlavor.getTargetSdkVersion();
                    if (targetSdkVersion == null) {
                        return null;
                    }
                    return targetSdkVersion.getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processManifest, "maxSdkVersion", new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (androidBuilder.isPreviewTarget()) {
                        return null;
                    }
                    return mergedFlavor.getMaxSdkVersion();
                }
            });
            processManifest.setManifestOutputFile(variantOutputData.getScope().getManifestOutputFile());
            processManifest.setAaptFriendlyManifestOutputFile(this.scope.getAaptFriendlyManifestOutputFile());
        }
    }
}

