/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.ManifestDependencyImpl;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.ApiVersion;
import com.android.manifmerger.ManifestMerger2;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class MergeManifests
extends ManifestProcessorTask {
    private String minSdkVersion;
    private String targetSdkVersion;
    private Integer maxSdkVersion;
    private File reportFile;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private ApkVariantOutputData variantOutputData;
    private List<ManifestDependencyImpl> libraries;
    private List<ManifestMerger2.Invoker.Feature> optionalFeatures;

    @Override
    protected void doFullTaskAction() {
        this.getBuilder().mergeManifests(this.getMainManifest(), this.getManifestOverlays(), this.getLibraries(), this.getPackageOverride(), this.getVersionCode(), this.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), this.getManifestOutputFile().getAbsolutePath(), null, this.getInstantRunManifestOutputFile().getAbsolutePath(), ManifestMerger2.MergeType.APPLICATION, this.variantConfiguration.getManifestPlaceholders(), this.getOptionalFeatures(), this.getReportFile());
    }

    @InputFile
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @InputFiles
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getIdOverride();
    }

    @Input
    public int getVersionCode() {
        if (this.variantOutputData != null) {
            return this.variantOutputData.getVersionCode();
        }
        return this.variantConfiguration.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        if (this.variantOutputData != null) {
            return this.variantOutputData.getVersionName();
        }
        return this.variantConfiguration.getVersionName();
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return MergeManifests.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    @InputFiles
    List<File> getLibraryManifests() {
        List<ManifestDependencyImpl> libs = this.getLibraries();
        if (libs == null || libs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList files = Lists.newArrayListWithCapacity((int)(libs.size() * 2));
        for (ManifestDependencyImpl mdi : libs) {
            files.addAll(mdi.getAllManifests());
        }
        return files;
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion;
    }

    public void setMaxSdkVersion(Integer maxSdkVersion) {
        this.maxSdkVersion = maxSdkVersion;
    }

    @OutputFile
    @Optional
    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    @Input
    public List<ManifestMerger2.Invoker.Feature> getOptionalFeatures() {
        return this.optionalFeatures;
    }

    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    public ApkVariantOutputData getVariantOutputData() {
        return this.variantOutputData;
    }

    public void setVariantOutputData(ApkVariantOutputData variantOutputData) {
        this.variantOutputData = variantOutputData;
    }

    public List<ManifestDependencyImpl> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<ManifestDependencyImpl> libraries) {
        this.libraries = libraries;
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeManifests> {
        private final VariantOutputScope scope;
        private final List<ManifestMerger2.Invoker.Feature> optionalFeatures;

        public ConfigAction(VariantOutputScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures) {
            this.scope = scope;
            this.optionalFeatures = optionalFeatures;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<MergeManifests> getType() {
            return MergeManifests.class;
        }

        @Override
        public void execute(MergeManifests processManifestTask) {
            BaseVariantOutputData variantOutputData = this.scope.getVariantOutputData();
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantScope().getVariantData();
            final GradleVariantConfiguration config = variantData.getVariantConfiguration();
            variantOutputData.manifestProcessorTask = processManifestTask;
            processManifestTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processManifestTask.setVariantName(config.getFullName());
            processManifestTask.dependsOn(new Object[]{variantData.prepareDependenciesTask});
            if (variantData.generateApkDataTask != null) {
                processManifestTask.dependsOn(new Object[]{variantData.generateApkDataTask});
            }
            if (this.scope.getCompatibleScreensManifestTask() != null) {
                processManifestTask.dependsOn(new Object[]{this.scope.getCompatibleScreensManifestTask().getName()});
            }
            processManifestTask.setVariantConfiguration(config);
            if (variantOutputData instanceof ApkVariantOutputData) {
                processManifestTask.variantOutputData = (ApkVariantOutputData)variantOutputData;
            }
            ConventionMappingHelper.map((Task)processManifestTask, "libraries", new Callable<List<ManifestDependencyImpl>>(){

                @Override
                public List<ManifestDependencyImpl> call() throws Exception {
                    List manifests = ConfigAction.getManifestDependencies(config.getDirectLibraries());
                    if (variantData.generateApkDataTask != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                        manifests.add(new ManifestDependencyImpl(variantData.generateApkDataTask.getManifestFile(), Collections.<ManifestDependencyImpl>emptyList()));
                    }
                    if (ConfigAction.this.scope.getCompatibleScreensManifestTask() != null) {
                        manifests.add(new ManifestDependencyImpl(ConfigAction.this.scope.getCompatibleScreensManifestFile(), Collections.<ManifestDependencyImpl>emptyList()));
                    }
                    return manifests;
                }
            });
            ConventionMappingHelper.map((Task)processManifestTask, "minSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                    }
                    ApiVersion minSdk = config.getMergedFlavor().getMinSdkVersion();
                    return minSdk == null ? null : minSdk.getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processManifestTask, "targetSdkVersion", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetCodename();
                    }
                    ApiVersion targetSdk = config.getMergedFlavor().getTargetSdkVersion();
                    return targetSdk == null ? null : targetSdk.getApiString();
                }
            });
            ConventionMappingHelper.map((Task)processManifestTask, "maxSdkVersion", new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().isPreviewTarget()) {
                        return null;
                    }
                    return config.getMergedFlavor().getMaxSdkVersion();
                }
            });
            processManifestTask.setManifestOutputFile(this.scope.getManifestOutputFile());
            processManifestTask.setInstantRunManifestOutputFile(this.scope.getVariantScope().getInstantRunManifestOutputFile());
            processManifestTask.setReportFile(this.scope.getVariantScope().getManifestReportFile());
            processManifestTask.optionalFeatures = this.optionalFeatures;
        }

        private static List<ManifestDependencyImpl> getManifestDependencies(List<LibraryDependency> libraries) {
            ArrayList list = Lists.newArrayListWithCapacity((int)libraries.size());
            for (LibraryDependency lib : libraries) {
                if (lib.isOptional()) continue;
                List<ManifestDependencyImpl> children = ConfigAction.getManifestDependencies(lib.getDependencies());
                list.add(new ManifestDependencyImpl(lib.getName(), lib.getManifest(), children));
            }
            return list;
        }
    }
}

