/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.ClassStructureVisitor;
import com.android.build.gradle.shrinker.DependencyFinderVisitor;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.KeepRules;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.TypeHierarchyTraverser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class FullRunShrinker<T>
extends AbstractShrinker<T> {
    static final String SHRINKER_FAKE_MARKER = "$shrinker_fake";
    private final Set<File> mPlatformJars;

    public FullRunShrinker(WaitableExecutor<Void> executor, ShrinkerGraph<T> graph, Set<File> platformJars, ShrinkerLogger shrinkerLogger) {
        super(graph, executor, shrinkerLogger);
        this.mPlatformJars = platformJars;
    }

    public void run(Collection<TransformInput> inputs, Collection<TransformInput> referencedClasses, TransformOutputProvider output, ImmutableMap<AbstractShrinker.CounterSet, KeepRules> keepRules, boolean saveState) throws IOException {
        output.deleteAll();
        this.buildGraph(inputs, referencedClasses);
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.setCounters(keepRules);
        FullRunShrinker.logTime("Set counters", stopwatch);
        this.writeOutput(inputs, output);
        FullRunShrinker.logTime("Write output", stopwatch);
        if (saveState) {
            this.mGraph.saveState();
            FullRunShrinker.logTime("Saving state", stopwatch);
        }
    }

    private void buildGraph(Iterable<TransformInput> programInputs, Iterable<TransformInput> libraryInputs) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        final PostProcessingData postProcessingData = new PostProcessingData();
        this.readPlatformJars();
        for (TransformInput input : libraryInputs) {
            for (File directory : FullRunShrinker.getAllDirectories(input)) {
                for (final File classFile : FullRunShrinker.getClassFiles(directory)) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            FullRunShrinker.this.processLibraryClass(Files.toByteArray((File)classFile));
                            return null;
                        }
                    });
                }
            }
            for (final File jarFile : FullRunShrinker.getAllJars(input)) {
                this.processJarFile(jarFile, new ByteCodeConsumer(){

                    @Override
                    public void process(byte[] bytes) throws IOException {
                        FullRunShrinker.this.processLibraryClass(bytes);
                    }
                });
            }
        }
        for (TransformInput input : programInputs) {
            for (File directory : FullRunShrinker.getAllDirectories(input)) {
                for (final File classFile : FullRunShrinker.getClassFiles(directory)) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            FullRunShrinker.this.processProgramClassFile(Files.toByteArray((File)classFile), classFile, postProcessingData);
                            return null;
                        }
                    });
                }
            }
            for (final File jarFile : FullRunShrinker.getAllJars(input)) {
                this.processJarFile(jarFile, new ByteCodeConsumer(){

                    @Override
                    public void process(byte[] bytes) throws IOException {
                        FullRunShrinker.this.processProgramClassFile(bytes, jarFile, postProcessingData);
                    }
                });
            }
        }
        this.waitForAllTasks();
        FullRunShrinker.logTime("Read input", stopwatch);
        this.handleOverrides(postProcessingData.getVirtualMethods());
        this.handleMultipleInheritance(postProcessingData.getMultipleInheritance());
        this.handleInterfaceInheritance(postProcessingData.getInterfaceInheritance());
        this.resolveReferences(postProcessingData.getUnresolvedReferences());
        this.waitForAllTasks();
        FullRunShrinker.logTime("Finish graph", stopwatch);
        this.mGraph.checkDependencies(this.mShrinkerLogger);
    }

    private void handleInterfaceInheritance(Set<T> interfaceInheritance) {
        for (final T klass : interfaceInheritance) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TypeHierarchyTraverser interfaceTraverser = TypeHierarchyTraverser.interfaces(FullRunShrinker.this.mGraph, FullRunShrinker.this.mShrinkerLogger);
                    if ((FullRunShrinker.this.mGraph.getClassModifiers(klass) & 0x200) != 0) {
                        Iterable superinterfaces = interfaceTraverser.children(klass);
                        for (Object superinterface : superinterfaces) {
                            if (!FullRunShrinker.this.mGraph.isLibraryClass(superinterface)) {
                                FullRunShrinker.this.mGraph.addDependency(superinterface, klass, DependencyType.SUPERINTERFACE_KEPT);
                                continue;
                            }
                            FullRunShrinker.this.mGraph.incrementAndCheck(klass, DependencyType.SUPERINTERFACE_KEPT, AbstractShrinker.CounterSet.SHRINK);
                        }
                    }
                    for (Object iface : interfaceTraverser.preOrderTraversal(klass)) {
                        if (FullRunShrinker.this.mGraph.isLibraryClass(iface)) continue;
                        FullRunShrinker.this.mGraph.addDependency(klass, iface, DependencyType.INTERFACE_IMPLEMENTED);
                    }
                    return null;
                }
            });
        }
    }

    private static FluentIterable<File> getClassFiles(File dir) {
        return FileUtils.getAllFiles((File)dir).filter(FileUtils.withExtension((String)"class"));
    }

    private void handleMultipleInheritance(Set<T> multipleInheritance) {
        for (final T klass : multipleInheritance) {
            this.mExecutor.execute((Callable)new Callable<Void>(){
                Set<T> methods;
                {
                    this.methods = FullRunShrinker.this.mGraph.getMethods(klass);
                }

                @Override
                public Void call() throws Exception {
                    if (!FullRunShrinker.this.isProgramClass(FullRunShrinker.this.mGraph.getSuperclass(klass))) {
                        return null;
                    }
                    FluentIterable interfaces = TypeHierarchyTraverser.interfaces(FullRunShrinker.this.mGraph, FullRunShrinker.this.mShrinkerLogger).preOrderTraversal(klass);
                    for (Object iface : interfaces) {
                        for (Object method : FullRunShrinker.this.mGraph.getMethods(iface)) {
                            this.handleMethod(method);
                        }
                    }
                    return null;
                }

                private void handleMethod(T method) {
                    if (this.methods.contains(method)) {
                        return;
                    }
                    FluentIterable superclasses = TypeHierarchyTraverser.superclasses(FullRunShrinker.this.mGraph, FullRunShrinker.this.mShrinkerLogger).preOrderTraversal(klass);
                    for (Object current : superclasses) {
                        if (!FullRunShrinker.this.isProgramClass(current)) {
                            return;
                        }
                        Object matchingMethod = FullRunShrinker.this.mGraph.findMatchingMethod(current, method);
                        if (matchingMethod == null) continue;
                        String name = FullRunShrinker.this.mGraph.getMethodNameAndDesc(method);
                        String desc = name.substring(name.indexOf(58) + 1);
                        name = name.substring(0, name.indexOf(58));
                        name = name + FullRunShrinker.SHRINKER_FAKE_MARKER;
                        Object fakeMethod = FullRunShrinker.this.mGraph.addMember(klass, name, desc, FullRunShrinker.this.mGraph.getMemberModifiers(method));
                        FullRunShrinker.this.mGraph.addDependency(fakeMethod, matchingMethod, DependencyType.REQUIRED_CLASS_STRUCTURE);
                        if (!FullRunShrinker.this.isProgramClass(FullRunShrinker.this.mGraph.getClassForMember(method))) {
                            FullRunShrinker.this.mGraph.addDependency(klass, fakeMethod, DependencyType.REQUIRED_CLASS_STRUCTURE);
                        } else {
                            FullRunShrinker.this.mGraph.addDependency(klass, fakeMethod, DependencyType.CLASS_IS_KEPT);
                            FullRunShrinker.this.mGraph.addDependency(method, fakeMethod, DependencyType.IF_CLASS_KEPT);
                        }
                        return;
                    }
                }
            });
        }
    }

    private void handleOverrides(Set<T> virtualMethods) {
        for (final T method : virtualMethods) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    String methodNameAndDesc = FullRunShrinker.this.mGraph.getMethodNameAndDesc(method);
                    if (FullRunShrinker.isJavaLangObjectMethod(methodNameAndDesc)) {
                        FullRunShrinker.this.mGraph.addDependency(FullRunShrinker.this.mGraph.getClassForMember(method), method, DependencyType.REQUIRED_CLASS_STRUCTURE);
                        return null;
                    }
                    FluentIterable superTypes = TypeHierarchyTraverser.superclassesAndInterfaces(FullRunShrinker.this.mGraph, FullRunShrinker.this.mShrinkerLogger).preOrderTraversal(FullRunShrinker.this.mGraph.getClassForMember(method));
                    for (Object klass : superTypes) {
                        Object superMethod;
                        if (FullRunShrinker.this.mGraph.getClassName(klass).equals("java/lang/Object") || (superMethod = FullRunShrinker.this.mGraph.findMatchingMethod(klass, method)) == null || superMethod.equals(method)) continue;
                        if (!FullRunShrinker.this.isProgramClass(FullRunShrinker.this.mGraph.getClassForMember(superMethod))) {
                            FullRunShrinker.this.mGraph.addDependency(FullRunShrinker.this.mGraph.getClassForMember(method), method, DependencyType.REQUIRED_CLASS_STRUCTURE);
                            return null;
                        }
                        FullRunShrinker.this.mGraph.addDependency(FullRunShrinker.this.mGraph.getClassForMember(method), method, DependencyType.CLASS_IS_KEPT);
                        FullRunShrinker.this.mGraph.addDependency(superMethod, method, DependencyType.IF_CLASS_KEPT);
                    }
                    return null;
                }
            });
        }
    }

    private static boolean isJavaLangObjectMethod(String nameAndDesc) {
        return nameAndDesc.equals("hashCode:()I") || nameAndDesc.equals("equals:(Ljava/lang/Object;)Z") || nameAndDesc.equals("toString:()Ljava/lang/String;");
    }

    private void processLibraryClass(byte[] source) throws IOException {
        ClassReader classReader = new ClassReader(source);
        classReader.accept(new ClassStructureVisitor(this.mGraph, null, null), 7);
    }

    private void processProgramClassFile(byte[] bytes, File classFile, final PostProcessingData<T> postProcessingData) throws IOException {
        ClassNode classNode = new ClassNode(327680);
        DependencyFinderVisitor depsFinder = new DependencyFinderVisitor<T>(this.mGraph, (ClassVisitor)classNode){

            @Override
            protected void handleDependency(T source, T target, DependencyType type) {
                FullRunShrinker.this.mGraph.addDependency(source, target, type);
            }

            @Override
            protected void handleMultipleInheritance(T klass) {
                postProcessingData.getMultipleInheritance().add(klass);
            }

            @Override
            protected void handleVirtualMethod(T method) {
                postProcessingData.getVirtualMethods().add(method);
            }

            @Override
            protected void handleInterfaceInheritance(T klass) {
                postProcessingData.getInterfaceInheritance().add(klass);
            }

            @Override
            protected void handleUnresolvedReference(PostProcessingData.UnresolvedReference<T> reference) {
                postProcessingData.getUnresolvedReferences().add(reference);
            }
        };
        ClassStructureVisitor structureVisitor = new ClassStructureVisitor(this.mGraph, classFile, depsFinder);
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(structureVisitor, 6);
    }

    private void readPlatformJars() throws IOException {
        for (File platformJar : this.mPlatformJars) {
            this.processJarFile(platformJar, new ByteCodeConsumer(){

                @Override
                public void process(byte[] bytes) throws IOException {
                    FullRunShrinker.this.processLibraryClass(bytes);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarFile(File platformJar, final ByteCodeConsumer consumer) throws IOException {
        JarFile jarFile = new JarFile(platformJar);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                InputStream inputStream = jarFile.getInputStream(entry);
                try {
                    final byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            consumer.process(bytes);
                            return null;
                        }
                    });
                }
                finally {
                    inputStream.close();
                }
            }
        }
        finally {
            jarFile.close();
        }
    }

    private void setCounters(ImmutableMap<AbstractShrinker.CounterSet, KeepRules> allKeepRules) {
        final AbstractShrinker.CounterSet counterSet = AbstractShrinker.CounterSet.SHRINK;
        final KeepRules keepRules = (KeepRules)allKeepRules.get((Object)counterSet);
        for (final Object klass : this.mGraph.getAllProgramClasses()) {
            this.mExecutor.execute((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    FullRunShrinker.this.mGraph.addRoots(keepRules.getSymbolsToKeep(klass, FullRunShrinker.this.mGraph), counterSet);
                    return null;
                }
            });
        }
        this.waitForAllTasks();
        this.setCounters(counterSet);
    }

    private void writeOutput(Collection<TransformInput> inputs, TransformOutputProvider output) throws IOException {
        this.updateClassFiles(this.mGraph.getReachableClasses(AbstractShrinker.CounterSet.SHRINK), Collections.<File>emptyList(), inputs, output);
    }

    private static interface ByteCodeConsumer {
        public void process(byte[] var1) throws IOException;
    }
}

