/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.transforms.JarMerger;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.signing.SignedJarBuilder;
import com.android.ide.common.packaging.PackagingUtils;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MergeJavaResourcesTransform
extends Transform {
    private final PackagingOptions packagingOptions;
    private final String name;
    private final Set<QualifiedContent.Scope> mergeScopes;
    private final Set<QualifiedContent.ContentType> mergedType;
    private final FileValidator validator;

    public MergeJavaResourcesTransform(PackagingOptions packagingOptions, Set<QualifiedContent.Scope> mergeScopes, QualifiedContent.ContentType mergedType, String name) {
        this.packagingOptions = packagingOptions;
        this.name = name;
        this.mergeScopes = Sets.immutableEnumSet(mergeScopes);
        this.mergedType = ImmutableSet.of((Object)mergedType);
        if (mergedType == QualifiedContent.DefaultContentType.RESOURCES) {
            this.validator = new FileValidator(){

                @Override
                public boolean validateJarPath(String path) {
                    return !path.endsWith(".class") && !path.endsWith(".so");
                }

                @Override
                public boolean validateFolderPath(String path) {
                    return !path.endsWith(".class") && !path.endsWith(".so");
                }

                @Override
                public String folderPathToKey(String path) {
                    return path;
                }

                @Override
                public String keyToFolderPath(String path) {
                    return path;
                }
            };
        } else if (mergedType == ExtendedContentType.NATIVE_LIBS) {
            this.validator = new NativeLibValidator();
        } else {
            throw new UnsupportedOperationException("mergedType param must be RESOURCES or NATIVE_LIBS");
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return this.mergedType;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return this.mergeScopes;
    }

    public Map<String, Object> getParameterInputs() {
        return ImmutableMap.of();
    }

    public boolean isIncremental() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException {
        TransformOutputProvider outputProvider = invocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        File outFolder = null;
        File outJar = null;
        if (!invocation.isIncremental()) {
            outputProvider.deleteAll();
            ArrayListMultimap sourceFileList = ArrayListMultimap.create();
            for (TransformInput input : invocation.getInputs()) {
                for (JarInput jarInput : input.getJarInputs()) {
                    this.gatherListFromJar(jarInput, (ListMultimap<String, QualifiedContent>)sourceFileList);
                }
                for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                    this.gatherListFromFolder(directoryInput, (ListMultimap<String, QualifiedContent>)sourceFileList);
                }
            }
            ArrayListMultimap mergedFiles = ArrayListMultimap.create();
            ArrayListMultimap jarSources = ArrayListMultimap.create();
            for (String key : sourceFileList.keySet()) {
                PackagingOptions.Action packagingAction = this.packagingOptions.getAction(key);
                if (packagingAction == PackagingOptions.Action.EXCLUDE) continue;
                List contentSourceList = sourceFileList.get((Object)key);
                QualifiedContent selectedContent = MergeJavaResourcesTransform.findUniqueOrProjectContent(contentSourceList);
                if (selectedContent == null) {
                    if (packagingAction == PackagingOptions.Action.PICK_FIRST) {
                        selectedContent = (QualifiedContent)contentSourceList.get(0);
                    } else if (packagingAction == PackagingOptions.Action.MERGE) {
                        for (QualifiedContent content : contentSourceList) {
                            mergedFiles.put((Object)key, (Object)content.getFile());
                        }
                    } else {
                        ArrayList sources = Lists.newArrayListWithCapacity((int)contentSourceList.size());
                        for (QualifiedContent content : contentSourceList) {
                            sources.add(content.getFile());
                        }
                        throw new TransformException((Throwable)new DuplicateFileException(key, (List)sources));
                    }
                }
                if (selectedContent == null) continue;
                if (selectedContent instanceof JarInput) {
                    jarSources.put((Object)selectedContent.getFile(), (Object)key);
                    continue;
                }
                if (outFolder == null) {
                    outFolder = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                    FileUtils.mkdirs((File)outFolder);
                }
                this.copyFromFolder(selectedContent.getFile(), outFolder, key);
            }
            JarMerger jarMerger = null;
            if (!jarSources.isEmpty()) {
                outJar = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.JAR);
                FileUtils.mkdirs((File)outJar.getParentFile());
                jarMerger = MergeJavaResourcesTransform.copyIntoJar((ListMultimap<File, String>)jarSources, outJar);
            }
            if (!mergedFiles.isEmpty()) {
                for (String key : mergedFiles.keySet()) {
                    List sourceFiles = mergedFiles.get((Object)key);
                    boolean hasJarSource = false;
                    for (File sourceFile : sourceFiles) {
                        if (!sourceFile.isDirectory()) continue;
                        hasJarSource = true;
                        break;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    for (File sourceFile : sourceFiles) {
                        if (sourceFile.isDirectory()) {
                            File actualFile = MergeJavaResourcesTransform.computeFile(sourceFile, this.validator.keyToFolderPath(key));
                            baos.write(Files.toByteArray((File)actualFile));
                            continue;
                        }
                        ZipFile zipFile = new ZipFile(sourceFile);
                        try {
                            ByteStreams.copy((InputStream)zipFile.getInputStream(zipFile.getEntry(key)), (OutputStream)baos);
                        }
                        finally {
                            zipFile.close();
                        }
                    }
                    if (hasJarSource) {
                        if (outJar == null) {
                            outJar = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.JAR);
                            FileUtils.mkdirs((File)outJar.getParentFile());
                            jarMerger = new JarMerger(outJar);
                        }
                        jarMerger.addEntry(key, baos.toByteArray());
                        continue;
                    }
                    if (outFolder == null) {
                        outFolder = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                        FileUtils.mkdirs((File)outFolder);
                    }
                    Files.write((byte[])baos.toByteArray(), (File)MergeJavaResourcesTransform.computeFile(outFolder, key));
                }
            }
            if (jarMerger != null) {
                jarMerger.close();
            }
        }
    }

    private static QualifiedContent findUniqueOrProjectContent(List<QualifiedContent> contentSourceList) {
        if (contentSourceList.size() == 1) {
            return contentSourceList.get(0);
        }
        for (QualifiedContent content : contentSourceList) {
            if (!content.getScopes().contains(QualifiedContent.Scope.PROJECT)) continue;
            return content;
        }
        return null;
    }

    private void copyFromFolder(File fromFolder, File toFolder, String path) throws IOException {
        File from = MergeJavaResourcesTransform.computeFile(fromFolder, this.validator.keyToFolderPath(path));
        File to = MergeJavaResourcesTransform.computeFile(toFolder, path);
        FileUtils.mkdirs((File)to.getParentFile());
        Files.copy((File)from, (File)to);
    }

    private static File computeFile(File rootFolder, String path) {
        path = path.replace('/', File.separatorChar);
        return new File(rootFolder, path);
    }

    private static JarMerger copyIntoJar(ListMultimap<File, String> jarSources, File outJar) throws IOException {
        JarMerger jarMerger = new JarMerger(outJar);
        JarFilter filter = new JarFilter();
        jarMerger.setFilter(filter);
        for (File jarFile : jarSources.keySet()) {
            filter.resetList(jarSources.get((Object)jarFile));
            jarMerger.addJar(jarFile, true);
        }
        return jarMerger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherListFromJar(JarInput jarInput, ListMultimap<String, QualifiedContent> content) throws IOException {
        ZipFile zipFile = new ZipFile(jarInput.getFile());
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String path;
                ZipEntry entry = entries.nextElement();
                if (this.skipEntry(entry, path = entry.getName())) continue;
                content.put((Object)path, (Object)jarInput);
            }
        }
        finally {
            zipFile.close();
        }
    }

    private boolean skipEntry(ZipEntry entry, String path) {
        if (entry.isDirectory() || "META-INF/MANIFEST.MF".equals(path) || !this.validator.validateJarPath(path)) {
            return true;
        }
        String[] segments = path.split("/");
        if (segments.length == 0) {
            return true;
        }
        for (int i = 0; i < segments.length - 1; ++i) {
            if (PackagingUtils.checkFolderForPackaging((String)segments[i])) continue;
            return true;
        }
        return !PackagingUtils.checkFileForPackaging((String)segments[segments.length - 1], (boolean)false);
    }

    private void gatherListFromFolder(DirectoryInput directoryInput, ListMultimap<String, QualifiedContent> content) {
        this.gatherListFromFolder(directoryInput.getFile(), "", directoryInput, content);
    }

    private void gatherListFromFolder(File file, String path, DirectoryInput directoryInput, ListMultimap<String, QualifiedContent> content) {
        File[] children = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return file.isDirectory() || !name.endsWith(".class");
            }
        });
        if (children != null) {
            for (File child : children) {
                String newPath;
                String string = newPath = path.isEmpty() ? child.getName() : path + '/' + child.getName();
                if (child.isDirectory()) {
                    this.gatherListFromFolder(child, newPath, directoryInput, content);
                    continue;
                }
                if (!child.isFile() || !this.validator.validateFolderPath(newPath)) continue;
                content.put((Object)this.validator.folderPathToKey(newPath), (Object)directoryInput);
            }
        }
    }

    private static class JarFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final Set<String> allowedPath = Sets.newHashSet();

        private JarFilter() {
        }

        void resetList(List<String> paths) {
            this.allowedPath.clear();
            this.allowedPath.addAll(paths);
        }

        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            return this.allowedPath.contains(archivePath);
        }
    }

    private static final class NativeLibValidator
    implements FileValidator {
        private final Pattern jarAbiPattern = Pattern.compile("lib/([^/]+)/[^/]+");
        private final Pattern folderAbiPattern = Pattern.compile("([^/]+)/[^/]+");
        private final Pattern filenamePattern = Pattern.compile(".*\\.so");

        private NativeLibValidator() {
        }

        @Override
        public boolean validateJarPath(String path) {
            Matcher m = this.jarAbiPattern.matcher(path);
            if (m.matches()) {
                String filename = path.substring(5 + m.group(1).length());
                return this.filenamePattern.matcher(filename).matches() || "gdbserver".equals(filename) || "gdb.setup".equals(filename);
            }
            return false;
        }

        @Override
        public boolean validateFolderPath(String path) {
            Matcher m = this.folderAbiPattern.matcher(path);
            if (m.matches()) {
                String filename = path.substring(1 + m.group(1).length());
                return this.filenamePattern.matcher(filename).matches() || "gdbserver".equals(filename) || "gdb.setup".equals(filename);
            }
            return false;
        }

        @Override
        public String folderPathToKey(String path) {
            return "lib/" + path;
        }

        @Override
        public String keyToFolderPath(String path) {
            return path.substring("lib".length() + 1);
        }
    }

    private static interface FileValidator {
        public boolean validateJarPath(String var1);

        public boolean validateFolderPath(String var1);

        public String folderPathToKey(String var1);

        public String keyToFolderPath(String var1);
    }
}

