/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.OptionalCompilationStep;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifier;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.api.logging.Logging;

public class InstantRunVerifierTransform
extends Transform {
    protected static final ILogger LOGGER = new LoggerWrapper(Logging.getLogger(InstantRunVerifierTransform.class));
    private final VariantScope variantScope;
    private final File outputDir;

    public InstantRunVerifierTransform(VariantScope variantScope) {
        this.variantScope = variantScope;
        this.outputDir = variantScope.getIncrementalVerifierDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        if (invocation.getReferencedInputs().isEmpty()) {
            throw new RuntimeException("Empty list of referenced inputs");
        }
        try {
            this.variantScope.getInstantRunBuildContext().startRecording(InstantRunBuildContext.TaskType.VERIFIER);
            this.doTransform(invocation.getReferencedInputs(), invocation.isIncremental());
        }
        finally {
            this.variantScope.getInstantRunBuildContext().stopRecording(InstantRunBuildContext.TaskType.VERIFIER);
        }
    }

    public void doTransform(Collection<TransformInput> inputs, boolean isIncremental) throws IOException, TransformException, InterruptedException {
        if (!isIncremental && this.outputDir.exists()) {
            FileUtils.emptyFolder((File)this.outputDir);
        } else {
            FileUtils.mkdirs((File)this.outputDir);
        }
        InstantRunVerifierStatus resultSoFar = InstantRunVerifierStatus.COMPATIBLE;
        for (TransformInput transformInput : inputs) {
            resultSoFar = this.processFolderInputs(resultSoFar, isIncremental, transformInput);
            resultSoFar = this.processJarInputs(resultSoFar, transformInput);
        }
        if (!this.variantScope.getGlobalScope().isActive(OptionalCompilationStep.RESTART_ONLY)) {
            this.variantScope.getInstantRunBuildContext().setVerifierResult(resultSoFar);
        }
    }

    private InstantRunVerifierStatus processFolderInputs(InstantRunVerifierStatus verificationResult, boolean isIncremental, TransformInput transformInput) throws IOException {
        for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
            File inputDir = directoryInput.getFile();
            if (!isIncremental) {
                for (File file : Files.fileTreeTraverser().breadthFirstTraversal((Object)inputDir)) {
                    if (file.isDirectory()) continue;
                    this.copyFile(file, InstantRunVerifierTransform.getOutputFile(inputDir, file, this.outputDir));
                }
                continue;
            }
            block8: for (Map.Entry changedFile : directoryInput.getChangedFiles().entrySet()) {
                File inputFile = (File)changedFile.getKey();
                if (inputFile.isDirectory()) continue;
                File lastIterationFile = InstantRunVerifierTransform.getOutputFile(inputDir, inputFile, this.outputDir);
                switch ((Status)changedFile.getValue()) {
                    case REMOVED: {
                        if (!lastIterationFile.exists() || lastIterationFile.delete()) continue block8;
                        LOGGER.warning("Cannot delete %1$s file", new Object[]{lastIterationFile});
                        continue block8;
                    }
                    case ADDED: {
                        this.copyFile(inputFile, lastIterationFile);
                        verificationResult = InstantRunVerifierStatus.CLASS_ADDED;
                        continue block8;
                    }
                    case CHANGED: {
                        if (verificationResult == InstantRunVerifierStatus.COMPATIBLE) {
                            if (lastIterationFile.exists()) {
                                verificationResult = this.runVerifier(inputFile.getName(), new InstantRunVerifier.ClassBytesFileProvider(lastIterationFile), new InstantRunVerifier.ClassBytesFileProvider(inputFile));
                                LOGGER.verbose("%1$s : verifier result : %2$s", new Object[]{inputFile.getName(), verificationResult});
                            } else {
                                verificationResult = InstantRunVerifierStatus.INSTANT_RUN_FAILURE;
                                LOGGER.verbose("Changed file %1$s not found in verifier backup", new Object[]{inputFile.getAbsolutePath()});
                            }
                        }
                        this.copyFile(inputFile, lastIterationFile);
                        continue block8;
                    }
                    case NOTCHANGED: {
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Unhandled DirectoryInput status " + changedFile.getValue());
            }
        }
        return verificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstantRunVerifierStatus processJarInputs(InstantRunVerifierStatus resultSoFar, TransformInput transformInput) throws IOException {
        block12: for (JarInput jarInput : transformInput.getJarInputs()) {
            File backupJar = new File(this.outputDir, jarInput.getName());
            switch (jarInput.getStatus()) {
                case REMOVED: {
                    if (!backupJar.exists() || backupJar.delete()) continue block12;
                    LOGGER.warning("Cannot delete %1$s file", new Object[]{backupJar});
                    continue block12;
                }
                case ADDED: {
                    this.copyFile(jarInput.getFile(), backupJar);
                    continue block12;
                }
                case CHANGED: {
                    if (resultSoFar != InstantRunVerifierStatus.COMPATIBLE) {
                        JarFile backupJarFile = new JarFile(backupJar);
                        try {
                            JarFile jarFile = new JarFile(jarInput.getFile());
                            try {
                                resultSoFar = this.processChangedJar(backupJarFile, jarFile);
                            }
                            finally {
                                jarFile.close();
                            }
                        }
                        finally {
                            backupJarFile.close();
                        }
                    }
                    this.copyFile(jarInput.getFile(), backupJar);
                    continue block12;
                }
                case NOTCHANGED: {
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unhandled JarInput status " + jarInput.getStatus());
        }
        return resultSoFar;
    }

    private InstantRunVerifierStatus processChangedJar(JarFile backupJar, JarFile newJar) throws IOException {
        HashMap<String, JarEntry> backupEntries = new HashMap<String, JarEntry>();
        Enumeration<JarEntry> backupJarEntries = backupJar.entries();
        while (backupJarEntries.hasMoreElements()) {
            JarEntry jarEntry = backupJarEntries.nextElement();
            backupEntries.put(jarEntry.getName(), jarEntry);
        }
        Enumeration<JarEntry> jarEntries = newJar.entries();
        while (jarEntries.hasMoreElements()) {
            InstantRunVerifierStatus verificationResult;
            JarEntry backupEntry;
            JarEntry jarEntry = jarEntries.nextElement();
            if (!jarEntry.getName().endsWith(".class") || (backupEntry = (JarEntry)backupEntries.get(jarEntry.getName())) == null || (verificationResult = this.runVerifier(newJar.getName() + ":" + jarEntry.getName(), new InstantRunVerifier.ClassBytesJarEntryProvider(backupJar, backupEntry), new InstantRunVerifier.ClassBytesJarEntryProvider(newJar, jarEntry))) == InstantRunVerifierStatus.COMPATIBLE) continue;
            return verificationResult;
        }
        return InstantRunVerifierStatus.COMPATIBLE;
    }

    protected InstantRunVerifierStatus runVerifier(String name, final InstantRunVerifier.ClassBytesProvider originalClass, final InstantRunVerifier.ClassBytesProvider updatedClass) throws IOException {
        if (!name.endsWith(".class")) {
            return InstantRunVerifierStatus.COMPATIBLE;
        }
        InstantRunVerifierStatus status = (InstantRunVerifierStatus)((Object)ThreadRecorder.get().record(ExecutionType.TASK_FILE_VERIFICATION, (Recorder.Block)new Recorder.Block<InstantRunVerifierStatus>(){

            public InstantRunVerifierStatus call() throws Exception {
                return InstantRunVerifier.run(originalClass, updatedClass);
            }
        }, new Recorder.Property[]{new Recorder.Property("target", name)}));
        if (status == null) {
            LOGGER.warning("No verifier result provided for %1$s", new Object[]{name});
            return InstantRunVerifierStatus.NOT_RUN;
        }
        return status;
    }

    protected void copyFile(File inputFile, File outputFile) {
        try {
            Files.createParentDirs((File)outputFile);
            Files.copy((File)inputFile, (File)outputFile);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, "Cannot copy $1$s to back up folder, build will continue but next time this file is modified will result in a cold swap.", new Object[]{inputFile.getAbsolutePath()});
        }
    }

    public String getName() {
        return "instantRunVerifier";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS});
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.outputDir);
    }

    public boolean isIncremental() {
        return true;
    }

    protected static File getOutputFile(File inputDir, File inputFile, File outputDir) {
        String relativePath = FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir);
        return new File(outputDir, relativePath);
    }

    public static class VerificationResult {
        private final InstantRunVerifierStatus changes;

        VerificationResult(InstantRunVerifierStatus changes) {
            this.changes = changes;
        }

        public boolean isCompatible() {
            return this.changes == null;
        }
    }
}

