/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.publishing;

import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.SplitFileSupplier;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;

public class FilterDataPersistence {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(List<? extends FileSupplier> fileSuppliers, Writer writer) throws IOException {
        Gson gson = new Gson();
        ImmutableList.Builder records = ImmutableList.builder();
        for (FileSupplier fileSupplier : fileSuppliers) {
            if (!(fileSupplier instanceof SplitFileSupplier)) continue;
            records.add((Object)new Record(((SplitFileSupplier)fileSupplier).getFilterData().getFilterType(), ((SplitFileSupplier)fileSupplier).getFilterData().getIdentifier(), ((File)fileSupplier.get()).getName()));
        }
        String recordsAsString = gson.toJson((Object)records.build());
        try {
            writer.append(recordsAsString);
        }
        finally {
            writer.close();
        }
    }

    public List<Record> load(Reader reader) throws IOException {
        Gson gson = new Gson();
        Type recordType = new TypeToken<List<Record>>(){}.getType();
        return (List)gson.fromJson(reader, recordType);
    }

    public static class Record {
        public final String filterType;
        public final String filterIdentifier;
        public final String splitFileName;

        private Record(String filterType, String filterIdentifier, String splitFileName) {
            this.filterType = filterType;
            this.filterIdentifier = filterIdentifier;
            this.splitFileName = splitFileName;
        }
    }
}

