/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.publishing;

import com.android.build.gradle.internal.tasks.FileSupplier;
import com.google.common.base.Supplier;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.tasks.TaskDependency;

public abstract class BasePublishArtifact
implements PublishArtifact {
    private final String name;
    private final String classifier;
    private final Supplier<File> outputFileSupplier;
    private final TaskDependency taskDependency;

    public BasePublishArtifact(String name, String classifier, FileSupplier outputFileSupplier) {
        this.name = name;
        this.classifier = classifier;
        this.outputFileSupplier = outputFileSupplier;
        this.taskDependency = new DefaultTaskDependency(outputFileSupplier.getTask());
    }

    public String getName() {
        return this.name;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public File getFile() {
        return (File)this.outputFileSupplier.get();
    }

    public Date getDate() {
        return null;
    }

    public TaskDependency getBuildDependencies() {
        return this.taskDependency;
    }

    private static final class DefaultTaskDependency
    implements TaskDependency {
        private final Set<Task> tasks;

        DefaultTaskDependency(Task task) {
            this.tasks = Collections.singleton(task);
        }

        public Set<? extends Task> getDependencies(Task task) {
            return this.tasks;
        }
    }
}

