/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.dependency.DependencyChecker;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;

public class VariantDependencies
implements DependencyContainer {
    private String name;
    private Configuration compileConfiguration;
    private Configuration packageConfiguration;
    private Configuration publishConfiguration;
    private Configuration mappingConfiguration;
    private Configuration classesConfiguration;
    private Configuration metadataConfiguration;
    private List<LibraryDependencyImpl> libraries = Lists.newArrayList();
    private List<JarDependency> jars = Lists.newArrayList();
    private List<JarDependency> localJars = Lists.newArrayList();
    private boolean annotationsPresent;
    private DependencyChecker checker;

    public static VariantDependencies compute(Project project, String name, boolean publishVariant, VariantType variantType, VariantDependencies parentVariant, ConfigurationProvider ... providers) {
        HashSet compileConfigs = Sets.newHashSetWithExpectedSize((int)(providers.length * 2));
        HashSet apkConfigs = Sets.newHashSetWithExpectedSize((int)providers.length);
        for (ConfigurationProvider provider : providers) {
            if (provider == null) continue;
            compileConfigs.add(provider.getCompileConfiguration());
            if (provider.getProvidedConfiguration() != null) {
                compileConfigs.add(provider.getProvidedConfiguration());
            }
            apkConfigs.add(provider.getCompileConfiguration());
            apkConfigs.add(provider.getPackageConfiguration());
        }
        if (parentVariant != null) {
            compileConfigs.add(parentVariant.getCompileConfiguration());
            apkConfigs.add(parentVariant.getPackageConfiguration());
        }
        Configuration compile = (Configuration)project.getConfigurations().maybeCreate("_" + name + "Compile");
        compile.setVisible(false);
        compile.setDescription("## Internal use, do not manually configure ##");
        compile.setExtendsFrom((Iterable)compileConfigs);
        Configuration apk = (Configuration)project.getConfigurations().maybeCreate(variantType == VariantType.LIBRARY ? "_" + name + "Publish" : "_" + name + "Apk");
        apk.setVisible(false);
        apk.setDescription("## Internal use, do not manually configure ##");
        apk.setExtendsFrom((Iterable)apkConfigs);
        Configuration publish = null;
        Configuration mapping = null;
        Configuration classes = null;
        Configuration metadata = null;
        if (publishVariant) {
            publish = (Configuration)project.getConfigurations().maybeCreate(name);
            publish.setDescription("Published Configuration for Variant " + name);
            if (variantType == VariantType.LIBRARY) {
                publish.setExtendsFrom((Iterable)apkConfigs);
            }
            metadata = (Configuration)project.getConfigurations().create(name + "-metadata");
            metadata.setDescription("Published APKs metadata for Variant " + name);
            mapping = (Configuration)project.getConfigurations().maybeCreate(name + "-mapping");
            mapping.setDescription("Published mapping configuration for Variant " + name);
            classes = (Configuration)project.getConfigurations().maybeCreate(name + "-classes");
            classes.setDescription("Published classes configuration for Variant " + name);
            classes.setExtendsFrom((Iterable)compileConfigs);
        }
        return new VariantDependencies(name, compile, apk, publish, mapping, classes, metadata, variantType != VariantType.UNIT_TEST);
    }

    private VariantDependencies(String name, Configuration compileConfiguration, Configuration packageConfiguration, Configuration publishConfiguration, Configuration mappingConfiguration, Configuration classesConfiguration, Configuration metadataConfiguration, boolean skipClassesInAndroid) {
        this.name = name;
        this.compileConfiguration = compileConfiguration;
        this.packageConfiguration = packageConfiguration;
        this.publishConfiguration = publishConfiguration;
        this.mappingConfiguration = mappingConfiguration;
        this.classesConfiguration = classesConfiguration;
        this.metadataConfiguration = metadataConfiguration;
        this.checker = new DependencyChecker(this, skipClassesInAndroid);
    }

    public String getName() {
        return this.name;
    }

    public Configuration getCompileConfiguration() {
        return this.compileConfiguration;
    }

    public Configuration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Configuration getPublishConfiguration() {
        return this.publishConfiguration;
    }

    public Configuration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    public Configuration getClassesConfiguration() {
        return this.classesConfiguration;
    }

    public Configuration getMetadataConfiguration() {
        return this.metadataConfiguration;
    }

    public void addLibraries(List<LibraryDependencyImpl> list) {
        this.libraries.addAll(list);
    }

    public void addJars(Collection<JarDependency> list) {
        this.jars.addAll(list);
    }

    public void addLocalJars(Collection<JarDependency> list) {
        this.localJars.addAll(list);
    }

    public List<LibraryDependencyImpl> getLibraries() {
        return this.libraries;
    }

    public List<? extends LibraryDependency> getAndroidDependencies() {
        return this.libraries;
    }

    public List<JarDependency> getJarDependencies() {
        return this.jars;
    }

    public List<JarDependency> getLocalDependencies() {
        return this.localJars;
    }

    public DependencyChecker getChecker() {
        return this.checker;
    }

    public void setAnnotationsPresent(boolean annotationsPresent) {
        this.annotationsPresent = annotationsPresent;
    }

    public boolean isAnnotationsPresent() {
        return this.annotationsPresent;
    }

    public boolean hasNonOptionalLibraries() {
        for (LibraryDependencyImpl libraryDependency : this.libraries) {
            if (libraryDependency.isOptional()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

