/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedArtifact;

public class JacocoPlugin
implements Plugin<Project> {
    public static final String ANT_CONFIGURATION_NAME = "androidJacocoAnt";
    public static final String AGENT_CONFIGURATION_NAME = "androidJacocoAgent";
    private Project project;

    public void apply(Project project) {
        this.project = project;
        String jacocoVersion = this.getJacocoVersion();
        this.addJacocoConfigurations();
        this.configureAgentDependencies(jacocoVersion);
        this.configureTaskClasspathDefaults(jacocoVersion);
    }

    private void addJacocoConfigurations() {
        this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME, (Action)new Action<Configuration>(){

            public void execute(Configuration files) {
                files.setVisible(false);
                files.setTransitive(true);
                files.setDescription("The Jacoco agent to use to get coverage data.");
            }
        });
        this.project.getConfigurations().create(ANT_CONFIGURATION_NAME, (Action)new Action<Configuration>(){

            public void execute(Configuration files) {
                files.setVisible(false);
                files.setTransitive(true);
                files.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks.");
            }
        });
    }

    private String getJacocoVersion() {
        boolean shouldFailWithException = false;
        for (Project candidateProject = this.project; candidateProject != null; candidateProject = candidateProject.getParent()) {
            Set resolvedArtifacts = candidateProject.getBuildscript().getConfigurations().getByName("classpath").getResolvedConfiguration().getResolvedArtifacts();
            for (ResolvedArtifact artifact : resolvedArtifacts) {
                ModuleVersionIdentifier moduleVersion = artifact.getModuleVersion().getId();
                if (!"org.jacoco.core".equals(moduleVersion.getName())) continue;
                return moduleVersion.getVersion();
            }
            if (resolvedArtifacts.isEmpty()) continue;
            shouldFailWithException = true;
        }
        if (shouldFailWithException) {
            throw new IllegalStateException("Could not find project build script dependency on org.jacoco.core");
        }
        this.project.getLogger().error("No resolved dependencies found when searching for the jacoco version.");
        return null;
    }

    private void configureAgentDependencies(final String jacocoVersion) {
        final Configuration config = this.project.getConfigurations().getByName(AGENT_CONFIGURATION_NAME);
        config.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                if (config.getDependencies().isEmpty()) {
                    config.getDependencies().add((Object)JacocoPlugin.this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.agent:" + jacocoVersion)));
                }
            }
        });
    }

    private void configureTaskClasspathDefaults(final String jacocoVersion) {
        final Configuration config = this.project.getConfigurations().getByName(ANT_CONFIGURATION_NAME);
        config.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                if (config.getDependencies().isEmpty()) {
                    config.getDependencies().add((Object)JacocoPlugin.this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.ant:" + jacocoVersion)));
                }
            }
        });
    }
}

