/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.VariantDimensionData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.utils.StringHelper;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class ProductFlavorData<T extends CoreProductFlavor>
extends VariantDimensionData {
    private final T productFlavor;
    private final Task assembleTask;

    ProductFlavorData(T productFlavor, DefaultAndroidSourceSet sourceSet, DefaultAndroidSourceSet androidTestSourceSet, DefaultAndroidSourceSet unitTestSourceSet, Project project) {
        super(sourceSet, androidTestSourceSet, unitTestSourceSet, project);
        this.productFlavor = productFlavor;
        if (!"main".equals(sourceSet.getName())) {
            String sourceSetName = StringHelper.capitalize((String)sourceSet.getName());
            this.assembleTask = project.getTasks().create("assemble" + sourceSetName);
            this.assembleTask.setDescription("Assembles all " + sourceSetName + " builds.");
            this.assembleTask.setGroup("build");
        } else {
            this.assembleTask = null;
        }
    }

    public T getProductFlavor() {
        return this.productFlavor;
    }

    public Task getAssembleTask() {
        return this.assembleTask;
    }
}

