/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.analytics;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class StudioCrashDetection {
    private static final String RECORD_FILE_KEY = "studio.record.file";
    private static final String PLATFORM_PREFIX = "AndroidStudio";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private StudioCrashDetection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        block8: {
            if (System.getProperty(RECORD_FILE_KEY) != null) {
                throw new AssertionError((Object)"StudioCrashDetection.start called more than once");
            }
            try {
                File f = new File(PathManager.getTempPath(), String.format("%s.%s", PLATFORM_PREFIX, UUID.randomUUID().toString()));
                if (!f.createNewFile()) break block8;
                System.setProperty(RECORD_FILE_KEY, f.getAbsolutePath());
                FileWriter fw = new FileWriter(f);
                try {
                    List lines;
                    File buildInfo = new File(PathManager.getHomePath(), "build.txt");
                    if (!buildInfo.exists() && SystemInfo.isMac) {
                        buildInfo = new File(PathManager.getHomePath(), "Resources/build.txt");
                    }
                    String buildVersion = "<unknown>";
                    if (buildInfo.exists() && (lines = FileUtil.loadLines((File)buildInfo)).size() > 0) {
                        buildVersion = (String)lines.get(0);
                    }
                    fw.write(buildVersion);
                    fw.write(LINE_SEPARATOR);
                    fw.write(System.getProperty("java.runtime.version"));
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRecordedVersionNumber(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/internal/statistic/analytics/StudioCrashDetection", "updateRecordedVersionNumber"));
        }
        String recordFileName = System.getProperty(RECORD_FILE_KEY);
        if (recordFileName != null) {
            File recordFile = new File(recordFileName);
            try {
                List lines = FileUtil.loadLines((File)recordFile);
                lines.set(0, version);
                FileWriter fw = new FileWriter(recordFile);
                try {
                    for (String line : lines) {
                        fw.write(line);
                        fw.write(LINE_SEPARATOR);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void stop() {
        String recordFileName = System.getProperty(RECORD_FILE_KEY);
        if (recordFileName != null) {
            FileUtil.delete((File)new File(recordFileName));
            System.clearProperty(RECORD_FILE_KEY);
        }
    }

    public static List<String> reapCrashDescriptions() {
        File[] previousRecords = new File(PathManager.getTempPath()).listFiles(new FileFilter(){
            final String recordFile = System.getProperty("studio.record.file");

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(StudioCrashDetection.PLATFORM_PREFIX) && !pathname.getAbsolutePath().equals(this.recordFile);
            }
        });
        ArrayList<String> descriptions = new ArrayList<String>();
        if (previousRecords != null) {
            for (File record : previousRecords) {
                try {
                    descriptions.add(FileUtil.loadFile((File)record));
                }
                catch (IOException ex) {
                    descriptions.add("<unknown>");
                }
                FileUtil.delete((File)record);
            }
        }
        return descriptions;
    }
}

