/*
 * Decompiled with CFR 0.152.
 */
package com.google.repacked.antlr.v4.codegen;

import com.google.repacked.antlr.v4.codegen.CodeGenerator;
import com.google.repacked.antlr.v4.codegen.Target;
import com.google.repacked.antlr.v4.runtime.misc.IntervalSet;
import com.google.repacked.antlr.v4.tool.ErrorType;
import com.google.repacked.antlr.v4.tool.Grammar;
import com.google.repacked.antlr.v4.tool.ast.GrammarAST;
import java.util.List;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.gui.STViz;

public class CodeGenPipeline {
    Grammar g;

    public CodeGenPipeline(Grammar g) {
        this.g = g;
    }

    public void process() {
        CodeGenerator gen = new CodeGenerator(this.g);
        Target target = gen.getTarget();
        if (target == null) {
            return;
        }
        IntervalSet idTypes = new IntervalSet(new int[0]);
        idTypes.add(28);
        idTypes.add(57);
        idTypes.add(66);
        List<GrammarAST> idNodes = this.g.ast.getNodesWithType(idTypes);
        for (GrammarAST idNode : idNodes) {
            if (!target.grammarSymbolCausesIssueInGeneratedCode(idNode)) continue;
            this.g.tool.errMgr.grammarError(ErrorType.USE_OF_BAD_WORD, this.g.fileName, idNode.getToken(), idNode.getText());
        }
        int errorCount = this.g.tool.errMgr.getNumErrors();
        if (this.g.isLexer()) {
            ST lexer = gen.generateLexer();
            if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                this.writeRecognizer(lexer, gen);
            }
        } else {
            ST parser = gen.generateParser();
            if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                this.writeRecognizer(parser, gen);
            }
            if (this.g.tool.gen_listener) {
                ST listener = gen.generateListener();
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    gen.writeListener(listener);
                }
                if (target.wantsBaseListener()) {
                    ST baseListener = gen.generateBaseListener();
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeBaseListener(baseListener);
                    }
                }
            }
            if (this.g.tool.gen_visitor) {
                ST visitor = gen.generateVisitor();
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    gen.writeVisitor(visitor);
                }
                if (target.wantsBaseVisitor()) {
                    ST baseVisitor = gen.generateBaseVisitor();
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeBaseVisitor(baseVisitor);
                    }
                }
            }
            gen.writeHeaderFile();
        }
        gen.writeVocabFile();
    }

    protected void writeRecognizer(ST template, CodeGenerator gen) {
        if (this.g.tool.launch_ST_inspector) {
            STViz viz = template.inspect();
            if (this.g.tool.ST_inspector_wait_for_close) {
                try {
                    viz.waitForClose();
                }
                catch (InterruptedException ex) {
                    this.g.tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, ex, new Object[0]);
                }
            }
        }
        gen.writeRecognizer(template);
    }
}

