/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationMethod;
import java.util.List;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;

public class AnnotationTypeUtil
extends TypeUtil {
    Types mTypes;

    public AnnotationTypeUtil(AnnotationAnalyzer annotationAnalyzer) {
        this.mTypes = annotationAnalyzer.getTypeUtils();
    }

    @Override
    public String getDescription(ModelClass modelClass) {
        return modelClass.getCanonicalName().replace('.', '/');
    }

    @Override
    public String getDescription(ModelMethod modelMethod) {
        return modelMethod.getName() + this.getDescription(((AnnotationMethod)modelMethod).mExecutableElement.asType());
    }

    private String getDescription(TypeMirror typeMirror) {
        if (typeMirror == null) {
            throw new UnsupportedOperationException();
        }
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return "Z";
            }
            case BYTE: {
                return "B";
            }
            case SHORT: {
                return "S";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case CHAR: {
                return "C";
            }
            case FLOAT: {
                return "F";
            }
            case DOUBLE: {
                return "D";
            }
            case DECLARED: {
                return "L" + ((Object)this.mTypes.erasure(typeMirror)).toString().replace('.', '/') + ";";
            }
            case VOID: {
                return "V";
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                String componentType = this.getDescription(arrayType.getComponentType());
                return "[" + componentType;
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                String name = typeVariable.toString();
                return "L" + name.replace('.', '/') + ";";
            }
            case EXECUTABLE: {
                ExecutableType executableType = (ExecutableType)typeMirror;
                int argStart = ((Object)this.mTypes.erasure(executableType)).toString().indexOf(40);
                String methodName = executableType.toString().substring(0, argStart);
                String args = this.joinArgs(executableType.getParameterTypes());
                return methodName + "(" + args + ")" + this.getDescription(executableType.getReturnType());
            }
        }
        throw new UnsupportedOperationException("cannot understand type " + ((Object)typeMirror).toString() + ", kind:" + typeMirror.getKind().name());
    }

    private String joinArgs(List<? extends TypeMirror> mirrorList) {
        StringBuilder result = new StringBuilder();
        for (TypeMirror typeMirror : mirrorList) {
            result.append(this.getDescription(typeMirror));
        }
        return result.toString();
    }
}

