/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repositoryv2;

import com.android.prefs.AndroidLocation;
import com.android.repository.Revision;
import com.android.repository.api.ConstantSourceProvider;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemoteListSourceProvider;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.impl.installer.BasicInstaller;
import com.android.repository.impl.installer.PackageInstaller;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.sources.LocalSourceProvider;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repositoryv2.LegacyLocalRepoLoader;
import com.android.sdklib.repositoryv2.MavenInstaller;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.sdklib.repositoryv2.meta.SysImgFactory;
import com.android.sdklib.repositoryv2.sources.RemoteSiteType;
import com.android.sdklib.repositoryv2.targets.AndroidTargetManager;
import com.android.sdklib.repositoryv2.targets.SystemImageManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;

public final class AndroidSdkHandler {
    private static final SchemaModule ADDON_MODULE = new SchemaModule("com.android.sdklib.repositoryv2.generated.addon.v%d.ObjectFactory", "sdk-addon-%02d.xsd", AndroidSdkHandler.class);
    private static final SchemaModule REPOSITORY_MODULE = new SchemaModule("com.android.sdklib.repositoryv2.generated.repository.v%d.ObjectFactory", "sdk-repository-%02d.xsd", AndroidSdkHandler.class);
    private static final SchemaModule SYS_IMG_MODULE = new SchemaModule("com.android.sdklib.repositoryv2.generated.sysimg.v%d.ObjectFactory", "sdk-sys-img-%02d.xsd", AndroidSdkHandler.class);
    private static final SchemaModule COMMON_MODULE = new SchemaModule("com.android.sdklib.repositoryv2.generated.common.v%d.ObjectFactory", "sdk-common-%02d.xsd", AndroidSdkHandler.class);
    public static final String URL_GOOGLE_SDK_SITE = "https://dl.google.com/android/repository/";
    public static final String SDK_TEST_BASE_URL_ENV_VAR = "SDK_TEST_BASE_URL";
    public static final int LATEST_LEGACY_VERSION = 12;
    @VisibleForTesting
    static final String LOCAL_ADDONS_FILENAME = "repositories.cfg";
    private static final String DEFAULT_SITE_LIST_FILENAME_PATTERN = "addons_list-%d.xml";
    private static final Object MANAGER_LOCK = new Object();
    private static final String LEGACY_REPO_URL_PATTERN = "%srepository-%d.xml";
    private static final String REPO_URL_PATTERN = "%srepository2-%d.xml";
    private RepoManager mRepoManager;
    private SystemImageManager mSystemImageManager;
    private AndroidTargetManager mAndroidTargetManager;
    private BuildToolInfo mLatestBuildTool = null;
    private final FileOp mFop;
    private static Map<File, AndroidSdkHandler> sInstances = Maps.newConcurrentMap();
    private final File mLocation;
    private LocalSourceProvider mUserSourceProvider;
    private static FallbackRemoteRepoLoader sRemoteFallback;
    private static RepoConfig sRepoConfig;

    public static AndroidSdkHandler getInstance(File localPath) {
        File key = localPath == null ? new File("") : localPath;
        AndroidSdkHandler instance = sInstances.get(key);
        if (instance == null) {
            instance = new AndroidSdkHandler(localPath, FileOpUtils.create());
            sInstances.put(key, instance);
        }
        return instance;
    }

    @VisibleForTesting
    public AndroidSdkHandler(File localPath, FileOp fop) {
        this.mFop = fop;
        this.mLocation = localPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepoManager getSdkManager(ProgressIndicator progress) {
        RepoManager result = this.mRepoManager;
        Object object = MANAGER_LOCK;
        synchronized (object) {
            if (result == null) {
                this.mSystemImageManager = null;
                this.mAndroidTargetManager = null;
                this.mLatestBuildTool = null;
                result = this.getRepoConfig(progress).createRepoManager(progress, this.mLocation, sRemoteFallback, this.getUserSourceProvider(progress), this.mFop);
                result.registerLocalChangeListener(new RepoManager.RepoLoadedCallback(){

                    public void doRun(RepositoryPackages packages) {
                        AndroidSdkHandler.this.mSystemImageManager = null;
                        AndroidSdkHandler.this.mAndroidTargetManager = null;
                        AndroidSdkHandler.this.mLatestBuildTool = null;
                    }
                });
                this.mRepoManager = result;
            }
        }
        return this.mRepoManager;
    }

    public SystemImageManager getSystemImageManager(ProgressIndicator progress) {
        if (this.mSystemImageManager == null) {
            this.getSdkManager(progress);
            this.mSystemImageManager = new SystemImageManager(this.mRepoManager, (SysImgFactory)AndroidSdkHandler.getSysImgModule().createLatestFactory(), this.mFop);
        }
        return this.mSystemImageManager;
    }

    public AndroidTargetManager getAndroidTargetManager(ProgressIndicator progress) {
        if (this.mAndroidTargetManager == null) {
            this.getSdkManager(progress);
            this.mAndroidTargetManager = new AndroidTargetManager(this, this.mFop);
        }
        return this.mAndroidTargetManager;
    }

    public File getLocation() {
        return this.mLocation;
    }

    public LocalPackage getLocalPackage(String path, ProgressIndicator progress) {
        return (LocalPackage)this.getSdkManager(progress).getPackages().getLocalPackages().get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRemoteFallback(FallbackRemoteRepoLoader fallbackSdk) {
        Object object = MANAGER_LOCK;
        synchronized (object) {
            sRemoteFallback = fallbackSdk;
            AndroidSdkHandler.invalidateAll();
        }
    }

    private static void invalidateAll() {
        for (AndroidSdkHandler handler : sInstances.values()) {
            handler.mRepoManager = null;
        }
    }

    public static SchemaModule getCommonModule() {
        return COMMON_MODULE;
    }

    public static SchemaModule getAddonModule() {
        return ADDON_MODULE;
    }

    public static SchemaModule getRepositoryModule() {
        return REPOSITORY_MODULE;
    }

    public static SchemaModule getSysImgModule() {
        return SYS_IMG_MODULE;
    }

    @VisibleForTesting
    RemoteListSourceProvider getRemoteListSourceProvider(ProgressIndicator progress) {
        return this.getRepoConfig(progress).getRemoteListSourceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalSourceProvider getUserSourceProvider(ProgressIndicator progress) {
        if (this.mUserSourceProvider == null) {
            this.mUserSourceProvider = RepoConfig.createUserSourceProvider(progress, this.mFop);
            Object object = MANAGER_LOCK;
            synchronized (object) {
                if (this.mRepoManager != null) {
                    this.mRepoManager = null;
                    this.getSdkManager(progress);
                }
            }
        }
        return this.mUserSourceProvider;
    }

    private RepoConfig getRepoConfig(ProgressIndicator progress) {
        if (sRepoConfig == null) {
            sRepoConfig = new RepoConfig(progress);
        }
        return sRepoConfig;
    }

    public static PackageInstaller findBestInstaller(RepoPackage p) {
        if (p.getTypeDetails() instanceof DetailsTypes.MavenType) {
            return new MavenInstaller();
        }
        return new BasicInstaller();
    }

    public BuildToolInfo getLatestBuildTool(ProgressIndicator progress, boolean allowPreview) {
        if (allowPreview) {
            return this.findBuildTool(progress, true);
        }
        if (this.mLatestBuildTool == null) {
            this.mLatestBuildTool = this.findBuildTool(progress, false);
        }
        return this.mLatestBuildTool;
    }

    private BuildToolInfo findBuildTool(ProgressIndicator progress, boolean allowPreview) {
        RepoManager manager = this.getSdkManager(progress);
        BuildToolInfo info = null;
        for (LocalPackage p : manager.getPackages().getLocalPackagesForPrefix("build-tools")) {
            if (!allowPreview && p.getVersion().isPreview() || info != null && info.getRevision().compareTo(p.getVersion()) >= 0) continue;
            info = new BuildToolInfo(p.getVersion(), p.getLocation());
        }
        return info;
    }

    public BuildToolInfo getBuildToolInfo(Revision revision, ProgressIndicator progress) {
        RepositoryPackages packages = this.getSdkManager(progress).getPackages();
        LocalPackage p = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath(revision));
        if (p == null) {
            return null;
        }
        return new BuildToolInfo(p.getVersion(), p.getLocation());
    }

    public FileOp getFileOp() {
        return this.mFop;
    }

    private static class RepoConfig {
        private RemoteListSourceProvider mAddonsListSourceProvider;
        private ConstantSourceProvider mRepositorySourceProvider;
        private ConstantSourceProvider mLegacyRepositorySourceProvider;

        public RepoConfig(ProgressIndicator progress) {
            SchemaModule addonListModule = new SchemaModule("com.android.sdklib.repositoryv2.sources.generated.v%d.ObjectFactory", "sdk-sites-list-%d.xsd", RemoteSiteType.class);
            try {
                ImmutableMap siteTypes = ImmutableMap.builder().put(RemoteSiteType.AddonSiteType.class, (Object)ImmutableSet.of((Object)ADDON_MODULE)).put(RemoteSiteType.SysImgSiteType.class, (Object)ImmutableSet.of((Object)SYS_IMG_MODULE)).build();
                this.mAddonsListSourceProvider = RemoteListSourceProvider.create((String)RepoConfig.getAddonListUrl(progress), (SchemaModule)addonListModule, (Map)siteTypes);
            }
            catch (URISyntaxException e) {
                progress.logError("Failed to set up addons source provider", (Throwable)e);
            }
            String url = String.format(AndroidSdkHandler.REPO_URL_PATTERN, RepoConfig.getBaseUrl(progress), REPOSITORY_MODULE.getNamespaceVersionMap().size());
            this.mRepositorySourceProvider = new ConstantSourceProvider(url, "Android Repository", (Collection)ImmutableSet.of((Object)REPOSITORY_MODULE, (Object)RepoManager.getGenericModule()));
            url = String.format(AndroidSdkHandler.LEGACY_REPO_URL_PATTERN, RepoConfig.getBaseUrl(progress), 12);
            this.mLegacyRepositorySourceProvider = new ConstantSourceProvider(url, "Legacy Android Repository", (Collection)ImmutableSet.of((Object)REPOSITORY_MODULE, (Object)RepoManager.getGenericModule()));
        }

        public static LocalSourceProvider createUserSourceProvider(ProgressIndicator progress, FileOp fileOp) {
            try {
                return new LocalSourceProvider(new File(AndroidLocation.getFolder(), AndroidSdkHandler.LOCAL_ADDONS_FILENAME), (Collection)ImmutableList.of((Object)SYS_IMG_MODULE, (Object)ADDON_MODULE), fileOp);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                progress.logWarning("Couldn't find android folder", (Throwable)e);
                return null;
            }
        }

        private static String getAddonListUrl(ProgressIndicator progress) {
            return RepoConfig.getBaseUrl(progress) + AndroidSdkHandler.DEFAULT_SITE_LIST_FILENAME_PATTERN;
        }

        private static String getBaseUrl(ProgressIndicator progress) {
            String baseUrl = System.getenv(AndroidSdkHandler.SDK_TEST_BASE_URL_ENV_VAR);
            if (baseUrl != null) {
                if (!baseUrl.isEmpty() && baseUrl.endsWith("/")) {
                    return baseUrl;
                }
                progress.logWarning("Ignoring invalid SDK_TEST_BASE_URL: " + baseUrl);
            }
            return AndroidSdkHandler.URL_GOOGLE_SDK_SITE;
        }

        public RemoteListSourceProvider getRemoteListSourceProvider() {
            return this.mAddonsListSourceProvider;
        }

        public RepoManager createRepoManager(ProgressIndicator progress, File localLocation, FallbackRemoteRepoLoader remoteFallbackLoader, LocalSourceProvider userProvider, FileOp fop) {
            RepoManager result = RepoManager.create((FileOp)fop);
            result.registerSchemaModule(ADDON_MODULE);
            result.registerSchemaModule(REPOSITORY_MODULE);
            result.registerSchemaModule(SYS_IMG_MODULE);
            result.registerSchemaModule(COMMON_MODULE);
            result.registerSourceProvider((RepositorySourceProvider)this.mRepositorySourceProvider);
            result.registerSourceProvider((RepositorySourceProvider)this.mLegacyRepositorySourceProvider);
            result.registerSourceProvider((RepositorySourceProvider)this.mAddonsListSourceProvider);
            if (userProvider != null) {
                result.registerSourceProvider((RepositorySourceProvider)userProvider);
                userProvider.setRepoManager(result);
            }
            result.setLocalPath(localLocation);
            if (localLocation != null) {
                result.setFallbackLocalRepoLoader((FallbackLocalRepoLoader)new LegacyLocalRepoLoader(localLocation, fop, result));
                result.loadSynchronously(0L, progress, null, null);
            }
            result.setFallbackRemoteRepoLoader(remoteFallbackLoader);
            return result;
        }
    }
}

