/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionHelper;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalAddonPkgInfo;
import com.android.sdklib.repository.local.LocalAddonSysImgPkgInfo;
import com.android.sdklib.repository.local.LocalBuildToolPkgInfo;
import com.android.sdklib.repository.local.LocalDirInfo;
import com.android.sdklib.repository.local.LocalDocPkgInfo;
import com.android.sdklib.repository.local.LocalExtraPkgInfo;
import com.android.sdklib.repository.local.LocalLLDBPkgInfo;
import com.android.sdklib.repository.local.LocalNdkPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformToolPkgInfo;
import com.android.sdklib.repository.local.LocalSamplePkgInfo;
import com.android.sdklib.repository.local.LocalSourcePkgInfo;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import com.android.sdklib.repository.local.LocalToolPkgInfo;
import com.android.sdklib.repository.local.PackageParserUtils;
import com.android.sdklib.repositoryv2.IdDisplay;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;

@Deprecated
public class LocalSdk {
    private File mSdkRoot;
    private final FileOp mFileOp;
    private final Multimap<PkgType, LocalPkgInfo> mLocalPackages = TreeMultimap.create();
    private final Multimap<PkgType, LocalDirInfo> mVisitedDirs = HashMultimap.create();
    private BuildToolInfo mLegacyBuildTools;

    public LocalSdk() {
        this.mFileOp = FileOpUtils.create();
    }

    public LocalSdk(File sdkRoot) {
        this();
        this.setLocation(sdkRoot);
    }

    public LocalSdk(FileOp fileOp) {
        this.mFileOp = fileOp;
    }

    public FileOp getFileOp() {
        return this.mFileOp;
    }

    public void setLocation(File sdkRoot) {
        assert (sdkRoot != null);
        this.mSdkRoot = sdkRoot;
        this.clearLocalPkg(PkgType.PKG_ALL);
    }

    public File getLocation() {
        return this.mSdkRoot;
    }

    @Deprecated
    public String getPath() {
        return this.mSdkRoot != null ? this.mSdkRoot.getPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLocalPkg(EnumSet<PkgType> filters) {
        this.mLegacyBuildTools = null;
        Multimap<PkgType, LocalPkgInfo> multimap = this.mLocalPackages;
        synchronized (multimap) {
            for (PkgType filter : filters) {
                this.mVisitedDirs.removeAll((Object)filter);
                this.mLocalPackages.removeAll((Object)filter);
            }
        }
    }

    public LocalPkgInfo getPkgInfo(IPkgDesc descriptor) {
        for (LocalPkgInfo pkg : this.getPkgsInfos(EnumSet.of(descriptor.getType()))) {
            IPkgDesc d = pkg.getDesc();
            if (!d.equals(descriptor)) continue;
            return pkg;
        }
        return null;
    }

    public LocalPkgInfo getPkgInfo(PkgType filter, AndroidVersion version) {
        assert (filter == PkgType.PKG_PLATFORM || filter == PkgType.PKG_SAMPLE || filter == PkgType.PKG_SOURCE);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasAndroidVersion() || !d.getAndroidVersion().equals((Object)version)) continue;
            return pkg;
        }
        return null;
    }

    public LocalPkgInfo getPkgInfo(PkgType filter, Revision revision) {
        assert (filter == PkgType.PKG_BUILD_TOOLS);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.getRevision().equals((Object)revision)) continue;
            return pkg;
        }
        return null;
    }

    public LocalPkgInfo getPkgInfo(PkgType filter, String path) {
        assert (filter == PkgType.PKG_ADDON || filter == PkgType.PKG_PLATFORM);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasPath() || !path.equals(d.getPath())) continue;
            return pkg;
        }
        return null;
    }

    public LocalPkgInfo getPkgInfo(PkgType filter, String vendor, String path) {
        assert (filter == PkgType.PKG_EXTRA || filter == PkgType.PKG_ADDON);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            IPkgDesc d = pkg.getDesc();
            if (!d.hasVendor() || !vendor.equals(d.getVendor().getId()) || !d.hasPath() || !path.equals(d.getPath())) continue;
            return pkg;
        }
        return null;
    }

    public LocalExtraPkgInfo getExtra(String vendor, String path) {
        return (LocalExtraPkgInfo)this.getPkgInfo(PkgType.PKG_EXTRA, vendor, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalPkgInfo getPkgInfo(PkgType filter) {
        if (filter != PkgType.PKG_TOOLS && filter != PkgType.PKG_PLATFORM_TOOLS && filter != PkgType.PKG_DOC && filter != PkgType.PKG_NDK && filter != PkgType.PKG_LLDB) {
            assert (false);
            return null;
        }
        LocalPkgInfo info = null;
        Multimap<PkgType, LocalPkgInfo> multimap = this.mLocalPackages;
        synchronized (multimap) {
            Collection existing = this.mLocalPackages.get((Object)filter);
            assert (existing.size() <= 1);
            if (!existing.isEmpty()) {
                return (LocalPkgInfo)existing.iterator().next();
            }
            File uniqueDir = new File(this.mSdkRoot, filter.getFolderName());
            if (!this.mVisitedDirs.containsEntry((Object)filter, (Object)new LocalDirInfo.MapComparator(uniqueDir))) {
                switch (filter) {
                    case PKG_TOOLS: {
                        info = this.scanTools(uniqueDir);
                        break;
                    }
                    case PKG_PLATFORM_TOOLS: {
                        info = this.scanPlatformTools(uniqueDir);
                        break;
                    }
                    case PKG_DOC: {
                        info = this.scanDoc(uniqueDir);
                        break;
                    }
                    case PKG_NDK: {
                        info = this.scanNdk(uniqueDir);
                        break;
                    }
                    case PKG_LLDB: {
                        info = this.scanLLDB(uniqueDir);
                        break;
                    }
                }
            }
            this.mVisitedDirs.put((Object)filter, (Object)new LocalDirInfo(this.mFileOp, uniqueDir));
            if (info != null) {
                this.mLocalPackages.put((Object)filter, (Object)info);
            }
        }
        return info;
    }

    public LocalPkgInfo[] getPkgsInfos(PkgType filter) {
        return this.getPkgsInfos(EnumSet.of(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalPkgInfo[] getPkgsInfos(EnumSet<PkgType> filters) {
        ArrayList list = Lists.newArrayList();
        for (PkgType filter : filters) {
            if (filter == PkgType.PKG_TOOLS || filter == PkgType.PKG_PLATFORM_TOOLS || filter == PkgType.PKG_DOC || filter == PkgType.PKG_NDK || filter == PkgType.PKG_LLDB) {
                LocalPkgInfo info = this.getPkgInfo(filter);
                if (info == null) continue;
                list.add(info);
                continue;
            }
            Multimap<PkgType, LocalPkgInfo> multimap = this.mLocalPackages;
            synchronized (multimap) {
                Collection existing = this.mLocalPackages.get((Object)filter);
                assert (existing != null);
                if (!existing.isEmpty()) {
                    list.addAll(existing);
                    continue;
                }
                File subDir = new File(this.mSdkRoot, filter.getFolderName());
                if (!this.mVisitedDirs.containsEntry((Object)filter, (Object)new LocalDirInfo.MapComparator(subDir))) {
                    switch (filter) {
                        case PKG_BUILD_TOOLS: {
                            this.scanBuildTools(subDir, existing);
                            break;
                        }
                        case PKG_PLATFORM: {
                            this.scanPlatforms(subDir, existing);
                            break;
                        }
                        case PKG_SYS_IMAGE: {
                            this.scanSysImages(subDir, existing, false);
                            break;
                        }
                        case PKG_ADDON_SYS_IMAGE: {
                            this.scanSysImages(subDir, existing, true);
                            break;
                        }
                        case PKG_ADDON: {
                            this.scanAddons(subDir, existing);
                            break;
                        }
                        case PKG_SAMPLE: {
                            this.scanSamples(subDir, existing);
                            break;
                        }
                        case PKG_SOURCE: {
                            this.scanSources(subDir, existing);
                            break;
                        }
                        case PKG_EXTRA: {
                            this.scanExtras(subDir, existing);
                            break;
                        }
                        case PKG_TOOLS: 
                        case PKG_PLATFORM_TOOLS: 
                        case PKG_DOC: 
                        case PKG_NDK: 
                        case PKG_LLDB: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported pkg type " + filter.toString());
                        }
                    }
                    this.mVisitedDirs.put((Object)filter, (Object)new LocalDirInfo(this.mFileOp, subDir));
                    list.addAll(existing);
                }
            }
        }
        Collections.sort(list);
        return list.toArray(new LocalPkgInfo[list.size()]);
    }

    public BuildToolInfo getBuildTool(Revision revision) {
        LocalPkgInfo pkg = this.getPkgInfo(PkgType.PKG_BUILD_TOOLS, revision);
        if (pkg instanceof LocalBuildToolPkgInfo) {
            return ((LocalBuildToolPkgInfo)pkg).getBuildToolInfo();
        }
        return null;
    }

    public BuildToolInfo getLatestBuildTool() {
        if (this.mLegacyBuildTools != null) {
            return this.mLegacyBuildTools;
        }
        Object[] pkgs = this.getPkgsInfos(PkgType.PKG_BUILD_TOOLS);
        if (pkgs.length == 0) {
            LocalPkgInfo ptPkg = this.getPkgInfo(PkgType.PKG_PLATFORM_TOOLS);
            if (ptPkg instanceof LocalPlatformToolPkgInfo && ptPkg.getDesc().getRevision().compareTo(new Revision(17)) < 0) {
                this.mLegacyBuildTools = this.createLegacyBuildTools((LocalPlatformToolPkgInfo)ptPkg);
                return this.mLegacyBuildTools;
            }
            return null;
        }
        assert (pkgs.length > 0);
        Arrays.sort(pkgs);
        LocalBuildToolPkgInfo preview = null;
        for (int i = pkgs.length - 1; i >= 0; --i) {
            Object pkg = pkgs[i];
            if (!(pkg instanceof LocalBuildToolPkgInfo)) continue;
            if (!((LocalPkgInfo)pkg).getDesc().isPreview()) {
                return ((LocalBuildToolPkgInfo)pkg).getBuildToolInfo();
            }
            if (preview != null) continue;
            preview = (LocalBuildToolPkgInfo)pkg;
        }
        return preview != null ? preview.getBuildToolInfo() : null;
    }

    private BuildToolInfo createLegacyBuildTools(LocalPlatformToolPkgInfo ptInfo) {
        File platformTools = new File(this.getLocation(), "platform-tools");
        File platformToolsLib = ptInfo.getLocalDir();
        File platformToolsRs = new File(platformTools, "renderscript");
        return new BuildToolInfo(ptInfo.getDesc().getRevision(), platformTools, new File(platformTools, SdkConstants.FN_AAPT), new File(platformTools, SdkConstants.FN_AIDL), new File(platformTools, SdkConstants.FN_DX), new File(platformToolsLib, "dx.jar"), new File(platformTools, SdkConstants.FN_RENDERSCRIPT), new File(platformToolsRs, "include"), new File(platformToolsRs, "clang-include"), null, null, null, null, null, new File(platformTools, SdkConstants.FN_ZIPALIGN));
    }

    private LocalToolPkgInfo scanTools(File toolFolder) {
        File[] files;
        Properties props = this.parseProperties(new File(toolFolder, "source.properties"));
        Revision rev = PackageParserUtils.getRevisionProperty(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        rev = LocalSdk.fullySpecifyRevision(rev);
        Revision minPlatToolsRev = PackageParserUtils.getRevisionProperty(props, "Platform.MinPlatformToolsRev");
        if (minPlatToolsRev == null) {
            minPlatToolsRev = Revision.NOT_SPECIFIED;
        }
        LocalToolPkgInfo info = new LocalToolPkgInfo(this, toolFolder, props, rev, minPlatToolsRev);
        boolean hasEmulator = false;
        boolean hasAndroid = false;
        String android1 = SdkConstants.androidCmdName().replace(".bat", ".exe");
        String android2 = android1.indexOf(46) == -1 ? null : android1.replace(".exe", ".bat");
        for (File file : files = this.mFileOp.listFiles(toolFolder)) {
            String name = file.getName();
            if (SdkConstants.FN_EMULATOR.equals(name)) {
                hasEmulator = true;
            }
            if (!android1.equals(name) && (android2 == null || !android2.equals(name))) continue;
            hasAndroid = true;
        }
        if (!hasAndroid) {
            info.appendLoadError("Missing %1$s", SdkConstants.androidCmdName());
        }
        if (!hasEmulator) {
            info.appendLoadError("Missing %1$s", SdkConstants.FN_EMULATOR);
        }
        return info;
    }

    private static Revision fullySpecifyRevision(Revision rev) {
        if (!rev.isPreview()) {
            rev = new Revision(rev.getMajor(), rev.getMinor(), rev.getMicro());
        }
        return rev;
    }

    private LocalPlatformToolPkgInfo scanPlatformTools(File ptFolder) {
        Properties props = this.parseProperties(new File(ptFolder, "source.properties"));
        Revision rev = PackageParserUtils.getRevisionProperty(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        rev = LocalSdk.fullySpecifyRevision(rev);
        LocalPlatformToolPkgInfo info = new LocalPlatformToolPkgInfo(this, ptFolder, props, rev);
        return info;
    }

    private LocalDocPkgInfo scanDoc(File docFolder) {
        Properties props = this.parseProperties(new File(docFolder, "source.properties"));
        Revision rev = PackageParserUtils.getRevisionProperty(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        try {
            AndroidVersion vers = AndroidVersionHelper.create(props);
            LocalDocPkgInfo info = new LocalDocPkgInfo(this, docFolder, props, vers, rev);
            if (!this.mFileOp.isFile(new File(docFolder, "index.html"))) {
                info.appendLoadError("Missing index.html", new Object[0]);
            }
            return info;
        }
        catch (AndroidVersion.AndroidVersionException e) {
            return null;
        }
    }

    private LocalNdkPkgInfo scanNdk(File ndkFolder) {
        Properties props = this.parseProperties(new File(ndkFolder, "source.properties"));
        Revision rev = PackageParserUtils.getRevisionProperty(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        return new LocalNdkPkgInfo(this, ndkFolder, props, rev);
    }

    private LocalLLDBPkgInfo scanLLDB(File lldbFolder) {
        File pinnedLLDBFolder = new File(lldbFolder, LocalLLDBPkgInfo.PINNED_REVISION.toString());
        Properties props = this.parseProperties(new File(pinnedLLDBFolder, "source.properties"));
        Revision rev = PackageParserUtils.getRevisionProperty(props, "Pkg.Revision");
        if (rev == null) {
            return null;
        }
        return new LocalLLDBPkgInfo(this, pinnedLLDBFolder, props, rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldVisitDir(PkgType pkgType, File directory) {
        if (!this.mFileOp.isDirectory(directory)) {
            return false;
        }
        Multimap<PkgType, LocalPkgInfo> multimap = this.mLocalPackages;
        synchronized (multimap) {
            if (this.mVisitedDirs.containsEntry((Object)pkgType, (Object)new LocalDirInfo.MapComparator(directory))) {
                return false;
            }
            this.mVisitedDirs.put((Object)pkgType, (Object)new LocalDirInfo(this.mFileOp, directory));
        }
        return true;
    }

    private void scanBuildTools(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File buildToolDir : this.mFileOp.listFiles(collectionDir)) {
            Properties props;
            Revision rev;
            if (!this.shouldVisitDir(PkgType.PKG_BUILD_TOOLS, buildToolDir) || (rev = PackageParserUtils.getRevisionProperty(props = this.parseProperties(new File(buildToolDir, "source.properties")), "Pkg.Revision")) == null) continue;
            rev = LocalSdk.fullySpecifyRevision(rev);
            BuildToolInfo btInfo = new BuildToolInfo(rev, buildToolDir);
            LocalBuildToolPkgInfo pkgInfo = new LocalBuildToolPkgInfo(this, buildToolDir, props, rev, btInfo);
            outCollection.add(pkgInfo);
        }
    }

    private void scanPlatforms(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            Properties props;
            Revision rev;
            if (!this.shouldVisitDir(PkgType.PKG_PLATFORM, platformDir) || (rev = PackageParserUtils.getRevisionProperty(props = this.parseProperties(new File(platformDir, "source.properties")), "Pkg.Revision")) == null) continue;
            Revision minToolsRev = PackageParserUtils.getRevisionProperty(props, "Platform.MinToolsRev");
            if (minToolsRev == null) {
                minToolsRev = Revision.NOT_SPECIFIED;
            }
            try {
                AndroidVersion vers = AndroidVersionHelper.create(props);
                LocalPlatformPkgInfo pkgInfo = new LocalPlatformPkgInfo(this, platformDir, props, vers, rev, minToolsRev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanAddons(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File addonDir : this.mFileOp.listFiles(collectionDir)) {
            Properties props;
            Revision rev;
            if (!this.shouldVisitDir(PkgType.PKG_ADDON, addonDir) || (rev = PackageParserUtils.getRevisionProperty(props = this.parseProperties(new File(addonDir, "source.properties")), "Pkg.Revision")) == null) continue;
            rev = LocalSdk.fullySpecifyRevision(rev);
            try {
                AndroidVersion vers = AndroidVersionHelper.create(props);
                String nameId = props.getProperty("Addon.NameId");
                String nameDisp = props.getProperty("Addon.NameDisplay");
                String vendorId = props.getProperty("Addon.VendorId");
                String vendorDisp = props.getProperty("Addon.VendorDisplay");
                if (nameId == null) {
                    nameDisp = props.getProperty("Addon.Name", "Unknown");
                    nameId = LocalAddonPkgInfo.sanitizeDisplayToNameId(nameDisp);
                }
                if (nameId != null && nameDisp == null) {
                    nameDisp = LocalExtraPkgInfo.getPrettyName(null, nameId);
                }
                if (vendorId != null && vendorDisp == null) {
                    vendorDisp = LocalExtraPkgInfo.getPrettyName(null, nameId);
                }
                if (vendorId == null) {
                    vendorDisp = props.getProperty("Addon.Vendor", "Unknown");
                    vendorId = LocalAddonPkgInfo.sanitizeDisplayToNameId(vendorDisp);
                }
                LocalAddonPkgInfo pkgInfo = new LocalAddonPkgInfo(this, addonDir, props, vers, rev, IdDisplay.create(vendorId, vendorDisp), IdDisplay.create(nameId, nameDisp));
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanSysImages(File collectionDir, Collection<LocalPkgInfo> outCollection, boolean scanAddons) {
        ArrayList propFiles = Lists.newArrayList();
        PkgType type = scanAddons ? PkgType.PKG_ADDON_SYS_IMAGE : PkgType.PKG_SYS_IMAGE;
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.shouldVisitDir(type, platformDir)) continue;
            for (File dir1 : this.mFileOp.listFiles(platformDir)) {
                File[] dir1Files;
                if (!this.shouldVisitDir(type, dir1)) continue;
                File prop1 = new File(dir1, "source.properties");
                if (this.mFileOp.isFile(prop1)) {
                    if (propFiles.contains(prop1)) continue;
                    propFiles.add(prop1);
                    continue;
                }
                for (File dir2 : dir1Files = this.mFileOp.listFiles(dir1)) {
                    File prop2;
                    if (!this.shouldVisitDir(type, dir2) || !this.mFileOp.isFile(prop2 = new File(dir2, "source.properties")) || propFiles.contains(prop2)) continue;
                    propFiles.add(prop2);
                }
            }
        }
        for (File propFile : propFiles) {
            Properties props = this.parseProperties(propFile);
            Revision rev = PackageParserUtils.getRevisionProperty(props, "Pkg.Revision");
            if (rev == null) continue;
            try {
                AndroidVersion vers = AndroidVersionHelper.create(props);
                IdDisplay tag = LocalSysImgPkgInfo.extractTagFromProps(props);
                String vendorId = props.getProperty("Addon.VendorId", null);
                File abiDir = propFile.getParentFile();
                if (vendorId == null && !scanAddons) {
                    LocalSysImgPkgInfo pkgInfo = new LocalSysImgPkgInfo(this, abiDir, props, vers, tag, abiDir.getName(), rev);
                    outCollection.add(pkgInfo);
                    continue;
                }
                if (vendorId == null || !scanAddons) continue;
                String vendorDisp = props.getProperty("Addon.VendorDisplay", vendorId);
                IdDisplay vendor = IdDisplay.create(vendorId, vendorDisp);
                LocalAddonSysImgPkgInfo pkgInfo = new LocalAddonSysImgPkgInfo(this, abiDir, props, vers, vendor, tag, abiDir.getName(), rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {}
        }
    }

    private void scanSamples(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            Properties props;
            Revision rev;
            if (!this.shouldVisitDir(PkgType.PKG_SAMPLE, platformDir) || (rev = PackageParserUtils.getRevisionProperty(props = this.parseProperties(new File(platformDir, "source.properties")), "Pkg.Revision")) == null) continue;
            Revision minToolsRev = PackageParserUtils.getRevisionProperty(props, "Platform.MinToolsRev");
            if (minToolsRev == null) {
                minToolsRev = Revision.NOT_SPECIFIED;
            }
            try {
                AndroidVersion vers = AndroidVersionHelper.create(props);
                LocalSamplePkgInfo pkgInfo = new LocalSamplePkgInfo(this, platformDir, props, vers, rev, minToolsRev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanSources(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            Properties props;
            Revision rev;
            if (!this.shouldVisitDir(PkgType.PKG_SOURCE, platformDir) || (rev = PackageParserUtils.getRevisionProperty(props = this.parseProperties(new File(platformDir, "source.properties")), "Pkg.Revision")) == null) continue;
            try {
                AndroidVersion vers = AndroidVersionHelper.create(props);
                LocalSourcePkgInfo pkgInfo = new LocalSourcePkgInfo(this, platformDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanExtras(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File vendorDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.shouldVisitDir(PkgType.PKG_EXTRA, vendorDir)) continue;
            for (File extraDir : this.mFileOp.listFiles(vendorDir)) {
                Properties props;
                Revision rev;
                if (!this.shouldVisitDir(PkgType.PKG_EXTRA, extraDir) || (rev = PackageParserUtils.getRevisionProperty(props = this.parseProperties(new File(extraDir, "source.properties")), "Pkg.Revision")) == null) continue;
                rev = LocalSdk.fullySpecifyRevision(rev);
                String oldPaths = PackageParserUtils.getProperty(props, "Extra.OldPaths", null);
                String vendorId = vendorDir.getName();
                String vendorDisp = props.getProperty("Extra.VendorDisplay");
                if (vendorDisp == null || vendorDisp.isEmpty()) {
                    vendorDisp = vendorId;
                }
                String displayName = props.getProperty("Extra.NameDisplay", null);
                LocalExtraPkgInfo pkgInfo = new LocalExtraPkgInfo(this, extraDir, props, IdDisplay.create(vendorId, vendorDisp), extraDir.getName(), displayName, PkgDescExtra.convertOldPaths(oldPaths), rev);
                outCollection.add(pkgInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File propsFile) {
        InputStream fis = null;
        try {
            if (this.mFileOp.exists(propsFile)) {
                fis = this.mFileOp.newFileInputStream(propsFile);
                Properties props = new Properties();
                props.load(fis);
                if (!props.isEmpty()) {
                    Properties properties = props;
                    return properties;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

