/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.AlignmentRules;
import com.android.builder.internal.packaging.zip.ByteArrayEntrySource;
import com.android.builder.internal.packaging.zip.CentralDirectory;
import com.android.builder.internal.packaging.zip.CentralDirectoryHeader;
import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.DataDescriptorType;
import com.android.builder.internal.packaging.zip.EntrySource;
import com.android.builder.internal.packaging.zip.Eocd;
import com.android.builder.internal.packaging.zip.FileEntrySource;
import com.android.builder.internal.packaging.zip.FileUseMap;
import com.android.builder.internal.packaging.zip.FileUseMapEntry;
import com.android.builder.internal.packaging.zip.InflaterEntrySource;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFileExtension;
import com.android.builder.internal.packaging.zip.ZipFileState;
import com.android.builder.internal.packaging.zip.utils.CachedFileContents;
import com.android.builder.internal.packaging.zip.utils.LittleEndianUtils;
import com.android.builder.internal.packaging.zip.utils.RandomAccessFileUtils;
import com.android.builder.internal.utils.IOExceptionFunction;
import com.android.builder.internal.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ZFile
implements Closeable {
    public static final char SEPARATOR = '/';
    private static final int MIN_EOCD_SIZE = 22;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int LAST_BYTES_TO_READ = 65557;
    private static final int ZIP64_EOCD_LOCATOR_SIGNATURE = 117853008;
    private static final int IO_BUFFER_SIZE = 0x100000;
    private final File mFile;
    private RandomAccessFile mRaf;
    private final FileUseMap mMap;
    private FileUseMapEntry<Eocd> mEocdEntry;
    private FileUseMapEntry<CentralDirectory> mDirectoryEntry;
    private final Map<String, FileUseMapEntry<StoredEntry>> mEntries;
    private ZipFileState mState;
    private boolean mDirty;
    private CachedFileContents<Object> mClosedControl;
    private final AlignmentRules mAlignmentRules;
    private final List<ZFileExtension> mExtensions;
    private final List<IOExceptionRunnable> mToRun;
    private boolean mIsNotifying;
    private long mExtraDirectoryOffset;

    public ZFile(File file) throws IOException {
        this.mFile = file;
        this.mMap = new FileUseMap(0);
        this.mDirty = false;
        this.mClosedControl = null;
        this.mAlignmentRules = new AlignmentRules();
        this.mExtensions = Lists.newArrayList();
        this.mToRun = Lists.newArrayList();
        if (file.exists()) {
            this.mState = ZipFileState.OPEN_RO;
            this.mRaf = new RandomAccessFile(file, "r");
        } else {
            this.mState = ZipFileState.CLOSED;
            this.mRaf = null;
            this.mDirty = true;
        }
        this.mEntries = Maps.newHashMap();
        this.mExtraDirectoryOffset = 0L;
        try {
            if (this.mState != ZipFileState.CLOSED) {
                long rafSize = this.mRaf.length();
                if (rafSize > Integer.MAX_VALUE) {
                    throw new IOException("File exceeds size limit of 2147483647.");
                }
                this.mMap.extend(Ints.checkedCast((long)rafSize));
                this.readData();
                this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

                    @Override
                    public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                        return input.open();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read zip file '" + file.getAbsolutePath() + "'.", e);
        }
    }

    public Set<StoredEntry> entries() {
        HashSet entries = Sets.newHashSet();
        for (FileUseMapEntry<StoredEntry> mapEntry : this.mEntries.values()) {
            entries.add(mapEntry.getStore());
        }
        return entries;
    }

    public StoredEntry get(String path) {
        FileUseMapEntry<StoredEntry> found = this.mEntries.get(path);
        if (found == null) {
            return null;
        }
        return found.getStore();
    }

    private void readData() throws IOException {
        long directoryStartOffset;
        long entryEndOffset;
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        this.readEocd();
        this.readCentralDirectory();
        if (this.mDirectoryEntry != null) {
            CentralDirectory directory = this.mDirectoryEntry.getStore();
            assert (directory != null);
            entryEndOffset = 0L;
            for (StoredEntry entry : directory.getEntries().values()) {
                long start = entry.getCentralDirectoryHeader().getOffset();
                long end = start + entry.getInFileSize();
                FileUseMapEntry<StoredEntry> mapEntry = this.mMap.add(start, end, entry);
                this.mEntries.put(entry.getCentralDirectoryHeader().getName(), mapEntry);
                if (end <= entryEndOffset) continue;
                entryEndOffset = end;
            }
            directoryStartOffset = this.mDirectoryEntry.getStart();
        } else {
            Verify.verifyNotNull(this.mEocdEntry);
            assert (this.mEocdEntry != null);
            directoryStartOffset = this.mEocdEntry.getStart();
            entryEndOffset = 0L;
        }
        long extraOffset = directoryStartOffset - entryEndOffset;
        Verify.verify((extraOffset >= 0L ? 1 : 0) != 0, (String)"extraOffset (%s) < 0", (Object[])new Object[]{extraOffset});
        this.setExtraDirectoryOffset(extraOffset);
    }

    private void readEocd() throws IOException {
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        int lastToRead = 65557;
        if ((long)lastToRead > this.mRaf.length()) {
            lastToRead = Ints.checkedCast((long)this.mRaf.length());
        }
        byte[] last = new byte[lastToRead];
        this.directFullyRead(this.mRaf.length() - (long)lastToRead, last);
        byte[] eocdSignature = new byte[]{6, 5, 75, 80};
        Eocd eocd = null;
        int foundEocdSignature = -1;
        IOException errorFindingSignature = null;
        int eocdStart = -1;
        for (int endIdx = last.length - 22; endIdx >= 0; --endIdx) {
            if (last[endIdx] != eocdSignature[3] || last[endIdx + 1] != eocdSignature[2] || last[endIdx + 2] != eocdSignature[1] || last[endIdx + 3] != eocdSignature[0]) continue;
            foundEocdSignature = endIdx;
            ByteSource eocdBytes = ByteSource.wrap((byte[])last).slice((long)foundEocdSignature, (long)last.length);
            try {
                eocd = new Eocd(eocdBytes);
                eocdStart = Ints.checkedCast((long)(this.mRaf.length() - (long)lastToRead + (long)foundEocdSignature));
                if ((long)eocdStart + eocd.getEocdSize() == this.mRaf.length()) continue;
                throw new IOException("EOCD starts at " + eocdStart + " and has " + eocd.getEocdSize() + " but file ends at " + this.mRaf.length() + ".");
            }
            catch (IOException e) {
                errorFindingSignature = e;
                foundEocdSignature = -1;
                eocd = null;
            }
        }
        if (foundEocdSignature == -1) {
            throw new IOException("EOCD signature not found in the last " + lastToRead + " bytes of the file.", errorFindingSignature);
        }
        Verify.verify((eocdStart >= 0 ? 1 : 0) != 0);
        int zip64LocatorStart = eocdStart - 20;
        if (zip64LocatorStart >= 0) {
            byte[] possibleZip64Locator = new byte[4];
            this.directFullyRead(zip64LocatorStart, possibleZip64Locator);
            if (LittleEndianUtils.readUnsigned4Le(ByteSource.wrap((byte[])possibleZip64Locator)) == 117853008L) {
                throw new IOException("Zip64 EOCD locator found but Zip64 format is not supported.");
            }
        }
        this.mEocdEntry = this.mMap.add(eocdStart, (long)eocdStart + eocd.getEocdSize(), eocd);
    }

    private void readCentralDirectory() throws IOException {
        Preconditions.checkNotNull(this.mEocdEntry, (Object)"mEocdEntry == null");
        Preconditions.checkNotNull((Object)this.mEocdEntry.getStore(), (Object)"mEocdEntry.getStore() == null");
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry != null");
        Eocd eocd = this.mEocdEntry.getStore();
        long dirSize = eocd.getDirectorySize();
        if (dirSize > Integer.MAX_VALUE) {
            throw new IOException("Cannot read central directory with size " + dirSize + ".");
        }
        if (eocd.getDirectoryOffset() + dirSize != this.mEocdEntry.getStart()) {
            throw new IOException("Central directory is stored in [" + eocd.getDirectoryOffset() + " - " + (eocd.getDirectoryOffset() + dirSize) + "] and EOCD starts at " + this.mEocdEntry.getStart() + ".");
        }
        byte[] directoryData = new byte[Ints.checkedCast((long)dirSize)];
        this.directFullyRead(eocd.getDirectoryOffset(), directoryData);
        CentralDirectory directory = CentralDirectory.makeFromData(ByteSource.wrap((byte[])directoryData), eocd.getTotalRecords(), this);
        if (eocd.getDirectorySize() > 0L) {
            this.mDirectoryEntry = this.mMap.add(eocd.getDirectoryOffset(), eocd.getDirectoryOffset() + eocd.getDirectorySize(), directory);
        }
    }

    public InputStream directOpen(final long start, final long end) throws IOException {
        Preconditions.checkState((this.mState != ZipFileState.CLOSED ? 1 : 0) != 0, (Object)"mState == ZipFileState.CLOSED");
        Preconditions.checkState((this.mRaf != null ? 1 : 0) != 0, (Object)"mRaf == null");
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"end < start");
        Preconditions.checkArgument((end <= this.mRaf.length() ? 1 : 0) != 0, (Object)"end > mRaf.length()");
        return new InputStream(){
            long mCurr;
            {
                this.mCurr = start;
            }

            @Override
            public int read() throws IOException {
                if (this.mCurr == end) {
                    return -1;
                }
                byte[] b = new byte[1];
                int r = ZFile.this.directRead(this.mCurr, b);
                if (r > 0) {
                    ++this.mCurr;
                    return b[0];
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Preconditions.checkNotNull((Object)b, (Object)"b == null");
                Preconditions.checkArgument((off >= 0 ? 1 : 0) != 0, (Object)"off < 0");
                Preconditions.checkArgument((off <= b.length ? 1 : 0) != 0, (Object)"off > b.length");
                Preconditions.checkArgument((len >= 0 ? 1 : 0) != 0, (Object)"len < 0");
                Preconditions.checkArgument((off + len <= b.length ? 1 : 0) != 0, (Object)"off + len > b.length");
                long availableToRead = end - this.mCurr;
                long toRead = Math.min((long)len, availableToRead);
                if (toRead == 0L) {
                    return -1;
                }
                if (toRead > Integer.MAX_VALUE) {
                    throw new IOException("Cannot read " + toRead + " bytes.");
                }
                int r = ZFile.this.directRead(this.mCurr, b, off, Ints.checkedCast((long)toRead));
                if (r > 0) {
                    this.mCurr += (long)r;
                }
                return r;
            }
        };
    }

    void delete(final StoredEntry entry, boolean notify) throws IOException {
        String path = entry.getCentralDirectoryHeader().getName();
        FileUseMapEntry<StoredEntry> mapEntry = this.mEntries.get(path);
        Preconditions.checkNotNull(mapEntry, (Object)"mapEntry == null");
        Preconditions.checkArgument((entry == mapEntry.getStore() ? 1 : 0) != 0, (Object)"entry != mapEntry.getStore()");
        this.mDirty = true;
        this.mMap.remove(mapEntry);
        this.mEntries.remove(path);
        if (notify) {
            this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

                @Override
                public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                    return input.removed(entry);
                }
            });
        }
    }

    public void update() throws IOException {
        this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

            @Override
            public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                Verify.verifyNotNull((Object)input);
                assert (input != null);
                return input.beforeUpdate();
            }
        });
        if (!this.mDirty) {
            return;
        }
        this.reopenRw();
        for (FileUseMapEntry<StoredEntry> entry : this.mEntries.values()) {
            StoredEntry entryStore = entry.getStore();
            assert (entryStore != null);
            if (entryStore.getCentralDirectoryHeader().getOffset() != -1L) continue;
            this.writeEntry(entry.getStore(), entry.getStart());
        }
        this.deleteDirectoryAndEocd();
        this.mMap.truncate();
        this.computeCentralDirectory();
        this.computeEocd();
        this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

            @Override
            public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                Verify.verifyNotNull((Object)input);
                assert (input != null);
                input.entriesWritten();
                return null;
            }
        });
        this.appendCentralDirectory();
        this.appendEocd();
        Verify.verifyNotNull((Object)this.mRaf);
        this.mRaf.setLength(this.mMap.size());
        this.mDirty = false;
        this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

            @Override
            public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                Verify.verifyNotNull((Object)input);
                assert (input != null);
                input.updated();
                return null;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.update();
        this.innerClose();
        this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

            @Override
            public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                input.closed();
                return null;
            }
        });
    }

    private void deleteDirectoryAndEocd() {
        if (this.mDirectoryEntry != null) {
            this.mMap.remove(this.mDirectoryEntry);
            this.mDirectoryEntry = null;
        }
        if (this.mEocdEntry != null) {
            this.mMap.remove(this.mEocdEntry);
            this.mEocdEntry = null;
        }
    }

    private void writeEntry(StoredEntry entry, long offset) throws IOException {
        int r;
        Preconditions.checkArgument((entry.getDataDescriptorType() == DataDescriptorType.NO_DATA_DESCRIPTOR ? 1 : 0) != 0, (Object)"Cannot write entries with a data descriptor.");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        byte[] headerData = entry.toHeaderData();
        this.directWrite(offset, headerData);
        EntrySource source = entry.getSource();
        if (source.innerCompressed() != null) {
            source = source.innerCompressed();
            assert (source != null);
        }
        Verify.verify((source.innerCompressed() == null ? 1 : 0) != 0);
        byte[] chunk = new byte[0x100000];
        long writeOffset = offset + (long)headerData.length;
        InputStream is = source.open();
        while ((r = is.read(chunk)) >= 0) {
            this.directWrite(writeOffset, chunk, 0, r);
            writeOffset += (long)r;
        }
        is.close();
        entry.getCentralDirectoryHeader().setOffset(offset);
        entry.createSourceFromZip();
    }

    private void computeCentralDirectory() throws IOException {
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry == null");
        HashSet newStored = Sets.newHashSet();
        for (FileUseMapEntry<StoredEntry> mapEntry : this.mEntries.values()) {
            newStored.add(mapEntry.getStore());
        }
        CentralDirectory newDirectory = CentralDirectory.makeFromEntries(newStored, this);
        byte[] newDirectoryBytes = newDirectory.toBytes();
        long directoryOffset = this.mMap.size() + this.mExtraDirectoryOffset;
        this.mMap.extend(directoryOffset + (long)newDirectoryBytes.length);
        if (newDirectoryBytes.length > 0) {
            this.mDirectoryEntry = this.mMap.add(directoryOffset, directoryOffset + (long)newDirectoryBytes.length, newDirectory);
        }
    }

    private void appendCentralDirectory() throws IOException {
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        if (this.mEntries.isEmpty()) {
            Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry != null");
            return;
        }
        Preconditions.checkNotNull(this.mDirectoryEntry, (Object)"mDirectoryEntry != null");
        CentralDirectory newDirectory = this.mDirectoryEntry.getStore();
        Verify.verifyNotNull((Object)newDirectory, (String)"newDirectory != null", (Object[])new Object[0]);
        byte[] newDirectoryBytes = newDirectory.toBytes();
        long directoryOffset = this.mDirectoryEntry.getStart();
        this.directWrite(directoryOffset, newDirectoryBytes);
    }

    public byte[] getCentralDirectoryBytes() throws IOException {
        if (this.mEntries.isEmpty()) {
            Preconditions.checkState((this.mDirectoryEntry == null ? 1 : 0) != 0, (Object)"mDirectoryEntry != null");
            return new byte[0];
        }
        Preconditions.checkNotNull(this.mDirectoryEntry, (Object)"mDirectoryEntry == null");
        CentralDirectory cd = this.mDirectoryEntry.getStore();
        Verify.verifyNotNull((Object)cd, (String)"cd == null", (Object[])new Object[0]);
        return cd.toBytes();
    }

    private void computeEocd() throws IOException {
        long dirStart;
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        if (this.mDirectoryEntry == null) {
            Preconditions.checkState((boolean)this.mEntries.isEmpty(), (Object)"mDirectoryEntry == null && !mEntries.isEmpty()");
        }
        long dirSize = 0L;
        if (this.mDirectoryEntry != null) {
            CentralDirectory directory = this.mDirectoryEntry.getStore();
            assert (directory != null);
            dirStart = this.mDirectoryEntry.getStart();
            dirSize = this.mDirectoryEntry.getSize();
            Verify.verify((directory.getEntries().size() == this.mEntries.size() ? 1 : 0) != 0);
        } else {
            dirStart = this.mExtraDirectoryOffset;
        }
        Eocd eocd = new Eocd(this.mEntries.size(), dirStart, dirSize);
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.mMap.size();
        this.mMap.extend(eocdOffset + (long)eocdBytes.length);
        this.mEocdEntry = this.mMap.add(eocdOffset, eocdOffset + (long)eocdBytes.length, eocd);
    }

    private void appendEocd() throws IOException {
        Preconditions.checkState((this.mState == ZipFileState.OPEN_RW ? 1 : 0) != 0, (Object)"mState != ZipFileState.OPEN_RW");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"mRaf == null");
        Preconditions.checkNotNull(this.mEocdEntry, (Object)"mEocdEntry == null");
        Eocd eocd = this.mEocdEntry.getStore();
        Verify.verifyNotNull((Object)eocd, (String)"eocd == null", (Object[])new Object[0]);
        byte[] eocdBytes = eocd.toBytes();
        long eocdOffset = this.mEocdEntry.getStart();
        this.directWrite(eocdOffset, eocdBytes);
    }

    public byte[] getEocdBytes() throws IOException {
        Preconditions.checkNotNull(this.mEocdEntry, (Object)"mEocdEntry == null");
        Eocd eocd = this.mEocdEntry.getStore();
        Verify.verifyNotNull((Object)eocd, (String)"eocd == null", (Object[])new Object[0]);
        return eocd.toBytes();
    }

    private void innerClose() throws IOException {
        if (this.mState == ZipFileState.CLOSED) {
            return;
        }
        Verify.verifyNotNull((Object)this.mRaf, (String)"mRaf == null", (Object[])new Object[0]);
        this.mRaf.close();
        this.mRaf = null;
        this.mState = ZipFileState.CLOSED;
        if (this.mClosedControl == null) {
            this.mClosedControl = new CachedFileContents(this.mFile);
        }
        this.mClosedControl.closed(null);
    }

    private void reopenRw() throws IOException {
        boolean wasClosed;
        if (this.mState == ZipFileState.OPEN_RW) {
            return;
        }
        if (this.mState == ZipFileState.OPEN_RO) {
            this.innerClose();
            wasClosed = false;
        } else {
            wasClosed = true;
        }
        Verify.verify((this.mState == ZipFileState.CLOSED ? 1 : 0) != 0, (String)"mState != ZpiFileState.CLOSED", (Object[])new Object[0]);
        Verify.verify((this.mRaf == null ? 1 : 0) != 0, (String)"mRaf != null", (Object[])new Object[0]);
        if (this.mClosedControl != null && !this.mClosedControl.isValid()) {
            throw new IOException("File '" + this.mFile.getAbsolutePath() + "' has been modified " + "by an external application.");
        }
        this.mRaf = new RandomAccessFile(this.mFile, "rw");
        this.mState = ZipFileState.OPEN_RW;
        if (wasClosed) {
            this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

                @Override
                public IOExceptionRunnable apply(ZFileExtension input) throws IOException {
                    return input.open();
                }
            });
        }
    }

    public void add(String name, EntrySource source, CompressionMethod method) throws IOException {
        CentralDirectoryHeader newFileData = new CentralDirectoryHeader(name, source.size(), source.size(), CompressionMethod.STORE);
        byte[] storeData = null;
        if (method == CompressionMethod.DEFLATE) {
            ByteArrayOutputStream sourceDataBytes = new ByteArrayOutputStream();
            InputStream sourceIn = source.open();
            ByteStreams.copy((InputStream)sourceIn, (OutputStream)sourceDataBytes);
            storeData = sourceDataBytes.toByteArray();
            byte[] deflatedData = ZFile.deflate(storeData);
            if (deflatedData.length < storeData.length) {
                storeData = deflatedData;
                newFileData.setMethod(CompressionMethod.DEFLATE);
                newFileData.setCompressedSize(deflatedData.length);
            }
            newFileData.setCrc32(Hashing.crc32().hashBytes(storeData).padToLong());
        }
        if (storeData != null) {
            source = new ByteArrayEntrySource(storeData);
            if (newFileData.getMethod() == CompressionMethod.DEFLATE) {
                source = new InflaterEntrySource(source, newFileData.getUncompressedSize());
            }
        }
        this.add(newFileData, source);
    }

    private void add(CentralDirectoryHeader newFileData, EntrySource source) throws IOException {
        StoredEntry replaceStore;
        FileUseMapEntry<StoredEntry> toReplace = this.mEntries.get(newFileData.getName());
        if (toReplace != null) {
            replaceStore = toReplace.getStore();
            assert (replaceStore != null);
            replaceStore.delete(false);
        } else {
            replaceStore = null;
        }
        Verify.verify((newFileData.getOffset() == -1L ? 1 : 0) != 0);
        final StoredEntry newEntry = new StoredEntry(newFileData, this);
        newEntry.setSource(source);
        this.deleteDirectoryAndEocd();
        long size = newEntry.getInFileSize();
        int localHeaderSize = newEntry.getLocalHeaderSize();
        int alignment = this.mAlignmentRules.alignment(newEntry.getCentralDirectoryHeader().getName());
        long newOffset = this.mMap.locateFree(size, localHeaderSize, alignment);
        long newEnd = newOffset + newEntry.getInFileSize();
        if (newEnd > this.mMap.size()) {
            this.mMap.extend(newEnd);
        }
        FileUseMapEntry<StoredEntry> fileUseMapEntry = this.mMap.add(newOffset, newEnd, newEntry);
        this.mEntries.put(newFileData.getName(), fileUseMapEntry);
        this.mDirty = true;
        this.notify(new IOExceptionFunction<ZFileExtension, IOExceptionRunnable>(){

            @Override
            public IOExceptionRunnable apply(ZFileExtension input) {
                return input.added(newEntry, replaceStore);
            }
        });
    }

    private static byte[] deflate(byte[] in) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(-1, true);
        Closer closer = Closer.create();
        try {
            DeflaterOutputStream dos = (DeflaterOutputStream)closer.register((Closeable)new DeflaterOutputStream((OutputStream)output, deflater));
            dos.write(in);
        }
        catch (IOException e) {
            throw closer.rethrow((Throwable)e);
        }
        finally {
            closer.close();
        }
        return output.toByteArray();
    }

    public void mergeFrom(ZFile src, Set<Pattern> ignorePatterns) throws IOException {
        block0: for (StoredEntry fromEntry : src.entries()) {
            int r;
            boolean usingCompressed;
            for (Pattern p : ignorePatterns) {
                if (!p.matcher(fromEntry.getCentralDirectoryHeader().getName()).matches()) continue;
                continue block0;
            }
            boolean replaceCurrent = true;
            String path = fromEntry.getCentralDirectoryHeader().getName();
            FileUseMapEntry<StoredEntry> currentEntry = this.mEntries.get(path);
            if (currentEntry != null) {
                long fromSize = fromEntry.getCentralDirectoryHeader().getUncompressedSize();
                long fromCrc = fromEntry.getCentralDirectoryHeader().getCrc32();
                StoredEntry currentStore = currentEntry.getStore();
                assert (currentStore != null);
                long currentSize = currentStore.getCentralDirectoryHeader().getUncompressedSize();
                long currentCrc = currentStore.getCentralDirectoryHeader().getCrc32();
                if (fromSize == currentSize && fromCrc == currentCrc) {
                    replaceCurrent = false;
                }
            }
            if (!replaceCurrent) continue;
            CentralDirectoryHeader fromCdr = fromEntry.getCentralDirectoryHeader();
            CentralDirectoryHeader newFileData = new CentralDirectoryHeader(fromCdr.getName(), fromCdr.getCompressedSize(), fromCdr.getUncompressedSize(), fromEntry.getCentralDirectoryHeader().getMethod());
            EntrySource fromSource = fromEntry.getSource();
            EntrySource compressedSource = fromSource.innerCompressed();
            if (compressedSource == null) {
                Verify.verify((newFileData.getMethod() == CompressionMethod.STORE ? 1 : 0) != 0);
                usingCompressed = false;
            } else {
                fromSource = compressedSource;
                usingCompressed = true;
            }
            InputStream fromInput = fromSource.open();
            long sourceSize = fromSource.size();
            if (sourceSize > Integer.MAX_VALUE) {
                throw new IOException("Cannot read source with " + sourceSize + " bytes.");
            }
            byte[] data = new byte[Ints.checkedCast((long)sourceSize)];
            for (int read = 0; read < data.length; read += r) {
                r = fromInput.read(data, read, data.length - read);
                Verify.verify((r >= 0 ? 1 : 0) != 0, (String)"There should be at least 'size' bytes in the stream.", (Object[])new Object[0]);
            }
            EntrySource newSource = new ByteArrayEntrySource(data);
            if (usingCompressed) {
                newSource = new InflaterEntrySource(newSource, fromCdr.getUncompressedSize());
            }
            this.add(newFileData, newSource);
        }
    }

    public void touch() {
        this.mDirty = true;
    }

    public AlignmentRules getAlignmentRules() {
        return this.mAlignmentRules;
    }

    public boolean realign() throws IOException {
        boolean anyChanges = false;
        for (StoredEntry entry : this.entries()) {
            anyChanges |= entry.realign();
        }
        return anyChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean realign(StoredEntry entry) throws IOException {
        CentralDirectoryHeader cdh;
        int expectedAlignment = this.mAlignmentRules.alignment(entry.getCentralDirectoryHeader().getName());
        FileUseMapEntry<StoredEntry> mapEntry = this.mEntries.get(entry.getCentralDirectoryHeader().getName());
        Verify.verify((entry == mapEntry.getStore() ? 1 : 0) != 0);
        long currentDataOffset = mapEntry.getStart() + (long)entry.getLocalHeaderSize();
        long disalignment = currentDataOffset % (long)expectedAlignment;
        if (disalignment == 0L) {
            return false;
        }
        if (entry.getCentralDirectoryHeader().getOffset() == -1L) {
            this.mMap.remove(mapEntry);
            long newStart = this.mMap.locateFree(mapEntry.getSize(), entry.getLocalHeaderSize(), expectedAlignment);
            mapEntry = this.mMap.add(newStart, newStart + entry.getInFileSize(), entry);
            this.mEntries.put(entry.getCentralDirectoryHeader().getName(), mapEntry);
            Verify.verify((boolean)this.mDirty);
            return false;
        }
        EntrySource source = entry.getSource();
        boolean sourceDeflated = false;
        if (source.innerCompressed() != null) {
            source = source.innerCompressed();
            assert (source != null);
            sourceDeflated = true;
            Verify.verify((entry.getCentralDirectoryHeader().getMethod() == CompressionMethod.DEFLATE ? 1 : 0) != 0);
        } else {
            Verify.verify((entry.getCentralDirectoryHeader().getMethod() == CompressionMethod.STORE ? 1 : 0) != 0);
        }
        InputStream is = source.open();
        boolean threw = true;
        byte[] entryData = null;
        try {
            entryData = ByteStreams.toByteArray((InputStream)is);
            threw = false;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)threw);
        }
        try {
            cdh = entry.getCentralDirectoryHeader().clone();
        }
        catch (CloneNotSupportedException e) {
            Verify.verify((boolean)false);
            return false;
        }
        cdh.setOffset(-1L);
        EntrySource newSource = new ByteArrayEntrySource(entryData);
        if (sourceDeflated) {
            newSource = new InflaterEntrySource(newSource, cdh.getUncompressedSize());
        }
        this.add(cdh, newSource);
        return true;
    }

    public void addZFileExtension(ZFileExtension extension) {
        this.mExtensions.add(extension);
    }

    public void removeZFileExtension(ZFileExtension extension) {
        this.mExtensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(IOExceptionFunction<ZFileExtension, IOExceptionRunnable> function) throws IOException {
        for (ZFileExtension fl : Lists.newArrayList(this.mExtensions)) {
            IOExceptionRunnable r = function.apply(fl);
            if (r == null) continue;
            this.mToRun.add(r);
        }
        if (!this.mIsNotifying) {
            this.mIsNotifying = true;
            try {
                while (!this.mToRun.isEmpty()) {
                    IOExceptionRunnable r = this.mToRun.remove(0);
                    r.run();
                }
            }
            finally {
                this.mIsNotifying = false;
            }
        }
    }

    public void directWrite(long offset, byte[] data, int start, int count) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start >= 0");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count >= 0");
        if (data.length == 0) {
            return;
        }
        Preconditions.checkArgument((start <= data.length ? 1 : 0) != 0, (Object)"start > data.length");
        Preconditions.checkArgument((start + count <= data.length ? 1 : 0) != 0, (Object)"start + count > data.length");
        this.reopenRw();
        assert (this.mRaf != null);
        this.mRaf.seek(offset);
        this.mRaf.write(data, start, count);
    }

    public void directWrite(long offset, byte[] data) throws IOException {
        this.directWrite(offset, data, 0, data.length);
    }

    public int directRead(long offset, byte[] data, int start, int count) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"start >= 0");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count >= 0");
        if (data.length == 0) {
            return 0;
        }
        Preconditions.checkArgument((start <= data.length ? 1 : 0) != 0, (Object)"start > data.length");
        Preconditions.checkArgument((start + count <= data.length ? 1 : 0) != 0, (Object)"start + count > data.length");
        if (this.mRaf == null) {
            this.reopenRw();
            assert (this.mRaf != null);
        }
        this.mRaf.seek(offset);
        return this.mRaf.read(data, start, count);
    }

    public int directRead(long offset, byte[] data) throws IOException {
        return this.directRead(offset, data, 0, data.length);
    }

    public void directFullyRead(long offset, byte[] data) throws IOException {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkNotNull((Object)this.mRaf, (Object)"File is closed");
        this.mRaf.seek(offset);
        RandomAccessFileUtils.fullyRead(this.mRaf, data);
    }

    public void addAllRecursively(File file, Function<File, CompressionMethod> method) throws IOException {
        if (file.isFile()) {
            CompressionMethod cm = (CompressionMethod)((Object)Verify.verifyNotNull((Object)method.apply((Object)file), (String)"method.apply() returned null", (Object[])new Object[0]));
            this.add(file.getName(), new FileEntrySource(file), cm);
            return;
        }
        for (File f : Files.fileTreeTraverser().preOrderTraversal((Object)file).skip(1)) {
            CompressionMethod cm;
            EntrySource source;
            String path = FileUtils.relativePath((File)f, (File)file);
            path = FileUtils.toSystemIndependentPath((String)path);
            if (f.isDirectory()) {
                source = new ByteArrayEntrySource(new byte[0]);
                cm = CompressionMethod.STORE;
            } else {
                source = new FileEntrySource(f);
                cm = (CompressionMethod)((Object)method.apply((Object)f));
                Verify.verifyNotNull((Object)((Object)cm), (String)"method.apply() returned null", (Object[])new Object[0]);
            }
            this.add(path, source, cm);
        }
    }

    public long getCentralDirectoryOffset() {
        if (this.mDirectoryEntry != null) {
            return this.mDirectoryEntry.getStart();
        }
        if (this.mEntries.isEmpty()) {
            return this.mExtraDirectoryOffset;
        }
        return this.mMap.usedSize() + this.mExtraDirectoryOffset;
    }

    public long getCentralDirectorySize() {
        if (this.mDirectoryEntry != null) {
            return this.mDirectoryEntry.getSize();
        }
        if (this.mEntries.isEmpty()) {
            return 0L;
        }
        return 1L;
    }

    public long getEocdOffset() {
        if (this.mEocdEntry == null) {
            return -1L;
        }
        return this.mEocdEntry.getStart();
    }

    public long getEocdSize() {
        if (this.mEocdEntry == null) {
            return -1L;
        }
        return this.mEocdEntry.getSize();
    }

    public void setExtraDirectoryOffset(long offset) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        if (this.mExtraDirectoryOffset != offset) {
            this.mExtraDirectoryOffset = offset;
            this.mDirty = true;
        }
    }

    public long getExtraDirectoryOffset() {
        return this.mExtraDirectoryOffset;
    }
}

