/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleLoginCopyAndPasteDialog
extends DialogWrapper {
    private static final String TITLE = "Sign in to Google Services";
    private static final String SUB_TITLE_1 = "Please sign in to Google Services from the link below.";
    private static final String SUB_TITLE_2 = "Copy and paste the verification code that will be provided into the text box below.";
    private static final String ERROR_MESSAGE = "Please log in using the Google Login url above, and copy and paste the generated verification code.";
    private String myVerificationCode = "";
    private String myUrlString;
    private JTextField myCodeTextField;

    public GoogleLoginCopyAndPasteDialog(JComponent parent, GoogleAuthorizationCodeRequestUrl requestUrl, String message) {
        super((Component)parent, true);
        this.myUrlString = requestUrl.build();
        if (message != null) {
            this.setTitle(message);
        } else {
            this.setTitle(TITLE);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(new JLabel(SUB_TITLE_1));
        mainPanel.add(new JLabel(SUB_TITLE_2));
        JPanel urlPanel = new JPanel(new BorderLayout());
        urlPanel.setLayout(new BoxLayout(urlPanel, 2));
        JLabel urlLabel = new JLabel(" Google Login Url: ");
        JTextField urlTextField = this.createUrlText();
        JPanel codePanel = new JPanel();
        codePanel.setLayout(new BoxLayout(codePanel, 2));
        JLabel codeLabel = new JLabel("Verification Code: ");
        this.createCodeText();
        urlLabel.setLabelFor(urlTextField);
        urlPanel.add(urlLabel);
        urlPanel.add(urlTextField);
        codeLabel.setLabelFor(this.myCodeTextField);
        codePanel.add(codeLabel);
        codePanel.add(this.myCodeTextField);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(urlPanel);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(codePanel);
        mainPanel.add(Box.createVerticalStrut(5));
        return mainPanel;
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myOKAction = new DialogWrapper.OkAction(){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                GoogleLoginCopyAndPasteDialog.this.myVerificationCode = GoogleLoginCopyAndPasteDialog.this.myCodeTextField.getText();
            }
        };
        if (action == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/login/ui/GoogleLoginCopyAndPasteDialog", "getOKAction"));
        }
        return action;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myCodeTextField.getText().isEmpty()) {
            return new ValidationInfo(ERROR_MESSAGE, (JComponent)this.myCodeTextField);
        }
        return null;
    }

    @NotNull
    public String getVerificationCode() {
        String string = this.myVerificationCode;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/login/ui/GoogleLoginCopyAndPasteDialog", "getVerificationCode"));
        }
        return string;
    }

    private JTextField createUrlText() {
        final JTextField urlTextField = new JTextField(this.myUrlString);
        urlTextField.setBorder(null);
        urlTextField.setEditable(false);
        urlTextField.setBackground(UIUtil.getLabelBackground());
        JPopupMenu popup = new JPopupMenu();
        urlTextField.add(popup);
        urlTextField.setComponentPopupMenu(popup);
        JMenuItem copyMenu = new JMenuItem("Copy");
        copyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                urlTextField.copy();
            }
        });
        popup.add(copyMenu);
        return urlTextField;
    }

    private void createCodeText() {
        this.myCodeTextField = new JTextField();
        JPopupMenu popup = new JPopupMenu();
        this.myCodeTextField.add(popup);
        this.myCodeTextField.setComponentPopupMenu(popup);
        JMenuItem copyMenu = new JMenuItem("Paste");
        copyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoogleLoginCopyAndPasteDialog.this.myCodeTextField.paste();
            }
        });
        popup.add(copyMenu);
    }
}

