/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.idea.rendering.AarResourceClassRegistry;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.WeakHashMap;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    public static final boolean DEBUG_CLASS_LOADING = false;
    private final Module myModule;
    private final LayoutLibrary myLibrary;
    private Map<String, VirtualFile> myClassFiles;
    private Map<String, ClassModificationTimestamp> myClassFilesLastModified;
    private static WeakHashMap<Module, ModuleClassLoader> ourCache = new WeakHashMap();

    private ModuleClassLoader(@NotNull LayoutLibrary library, @NotNull Module module) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/android/uipreview/ModuleClassLoader", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ModuleClassLoader", "<init>"));
        }
        super(library.getClassLoader());
        this.myLibrary = library;
        this.myModule = module;
    }

    @Override
    @NotNull
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            int index;
            if (!(this.myInsideJarClassLoader || (index = name.lastIndexOf(46)) == -1 || name.charAt(index + 1) != 'R' || index != name.length() - 2 && name.charAt(index + 2) != '$' || index <= 1)) {
                byte[] data;
                AppResourceRepository appResources = AppResourceRepository.getAppResources(this.myModule, false);
                if (appResources != null && (data = AarResourceClassRegistry.get(this.myModule.getProject()).findClassDefinition(name, appResources)) != null) {
                    data = this.convertClass(data);
                    Class<?> clazz2 = this.defineClassAndPackage(name, data, 0, data.length);
                    if (clazz2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "findClass"));
                    }
                    return clazz2;
                }
                throw e;
            }
            byte[] clazz3 = null;
            if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                clazz3 = RecyclerViewHelper.getAdapterClass();
            }
            if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                clazz3 = RecyclerViewHelper.getViewHolder();
            }
            if (clazz3 != null) {
                Class<?> clazz4 = this.defineClassAndPackage(name, clazz3, 0, clazz3.length);
                if (clazz4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "findClass"));
                }
                return clazz4;
            }
            throw e;
        }
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "findClass"));
        }
        return clazz;
    }

    @Nullable
    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> aClass = this.loadClassFromModuleOrDependency(this.myModule, name, (Set<Module>)new HashSet());
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            Class<?> clazz = aClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "load"));
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        if (!visited.add(module)) {
            return null;
        }
        Class<?> aClass = this.loadClassFromModule(module, name);
        if (aClass != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    @Nullable
    private Class<?> loadClassFromModule(Module module, String name) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        VirtualFile classFile = null;
        if (vOutFolder == null) {
            AndroidModel androidModel;
            if (facet != null && facet.requiresAndroidModel() && (androidModel = facet.getAndroidModel()) != null) {
                classFile = androidModel.getClassJarProvider().findModuleClassFile(name, module);
            }
        } else {
            classFile = ClassJarProvider.findClassFileInPath(vOutFolder, name);
        }
        if (classFile != null) {
            return this.loadClassFile(name, classFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(final @NotNull String fqcn, @Nullable Object myCredential) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "org/jetbrains/android/uipreview/ModuleClassLoader", "isSourceModified"));
        }
        VirtualFile classFile = this.getClassFile(fqcn);
        if (classFile != null) {
            boolean token = RenderSecurityManager.enterSafeRegion((Object)myCredential);
            try {
                VirtualFile virtualFile;
                long classFileModified = classFile.getTimeStamp();
                if (classFileModified > 0L && (virtualFile = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                    @Nullable
                    public VirtualFile compute() {
                        PsiFile containingFile;
                        Project project = ModuleClassLoader.this.myModule.getProject();
                        GlobalSearchScope scope = ModuleClassLoader.this.myModule.getModuleWithDependenciesScope();
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
                        PsiClass source = psiFacade.findClass(fqcn, scope);
                        if (source != null && (containingFile = source.getContainingFile()) != null) {
                            return containingFile.getVirtualFile();
                        }
                        return null;
                    }
                })) != null && !"R.java".equals(virtualFile.getName())) {
                    boolean modified = FileDocumentManager.getInstance().isFileModified(virtualFile);
                    if (!modified) {
                        Long projectBuildTimestamp;
                        File sourceFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                        long sourceFileModified = sourceFile.lastModified();
                        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
                        long lastBuildTimestamp = classFileModified;
                        if (facet != null && facet.requiresAndroidModel() && facet.getAndroidModel() != null && (projectBuildTimestamp = facet.getAndroidModel().getLastBuildTimestamp(this.myModule.getProject())) != null) {
                            lastBuildTimestamp = projectBuildTimestamp;
                        }
                        if (sourceFileModified > lastBuildTimestamp && lastBuildTimestamp > 0L) {
                            modified = true;
                        }
                    }
                    boolean bl = modified;
                    return bl;
                }
            }
            finally {
                RenderSecurityManager.exitSafeRegion((boolean)token);
            }
        }
        return false;
    }

    @Override
    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (classFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFile", "org/jetbrains/android/uipreview/ModuleClassLoader", "loadClassFile"));
        }
        if (this.myClassFiles == null) {
            this.myClassFiles = Maps.newHashMap();
            this.myClassFilesLastModified = Maps.newHashMap();
        }
        this.myClassFiles.put(fqcn, classFile);
        this.myClassFilesLastModified.put(fqcn, new ClassModificationTimestamp(classFile.getTimeStamp(), classFile.getLength()));
        return super.loadClassFile(fqcn, classFile);
    }

    @Override
    protected List<URL> getExternalJars() {
        List<VirtualFile> externalLibraries;
        AndroidFacet facet;
        ArrayList<URL> result = new ArrayList<URL>();
        URL customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl();
        if (customWidgetsUrl != null) {
            result.add(customWidgetsUrl);
        }
        if ((facet = AndroidFacet.getInstance(this.myModule)) != null && facet.requiresAndroidModel() && facet.getAndroidModel() != null) {
            AndroidModel androidModel = facet.getAndroidModel();
            externalLibraries = androidModel.getClassJarProvider().getModuleExternalLibraries(this.myModule);
        } else {
            externalLibraries = AndroidRootUtil.getExternalLibraries(this.myModule);
        }
        for (VirtualFile libFile : externalLibraries) {
            File file;
            if (!"jar".equals(libFile.getExtension()) || !(file = new File(libFile.getPath())).exists()) continue;
            try {
                AppResourceRepository appResources;
                result.add(SdkUtils.fileToUrl((File)file));
                File aarDir = file.getParentFile();
                if (aarDir == null || !aarDir.getPath().endsWith(".aar") && !aarDir.getPath().contains("exploded-aar")) continue;
                if (aarDir.getPath().contains("exploded-aar") && "jars".equals(aarDir.getName())) {
                    aarDir = aarDir.getParentFile();
                }
                if ((appResources = AppResourceRepository.getAppResources(this.myModule, true)) == null) continue;
                AarResourceClassRegistry.get(this.myModule.getProject()).addLibrary(appResources, aarDir);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    private VirtualFile getClassFile(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/uipreview/ModuleClassLoader", "getClassFile"));
        }
        if (this.myClassFiles == null) {
            return null;
        }
        VirtualFile file = this.myClassFiles.get(className);
        if (file == null) {
            return null;
        }
        return file.isValid() ? file : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, VirtualFile> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                VirtualFile classFile = entry.getValue();
                if (!classFile.isValid()) {
                    return false;
                }
                ClassModificationTimestamp lastModifiedStamp = this.myClassFilesLastModified.get(className);
                if (lastModifiedStamp == null) continue;
                long loadedModifiedTime = lastModifiedStamp.timestamp;
                long loadedModifiedLength = lastModifiedStamp.length;
                long classFileModifiedTime = classFile.getTimeStamp();
                long classFileModifiedLength = classFile.getLength();
                if ((classFileModifiedTime <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModifiedTime) && loadedModifiedLength == classFileModifiedLength) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static ModuleClassLoader get(@NotNull LayoutLibrary library, @NotNull Module module) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/android/uipreview/ModuleClassLoader", "get"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ModuleClassLoader", "get"));
        }
        ModuleClassLoader loader = (ModuleClassLoader)ourCache.get((Object)module);
        if (loader != null) {
            if (library != loader.myLibrary) {
                loader = null;
            } else if (!loader.isUpToDate()) {
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !updatedJarDependencies.equals(loader.myJarClassLoader.getUrls())) {
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            loader = new ModuleClassLoader(library, module);
            ourCache.put((Object)module, (Object)loader);
        }
        ModuleClassLoader moduleClassLoader = loader;
        if (moduleClassLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ModuleClassLoader", "get"));
        }
        return moduleClassLoader;
    }

    public static void clearCache() {
        ourCache.clear();
    }

    public static void clearCache(Module module) {
        if (ourCache.containsKey((Object)module)) {
            ourCache.remove((Object)module);
        }
    }

    public boolean isClassLoaded(String className) {
        return this.findLoadedClass(className) != null;
    }

    private static class ClassModificationTimestamp {
        public final long timestamp;
        public final long length;

        public ClassModificationTimestamp(long timestamp, long length) {
            this.timestamp = timestamp;
            this.length = length;
        }
    }
}

