/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.projectView;

import com.android.resources.ResourceFolderType;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.projectView.ResourceDirectoryNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceMergerTreeStructureProvider
implements TreeStructureProvider {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (parent instanceof PsiDirectoryNode) {
            PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)parent).getValue();
            if (!directory.getName().equals("res")) {
                Collection<AbstractTreeNode> collection = children;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
                }
                return collection;
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)directory);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                Collection<AbstractTreeNode> collection = children;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
                }
                return collection;
            }
            Collection<AbstractTreeNode> collection = ResourceMergerTreeStructureProvider.mergeResourceDirectories(children, settings);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
            }
            return collection;
        }
        Collection<AbstractTreeNode> collection = children;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/projectView/ResourceMergerTreeStructureProvider", "modify"));
        }
        return collection;
    }

    private static Collection<AbstractTreeNode> mergeResourceDirectories(Collection<AbstractTreeNode> children, ViewSettings settings) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        HashMap resourceDirectories = new HashMap();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof PsiDirectoryNode)) {
                result.add(child);
                continue;
            }
            PsiDirectoryNode directoryNode = (PsiDirectoryNode)child;
            PsiDirectory directory = (PsiDirectory)directoryNode.getValue();
            ResourceFolderType type = ResourceFolderType.getFolderType((String)directory.getName());
            if (type == null) {
                result.add(child);
                continue;
            }
            ResourceDirectoryNode node = (ResourceDirectoryNode)((Object)resourceDirectories.get(type));
            if (node != null && directory.getName().contains("-")) continue;
            node = new ResourceDirectoryNode(directoryNode.getProject(), directoryNode, settings);
            resourceDirectories.put(type, node);
        }
        for (ResourceDirectoryNode node : resourceDirectories.values()) {
            node.collectChildren();
            result.add((AbstractTreeNode)node);
        }
        return result;
    }

    @Nullable
    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        return null;
    }
}

