/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import org.jetbrains.android.newProject.AndroidAppPropertiesEditor;
import org.jetbrains.android.newProject.AndroidModuleBuilder;
import org.jetbrains.android.newProject.AndroidProjectType;
import org.jetbrains.annotations.NotNull;

public class AndroidModuleWizardStep
extends ModuleWizardStep {
    private final AndroidAppPropertiesEditor myAppPropertiesEditor;
    private final AndroidModuleBuilder myModuleBuilder;
    private final AndroidProjectType myProjectType;
    private final Alarm myAvdsUpdatingAlarm;
    private JPanel myPanel;
    private boolean myInitialized;

    public AndroidModuleWizardStep(@NotNull AndroidModuleBuilder moduleBuilder, ModulesProvider modulesProvider, AndroidProjectType projectType) {
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "org/jetbrains/android/newProject/AndroidModuleWizardStep", "<init>"));
        }
        this.myAvdsUpdatingAlarm = new Alarm();
        this.myProjectType = projectType;
        this.myModuleBuilder = moduleBuilder;
        this.myAppPropertiesEditor = new AndroidAppPropertiesEditor(moduleBuilder.getName(), modulesProvider);
        assert (projectType == AndroidProjectType.APPLICATION);
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new OverlayLayout(this.myPanel));
        this.myPanel.add(this.myAppPropertiesEditor.getContentPanel());
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myAvdsUpdatingAlarm);
    }

    public void updateStep() {
        if (!this.myInitialized) {
            this.myInitialized = true;
            this.initialize();
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAppPropertiesEditor.getApplicationNameField();
    }

    private void initialize() {
        String moduleName = this.myModuleBuilder.getName();
        if (moduleName != null) {
            this.myAppPropertiesEditor.getApplicationNameField().setText(moduleName);
            this.myAppPropertiesEditor.getPackageNameField().setText(AndroidAppPropertiesEditor.getDefaultPackageNameByModuleName(moduleName));
        }
    }

    public boolean validate() throws ConfigurationException {
        this.myAppPropertiesEditor.validate(this.myProjectType == AndroidProjectType.LIBRARY);
        return true;
    }

    public void updateDataModel() {
        this.myModuleBuilder.setActivityName(this.myAppPropertiesEditor.getActivityName());
        this.myModuleBuilder.setPackageName(this.myAppPropertiesEditor.getPackageName());
        String applicationName = this.myAppPropertiesEditor.getApplicationName();
        this.myModuleBuilder.setApplicationName(applicationName);
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.android";
    }
}

