/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidAnyTagDescriptor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.AndroidUnknownAttributeInspection;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidElementNotAllowedInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.element.not.allowed.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("AndroidElementNotAllowed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection", "getShortName"));
        }
        return "AndroidElementNotAllowed";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/android/inspections/AndroidElementNotAllowedInspection", "checkFile"));
        }
        if (!(file instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (AndroidUnknownAttributeInspection.isMyFile(facet, (XmlFile)file)) {
            MyVisitor visitor = new MyVisitor(manager, isOnTheFly);
            file.accept((PsiElementVisitor)visitor);
            return visitor.myResult.toArray(new ProblemDescriptor[visitor.myResult.size()]);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static boolean isUnknownCustomView(XmlTag tag) {
        ResourceFolderType type;
        PsiFile file = tag.getContainingFile();
        return file != null && (type = ResourceHelper.getFolderType(file)) == ResourceFolderType.LAYOUT && tag.getName().indexOf(46) != -1;
    }

    private static class MyVisitor
    extends XmlRecursiveElementVisitor {
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        final List<ProblemDescriptor> myResult = new ArrayList<ProblemDescriptor>();

        private MyVisitor(InspectionManager inspectionManager, boolean onTheFly) {
            this.myInspectionManager = inspectionManager;
            this.myOnTheFly = onTheFly;
        }

        public void visitXmlTag(XmlTag tag) {
            XmlElementDescriptor descriptor;
            super.visitXmlTag(tag);
            if (tag.getNamespace().isEmpty() && (descriptor = tag.getDescriptor()) instanceof AndroidAnyTagDescriptor) {
                XmlToken endTagNameElement;
                XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                if (startTagNameElement != null && !AndroidElementNotAllowedInspection.isUnknownCustomView(tag)) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)startTagNameElement, XmlErrorMessages.message((String)"element.is.not.allowed.here", (Object[])new Object[]{tag.getName()}), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                if ((endTagNameElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag)) != null && !AndroidElementNotAllowedInspection.isUnknownCustomView(tag)) {
                    this.myResult.add(this.myInspectionManager.createProblemDescriptor((PsiElement)endTagNameElement, XmlErrorMessages.message((String)"element.is.not.allowed.here", (Object[])new Object[]{tag.getName()}), this.myOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
            }
        }
    }
}

