/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.google.common.base.Splitter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFlagConverter
extends ResolvingConverter<String> {
    private final Set<String> myValues = new HashSet<String>();

    public LightFlagConverter(String ... values) {
        Collections.addAll(this.myValues, values);
    }

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        String flag;
        HashSet<String> result = new HashSet<String>();
        XmlElement element = context.getXmlElement();
        if (element == null) {
            HashSet<String> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/LightFlagConverter", "getVariants"));
            }
            return hashSet;
        }
        String attrValue = ((XmlAttribute)element).getValue();
        List flags = attrValue == null ? Collections.emptyList() : Splitter.on((char)'|').splitToList((CharSequence)attrValue);
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < flags.size() - 1 && this.myValues.contains(flag = (String)flags.get(i)); ++i) {
            prefix.append(flag).append('|');
        }
        for (String value : this.myValues) {
            result.add(prefix.toString() + value);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/LightFlagConverter", "getVariants"));
        }
        return hashSet;
    }

    public String fromString(@Nullable String s, ConvertContext convertContext) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext convertContext) {
        return s;
    }
}

