/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        ASTNode closingTagName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "getReferencesByElement"));
        }
        if (!(element instanceof XmlTag)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null || AndroidFacet.getInstance(module) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element.getNode());
        String baseClassQName = AndroidXmlReferenceProvider.computeBaseClass((XmlTag)element);
        if (baseClassQName == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        XmlTag tag = (XmlTag)element;
        if (startTagName != null && AndroidXmlReferenceProvider.areReferencesProvidedByReferenceProvider(startTagName)) {
            AndroidXmlReferenceProvider.addReferences(tag, startTagName.getPsi(), result, module, baseClassQName, true);
        }
        if ((closingTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(element.getNode())) != null && AndroidXmlReferenceProvider.areReferencesProvidedByReferenceProvider(closingTagName)) {
            AndroidXmlReferenceProvider.addReferences(tag, closingTagName.getPsi(), result, module, baseClassQName, false);
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static void addReferences(@NotNull XmlTag tag, @NotNull PsiElement nameElement, @NotNull List<PsiReference> result, @NotNull Module module, @NotNull String baseClassQName, boolean startTag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "addReferences"));
        }
        if (nameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameElement", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "addReferences"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "addReferences"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "addReferences"));
        }
        if (baseClassQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassQName", "org/jetbrains/android/dom/AndroidXmlReferenceProvider", "addReferences"));
        }
        String text = nameElement.getText();
        if (text == null) {
            return;
        }
        String[] nameParts = text.split("\\.");
        if (nameParts.length == 0) {
            return;
        }
        int offset = 0;
        for (int i = 0; i < nameParts.length; ++i) {
            String name = nameParts[i];
            if (name.length() > 0) {
                TextRange range = new TextRange((offset += name.length()) - name.length(), offset);
                boolean isPackage = i < nameParts.length - 1;
                result.add((PsiReference)new MyClassOrPackageReference(tag, nameElement, range, isPackage, module, baseClassQName, startTag));
            }
            ++offset;
        }
    }

    public static boolean areReferencesProvidedByReferenceProvider(ASTNode nameElement) {
        if (nameElement != null) {
            String baseClassQName;
            XmlTag tag;
            PsiElement psiNameElement = nameElement.getPsi();
            XmlTag xmlTag = tag = psiNameElement != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiNameElement, XmlTag.class) : null;
            if (tag != null && (baseClassQName = AndroidXmlReferenceProvider.computeBaseClass(tag)) != null) {
                return nameElement.getText().contains(".");
            }
        }
        return false;
    }

    @Nullable
    private static String computeBaseClass(XmlTag context) {
        XmlTag parentTag = context.getParentTag();
        Pair<AndroidDomElement, String> pair = AndroidDomElementDescriptorProvider.getDomElementAndBaseClassQName(parentTag != null ? parentTag : context);
        return pair != null ? (String)pair.getSecond() : null;
    }

    private static class MyClassOrPackageReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myNameElement;
        private final TextRange myRangeInNameElement;
        private final boolean myIsPackage;
        private final Module myModule;
        private final String myBaseClassQName;
        private final boolean myStartTag;

        public MyClassOrPackageReference(@NotNull XmlTag tag, @NotNull PsiElement nameElement, @NotNull TextRange rangeInNameElement, boolean isPackage, @NotNull Module module, @NotNull String baseClassQName, boolean startTag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "<init>"));
            }
            if (nameElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameElement", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "<init>"));
            }
            if (rangeInNameElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInNameElement", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "<init>"));
            }
            if (baseClassQName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassQName", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "<init>"));
            }
            super((PsiElement)tag, MyClassOrPackageReference.rangeInParent(nameElement, rangeInNameElement), true);
            this.myNameElement = nameElement;
            this.myRangeInNameElement = rangeInNameElement;
            this.myIsPackage = isPackage;
            this.myModule = module;
            this.myBaseClassQName = baseClassQName;
            this.myStartTag = startTag;
        }

        private static TextRange rangeInParent(PsiElement element, TextRange range) {
            int offset = element.getStartOffsetInParent();
            return new TextRange(range.getStartOffset() + offset, range.getEndOffset() + offset);
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                @Nullable
                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    if (reference == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference$1", "resolve"));
                    }
                    return MyClassOrPackageReference.this.resolveInner();
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            int end = this.myRangeInNameElement.getEndOffset();
            String value = this.myNameElement.getText().substring(0, end);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            return this.myIsPackage ? facade.findPackage(value) : facade.findClass(value, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
        }

        @NotNull
        public Object[] getVariants() {
            final String prefix = this.myNameElement.getText().substring(0, this.myRangeInNameElement.getStartOffset());
            if (!this.myStartTag) {
                String startTagName;
                ASTNode startTagNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(this.myElement.getNode());
                if (startTagNode != null && (startTagName = startTagNode.getText()).startsWith(prefix)) {
                    Object[] objectArray = new Object[]{startTagName.substring(prefix.length())};
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "getVariants"));
                    }
                    return objectArray;
                }
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
            Project project = this.myModule.getProject();
            PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myBaseClassQName, this.myModule.getModuleWithDependenciesAndLibrariesScope(false));
            if (baseClass == null) {
                if (EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "getVariants"));
                }
                return EMPTY_ARRAY;
            }
            final ArrayList result = new ArrayList();
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)this.myModule.getModuleWithDependenciesAndLibrariesScope(false), (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    if (psiClass.getContainingClass() != null) {
                        return true;
                    }
                    String name = psiClass.getQualifiedName();
                    if (name != null && name.startsWith(prefix)) {
                        name = name.substring(prefix.length());
                        result.add(JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)name, (boolean)true));
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "getVariants"));
            }
            return objectArray;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidXmlReferenceProvider$MyClassOrPackageReference", "bindToElement"));
            }
            String newName = this.myIsPackage ? ((PsiPackage)element).getQualifiedName() : ((PsiClass)element).getQualifiedName();
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myNameElement);
            TextRange range = new TextRange(0, this.myRangeInNameElement.getEndOffset());
            return manipulator != null ? manipulator.handleContentChange(this.myNameElement, range, newName) : element;
        }

        @Nullable
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myNameElement);
            assert (manipulator != null) : "Cannot find manipulator for " + this.myNameElement;
            return manipulator.handleContentChange(this.myNameElement, this.myRangeInNameElement, newElementName);
        }
    }
}

