/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SimpleClassMapConstructor;
import org.jetbrains.annotations.NotNull;

public class AndroidClassTagNameReference
extends TagNameReference {
    public AndroidClassTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        super(nameElement, startTagFlag);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/dom/AndroidClassTagNameReference", "bindToElement"));
        }
        assert (element instanceof PsiClass);
        XmlTag tagElement = this.getTagElement();
        assert (tagElement != null);
        AndroidFacet facet = AndroidFacet.getInstance(element);
        int minimumApi = facet == null ? -1 : facet.getModuleMinApi();
        String tagName = (String)ArrayUtil.getFirstElement((Object[])SimpleClassMapConstructor.getInstance().getTagNamesByClass((PsiClass)element, minimumApi));
        return tagElement.setName(tagName != null ? tagName : "");
    }

    public boolean isSoft() {
        return true;
    }
}

