/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable.editors;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.editors.ComboEditor;
import com.intellij.openapi.ui.ComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsComboEditor
extends ComboEditor {
    public static final String UNSET = "<unset>";

    public StringsComboEditor(String[] values) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(values);
        model.insertElementAt(UNSET, 0);
        this.myCombo.setModel(model);
        this.myCombo.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringsComboEditor.this.myCombo.getSelectedItem() == StringsComboEditor.UNSET) {
                    StringsComboEditor.this.myCombo.setSelectedItem(null);
                }
            }
        });
        this.myCombo.setSelectedIndex(0);
    }

    public Object getValue() throws Exception {
        Object item = this.myCombo.getSelectedItem();
        return item == UNSET ? null : item;
    }

    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, @Nullable PropertyContext context, Object value, @Nullable InplaceContext inplaceContext) {
        this.myCombo.setSelectedItem(value);
        this.myCombo.setBorder(inplaceContext == null ? null : this.myComboBorder);
        ComboBox comboBox = this.myCombo;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/editors/StringsComboEditor", "getComponent"));
        }
        return comboBox;
    }
}

