/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout;

import com.android.tools.idea.designer.LinearLayoutResizeOperation;
import com.android.tools.idea.designer.ResizeOperation;
import com.intellij.android.designer.designSurface.TreeDropToOperation;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.designSurface.graphics.DrawingStyle;
import com.intellij.android.designer.designSurface.graphics.ResizeSelectionDecorator;
import com.intellij.android.designer.designSurface.layout.LinearLayoutOperation;
import com.intellij.android.designer.designSurface.layout.actions.LayoutMarginOperation;
import com.intellij.android.designer.designSurface.layout.flow.FlowStaticDecorator;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayoutWithData;
import com.intellij.android.designer.model.layout.Gravity;
import com.intellij.android.designer.model.layout.actions.AbstractGravityAction;
import com.intellij.android.designer.model.layout.actions.AssignWeightAction;
import com.intellij.android.designer.model.layout.actions.BaselineAction;
import com.intellij.android.designer.model.layout.actions.ClearWeightsAction;
import com.intellij.android.designer.model.layout.actions.DistributeWeightsAction;
import com.intellij.android.designer.model.layout.actions.DominateWeightsAction;
import com.intellij.android.designer.model.layout.actions.OrientationAction;
import com.intellij.designer.componentTree.TreeEditOperation;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.ILayoutDecorator;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.StaticDecorator;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RadLinearLayout
extends RadViewLayoutWithData
implements ILayoutDecorator {
    private static final String[] LAYOUT_PARAMS = new String[]{"LinearLayout_Layout", "ViewGroup_MarginLayout"};
    private ResizeSelectionDecorator mySelectionDecorator;
    private FlowStaticDecorator myLineDecorator;
    private static final int POINTS_SIZE = 16;
    private static final List<Gravity> HORIZONTALS = Arrays.asList(Gravity.left, Gravity.center, Gravity.right, null);
    private static final List<Gravity> VERTICALS = Arrays.asList(Gravity.top, Gravity.center, Gravity.bottom, null);

    @Override
    @NotNull
    public String[] getLayoutParams() {
        if (LAYOUT_PARAMS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/RadLinearLayout", "getLayoutParams"));
        }
        return LAYOUT_PARAMS;
    }

    public boolean isHorizontal() {
        return !"vertical".equals(((RadViewComponent)this.myContainer).getTag().getAttributeValue("orientation", "http://schemas.android.com/apk/res/android"));
    }

    public EditOperation processChildOperation(OperationContext context) {
        if (context.isCreate() || context.isPaste() || context.isAdd() || context.isMove()) {
            if (context.isTree()) {
                if (TreeEditOperation.isTarget((RadComponent)this.myContainer, (OperationContext)context)) {
                    return new TreeDropToOperation(this.myContainer, context);
                }
                return null;
            }
            return new LinearLayoutOperation(this.myContainer, context, this.isHorizontal());
        }
        if (context.is((Object)"resize_children")) {
            return new LinearLayoutResizeOperation(context);
        }
        if (context.is((Object)"layout_margin")) {
            return new LayoutMarginOperation(context);
        }
        return null;
    }

    private StaticDecorator getLineDecorator() {
        if (this.myLineDecorator == null) {
            this.myLineDecorator = new FlowStaticDecorator(this.myContainer){

                @Override
                protected boolean isHorizontal() {
                    return RadLinearLayout.this.isHorizontal();
                }
            };
        }
        return this.myLineDecorator;
    }

    @Override
    public void addStaticDecorators(List<StaticDecorator> decorators, List<RadComponent> selection) {
    }

    @Override
    public ComponentDecorator getChildSelectionDecorator(RadComponent component, List<RadComponent> selection) {
        if (this.mySelectionDecorator == null) {
            this.mySelectionDecorator = new ResizeSelectionDecorator(DrawingStyle.SELECTION){

                protected boolean visible(RadComponent component, ResizePoint point) {
                    if (point.getType() == "layout_margin") {
                        boolean goodHeight;
                        boolean horizontal = RadLinearLayout.this.isHorizontal();
                        Pair<Gravity, Gravity> gravity = Gravity.getSides(component);
                        int direction = ((DirectionResizePoint)point).getDirection();
                        Rectangle bounds = component.getBounds();
                        boolean goodWidth = bounds.width >= 16;
                        boolean bl = goodHeight = bounds.height >= 16;
                        if (direction == 4) {
                            return (horizontal || gravity.first != Gravity.right) && goodHeight;
                        }
                        if (direction == 8) {
                            return (horizontal || gravity.first != Gravity.left) && goodHeight;
                        }
                        if (direction == 1) {
                            return (!horizontal || gravity.second != Gravity.bottom) && goodWidth;
                        }
                        if (direction == 2) {
                            return (!horizontal || gravity.second != Gravity.top) && goodWidth;
                        }
                    }
                    return true;
                }
            };
        }
        this.mySelectionDecorator.clear();
        if (selection.size() == 1) {
            ResizeOperation.addResizePoints(this.mySelectionDecorator, (RadViewComponent)selection.get(0));
        } else {
            ResizeOperation.addResizePoints(this.mySelectionDecorator);
        }
        return this.mySelectionDecorator;
    }

    protected boolean supportsOrientation() {
        return true;
    }

    @Override
    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selectedChildren) {
        RadViewComponent layout = (RadViewComponent)this.myContainer;
        List<RadViewComponent> children = RadViewComponent.getViewComponents(layout.getChildren());
        boolean addSeparator = false;
        if (this.supportsOrientation()) {
            actionGroup.add((AnAction)new OrientationAction(designer, layout, true));
            addSeparator = true;
        }
        if (this.isHorizontal()) {
            actionGroup.add((AnAction)new BaselineAction(designer, layout));
            addSeparator = true;
        }
        if (addSeparator) {
            actionGroup.addSeparator();
            addSeparator = false;
        }
        if (!selectedChildren.isEmpty()) {
            actionGroup.add((AnAction)new GravityAction(designer, selectedChildren));
            addSeparator = true;
        }
        if (addSeparator) {
            actionGroup.addSeparator();
        }
        super.addContainerSelectionActions(designer, actionGroup, selectedChildren);
        actionGroup.addSeparator();
        List<RadViewComponent> multipleChildren = selectedChildren.size() <= 1 ? children : selectedChildren;
        actionGroup.add((AnAction)new DistributeWeightsAction(designer, layout, multipleChildren));
        if (!selectedChildren.isEmpty()) {
            actionGroup.add((AnAction)new DominateWeightsAction(designer, layout, selectedChildren));
            actionGroup.add((AnAction)new AssignWeightAction(designer, layout, selectedChildren));
        }
        actionGroup.add((AnAction)new ClearWeightsAction(designer, layout, multipleChildren));
    }

    public boolean isWrapIn(List<RadComponent> components) {
        int i;
        List children = this.myContainer.getChildren();
        int[] indexes = new int[components.size()];
        for (i = 0; i < indexes.length; ++i) {
            indexes[i] = children.indexOf(components.get(i));
        }
        Arrays.sort(indexes);
        for (i = 0; i < indexes.length - 1; ++i) {
            if (indexes[i + 1] - indexes[i] == 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void wrapIn(final RadViewComponent newParent, final List<RadViewComponent> components) throws Exception {
        final boolean horizontal = this.isHorizontal();
        RadViewComponent firstComponent = components.get(0);
        boolean single = components.size() == 1;
        String layoutWidth = single ? firstComponent.getTag().getAttributeValue("layout_width", "http://schemas.android.com/apk/res/android") : "wrap_content";
        String layoutHeight = single ? firstComponent.getTag().getAttributeValue("layout_height", "http://schemas.android.com/apk/res/android") : "wrap_content";
        String layoutGravity = firstComponent.getTag().getAttributeValue("layout_gravity", "http://schemas.android.com/apk/res/android");
        if (horizontal) {
            for (RadViewComponent component : components.subList(1, components.size())) {
                String height = component.getTag().getAttributeValue("layout_height", "http://schemas.android.com/apk/res/android");
                if ("fill_parent".equals(height) || "match_parent".equals(height)) {
                    layoutHeight = "match_parent";
                    layoutGravity = null;
                }
                if (layoutGravity != null && !layoutGravity.equals(component.getTag().getAttributeValue("layout_gravity", "http://schemas.android.com/apk/res/android"))) continue;
            }
        }
        if (newParent.getLayout() instanceof RadLinearLayout) {
            RadLinearLayout layout = (RadLinearLayout)newParent.getLayout();
            if (horizontal != layout.isHorizontal()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        newParent.getTag().setAttribute("orientation", "http://schemas.android.com/apk/res/android", horizontal ? "horizontal" : "vertical");
                    }
                });
            }
        } else {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (RadViewComponent component : components) {
                        RadComponentOperations.deleteAttribute(component.getTag(), "layout_gravity");
                    }
                }
            });
        }
    }

    private class GravityAction
    extends AbstractGravityAction<Gravity> {
        private Gravity mySelection;

        public GravityAction(DesignerEditorPanel designer, List<? extends RadViewComponent> components) {
            super(designer, components);
        }

        @Override
        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            boolean horizontal = RadLinearLayout.this.isHorizontal();
            Gravity unknown = horizontal ? Gravity.left : Gravity.top;
            this.setItems(horizontal ? VERTICALS : HORIZONTALS, unknown);
            Iterator I = this.myComponents.iterator();
            this.mySelection = LinearLayoutOperation.getGravity(horizontal, (RadComponent)I.next());
            while (I.hasNext()) {
                if (this.mySelection == LinearLayoutOperation.getGravity(horizontal, (RadComponent)I.next())) continue;
                this.mySelection = unknown;
                break;
            }
            DefaultActionGroup defaultActionGroup = super.createPopupActionGroup(button);
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/RadLinearLayout$GravityAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        @Override
        protected void update(Gravity item, Presentation presentation, boolean popup) {
            if (popup) {
                presentation.setIcon(this.mySelection == item ? CHECKED : null);
                presentation.setText(item == null ? "fill" : item.name());
            }
        }

        @Override
        protected boolean selectionChanged(final Gravity item) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    LinearLayoutOperation.applyGravity(RadLinearLayout.this.isHorizontal(), item, GravityAction.this.myComponents);
                }
            });
            return false;
        }

        @Override
        public void update() {
        }
    }
}

