/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.grid;

import com.intellij.designer.model.RadComponent;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridInfo {
    public int width;
    public int height;
    public int[] hLines;
    public int[] vLines;
    public boolean[] emptyColumns;
    public boolean[] emptyRows;
    public RadComponent grid;
    public RadComponent[][] components;
    public int rowCount;
    public int columnCount;
    public int lastInsertRow;
    public int lastInsertColumn;
    private static final int NEW_CELL_SIZE = 32;

    public GridInfo(@NotNull RadComponent grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/android/designer/model/grid/GridInfo", "<init>"));
        }
        this.hLines = ArrayUtil.EMPTY_INT_ARRAY;
        this.vLines = ArrayUtil.EMPTY_INT_ARRAY;
        this.emptyColumns = ArrayUtil.EMPTY_BOOLEAN_ARRAY;
        this.emptyRows = ArrayUtil.EMPTY_BOOLEAN_ARRAY;
        this.lastInsertRow = -1;
        this.lastInsertColumn = -1;
        this.grid = grid;
    }

    @NotNull
    public Dimension getSize(@NotNull Component target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/android/designer/model/grid/GridInfo", "getSize"));
        }
        Dimension dimension = this.grid.fromModel(target, new Dimension(this.width, this.height));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/grid/GridInfo", "getSize"));
        }
        return dimension;
    }

    @NotNull
    public Point getCellPosition(@NotNull Component target, int row, int column) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/android/designer/model/grid/GridInfo", "getCellPosition"));
        }
        Dimension size = this.grid.fromModel(target, new Dimension(this.vLines[column], this.hLines[row]));
        Point point = new Point(size.width, size.height);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/grid/GridInfo", "getCellPosition"));
        }
        return point;
    }

    public static int[] addLineInfo(int[] oldLines, int delta) {
        if (delta > 0) {
            int newLength = oldLines.length + delta / 32;
            if (newLength > oldLines.length) {
                int[] newLines = new int[newLength];
                int startIndex = oldLines.length;
                if (oldLines.length > 0) {
                    System.arraycopy(oldLines, 0, newLines, 0, oldLines.length);
                } else {
                    startIndex = 1;
                }
                for (int i = startIndex; i < newLength; ++i) {
                    newLines[i] = newLines[i - 1] + 32;
                }
                return newLines;
            }
            return oldLines;
        }
        return oldLines;
    }

    public static void setNull(RadComponent[][] components1, @Nullable RadComponent[][] components2, int startRow, int endRow, int startColumn, int endColumn) {
        endRow = Math.min(endRow, components1.length);
        endColumn = Math.min(endColumn, components1[0].length);
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startColumn; j < endColumn; ++j) {
                components1[i][j] = null;
                if (components2 == null) continue;
                components2[i][j] = null;
            }
        }
    }
}

