/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.core.ObservableString;
import com.android.tools.idea.ui.properties.expressions.bool.BooleanExpressions;
import com.android.tools.idea.ui.properties.swing.EnabledProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizardDialog
extends DialogWrapper {
    @NotNull
    private ModelWizard myWizard;
    private BindingsManager myBindings;
    private ListenerManager myListeners;
    @Nullable
    private CustomLayout myCustomLayout;

    public ModelWizardDialog(@NotNull ModelWizard wizard, @NotNull String title, @Nullable CustomLayout customLayout, @Nullable Project project, @NotNull DialogWrapper.IdeModalityType modalityType) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/wizard/model/ModelWizardDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/model/ModelWizardDialog", "<init>"));
        }
        if (modalityType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityType", "com/android/tools/idea/wizard/model/ModelWizardDialog", "<init>"));
        }
        super(project, true, modalityType);
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.init(wizard, title, customLayout);
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard, @NotNull String title, @NotNull Component parent, @Nullable CustomLayout customLayout) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/wizard/model/ModelWizardDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/model/ModelWizardDialog", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/wizard/model/ModelWizardDialog", "<init>"));
        }
        super(parent, true);
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.init(wizard, title, customLayout);
    }

    private void init(@NotNull ModelWizard wizard, @NotNull String title, @Nullable CustomLayout customLayout) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/wizard/model/ModelWizardDialog", "init"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/wizard/model/ModelWizardDialog", "init"));
        }
        Disposer.register((Disposable)this.getDisposable(), (Disposable)wizard);
        this.myWizard = wizard;
        this.myCustomLayout = customLayout;
        this.setTitle(title);
        this.init();
        if (customLayout != null) {
            Disposer.register((Disposable)wizard, (Disposable)customLayout);
        }
    }

    protected void dispose() {
        super.dispose();
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    public void show() {
        this.getContentPanel().setMinimumSize(this.getSize());
        super.show();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog", "getStyle"));
        }
        return dialogStyle;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel wizardContent = this.myWizard.getContentPanel();
        JPanel centerPanel = this.myCustomLayout != null ? this.myCustomLayout.decorate(this.myWizard.title(), wizardContent) : wizardContent;
        return centerPanel;
    }

    @NotNull
    protected Action[] createActions() {
        NextAction nextAction = new NextAction();
        PreviousAction prevAction = new PreviousAction();
        FinishAction finishAction = new FinishAction();
        if (this.getHelpId() == null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.getCancelAction(), prevAction, nextAction, finishAction};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{prevAction, nextAction, this.getCancelAction(), finishAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog", "createActions"));
            }
            return actionArray;
        }
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getCancelAction(), prevAction, nextAction, finishAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{prevAction, nextAction, this.getCancelAction(), finishAction, this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog", "createActions"));
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myWizard.getPreferredFocusComponent();
    }

    protected JButton createJButtonForAction(Action action) {
        final JButton button = super.createJButtonForAction(action);
        if (action instanceof ModelWizardDialogAction) {
            ModelWizardDialogAction wizardAction = (ModelWizardDialogAction)((Object)action);
            this.myBindings.bind(new EnabledProperty(button), wizardAction.shouldBeEnabled());
            this.myListeners.listenAndFire(wizardAction.shouldBeDefault(), new Consumer<Boolean>(){

                public void consume(Boolean isDefault) {
                    JRootPane rootPane = ModelWizardDialog.this.getRootPane();
                    if (rootPane != null && isDefault.booleanValue()) {
                        rootPane.setDefaultButton(button);
                    }
                }
            });
        }
        return button;
    }

    private final class FinishAction
    extends ModelWizardDialogAction {
        FinishAction() {
            super(IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goForward();
            ModelWizardDialog.this.doOKAction();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.onLastStep().and(ModelWizardDialog.this.myWizard.canGoForward());
            if (observableBool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$FinishAction", "shouldBeEnabled"));
            }
            return observableBool;
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.onLastStep();
            if (observableBool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$FinishAction", "shouldBeDefault"));
            }
            return observableBool;
        }
    }

    private final class PreviousAction
    extends ModelWizardDialogAction {
        PreviousAction() {
            super(IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goBack();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.canGoBack();
            if (observableBool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$PreviousAction", "shouldBeEnabled"));
            }
            return observableBool;
        }
    }

    private final class NextAction
    extends ModelWizardDialogAction {
        NextAction() {
            super(IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.canGoForward().and(BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep()));
            if (observableBool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$NextAction", "shouldBeEnabled"));
            }
            return observableBool;
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            ObservableBool observableBool = BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep());
            if (observableBool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$NextAction", "shouldBeDefault"));
            }
            return observableBool;
        }
    }

    private abstract class ModelWizardDialogAction
    extends DialogWrapper.DialogWrapperAction {
        public ModelWizardDialogAction(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/wizard/model/ModelWizardDialog$ModelWizardDialogAction", "<init>"));
            }
            super((DialogWrapper)ModelWizardDialog.this, name);
        }

        @NotNull
        public abstract ObservableBool shouldBeEnabled();

        @NotNull
        public ObservableBool shouldBeDefault() {
            ObservableBool observableBool = BooleanExpressions.alwaysFalse();
            if (observableBool == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$ModelWizardDialogAction", "shouldBeDefault"));
            }
            return observableBool;
        }
    }

    public static interface CustomLayout
    extends Disposable {
        @NotNull
        public JPanel decorate(@NotNull ObservableString var1, @NotNull JPanel var2);
    }
}

