/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.ConfirmFirstRunWizardCloseDialog;
import com.android.tools.idea.welcome.wizard.ConsolidatedProgressStep;
import com.android.tools.idea.welcome.wizard.FirstRunWelcomeStep;
import com.android.tools.idea.welcome.wizard.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.InstallationTypeWizardStep;
import com.android.tools.idea.welcome.wizard.LinuxHaxmInfoStep;
import com.android.tools.idea.welcome.wizard.MissingSdkAlertStep;
import com.android.tools.idea.welcome.wizard.SelectThemeStep;
import com.android.tools.idea.welcome.wizard.SetupJdkPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.dynamic.SingleStepPath;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class FirstRunWizard
extends DynamicWizard {
    public static final String WIZARD_TITLE = "Android Studio Setup Wizard";
    public static final ScopedStateStore.Key<Boolean> KEY_CUSTOM_INSTALL = ScopedStateStore.createKey("custom.install", ScopedStateStore.Scope.WIZARD, Boolean.class);
    @NotNull
    private final FirstRunWizardMode myMode;
    @NotNull
    private final Map<String, RemotePackage> myRemotePackages;
    private final AtomicInteger myFinishClicks;
    private final SetupJdkPath myJdkPath;
    private InstallComponentsPath myComponentsPath;

    public FirstRunWizard(@NotNull DynamicWizardHost host, @NotNull FirstRunWizardMode mode, @NotNull Map<String, RemotePackage> remotePackages) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/welcome/wizard/FirstRunWizard", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/wizard/FirstRunWizard", "<init>"));
        }
        if (remotePackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePackages", "com/android/tools/idea/welcome/wizard/FirstRunWizard", "<init>"));
        }
        super(null, null, WIZARD_TITLE, host);
        this.myFinishClicks = new AtomicInteger(0);
        this.myMode = mode;
        this.myJdkPath = new SetupJdkPath(mode);
        this.myRemotePackages = remotePackages;
        this.setTitle(WIZARD_TITLE);
    }

    @Override
    public void init() {
        File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(this.myMode);
        FirstRunProgressStep progressStep = new FirstRunProgressStep();
        this.myComponentsPath = new InstallComponentsPath(this.myRemotePackages, this.myMode, initialSdkLocation, progressStep, true);
        if (this.myMode == FirstRunWizardMode.NEW_INSTALL) {
            boolean sdkExists = false;
            if (initialSdkLocation.isDirectory()) {
                StudioLoggerProgressIndicator progress;
                AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)initialSdkLocation);
                sdkExists = sdkHandler.getLocalPackage("tools", (ProgressIndicator)(progress = new StudioLoggerProgressIndicator(this.getClass()))) != null;
            }
            this.addPath(new SingleStepPath(new FirstRunWelcomeStep(sdkExists)));
        }
        this.addPath(this.myJdkPath);
        if (this.myMode == FirstRunWizardMode.NEW_INSTALL) {
            if (initialSdkLocation.getPath().isEmpty()) {
                this.myState.put(KEY_CUSTOM_INSTALL, true);
            } else {
                this.addPath(new SingleStepPath(new InstallationTypeWizardStep(KEY_CUSTOM_INSTALL)));
            }
            this.addPath(new SingleStepPath(new SelectThemeStep(KEY_CUSTOM_INSTALL)));
        }
        if (this.myMode == FirstRunWizardMode.MISSING_SDK) {
            this.addPath(new SingleStepPath(new MissingSdkAlertStep()));
        }
        this.addPath(this.myComponentsPath);
        if (SystemInfo.isLinux && this.myMode == FirstRunWizardMode.NEW_INSTALL) {
            this.addPath(new SingleStepPath(new LinuxHaxmInfoStep()));
        }
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            this.addPath(new SingleStepPath(new LicenseAgreementStep(this.getDisposable())));
        }
        this.addPath(new SingleStepPath(progressStep));
        super.init();
    }

    @Override
    public void doCancelAction() {
        ConfirmFirstRunWizardCloseDialog.Result result = new ConfirmFirstRunWizardCloseDialog().open();
        switch (result) {
            case Skip: {
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myMode.getInstallerTimestamp());
            }
            case Rerun: {
                this.myHost.close(DynamicWizardHost.CloseAction.CANCEL);
                break;
            }
        }
    }

    @Override
    public void doFinishAction() {
        if (this.myFinishClicks.incrementAndGet() == 1) {
            this.doNextAction();
        } else {
            assert (this.myFinishClicks.get() <= 2);
            super.doFinishAction();
        }
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        if ("Finishing setup..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/FirstRunWizard", "getProgressTitle"));
        }
        return "Finishing setup...";
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    protected String getWizardActionDescription() {
        return WIZARD_TITLE;
    }

    public class FirstRunProgressStep
    extends ConsolidatedProgressStep {
        public FirstRunProgressStep() {
            super(FirstRunWizard.this.getDisposable(), FirstRunWizard.this.myHost);
            this.setPaths(FirstRunWizard.this.myPaths);
        }

        @Override
        public boolean isStepVisible() {
            return FirstRunWizard.this.myFinishClicks.get() == 1 && (FirstRunWizard.this.myJdkPath.shouldDownloadingComponentsStepBeShown() || FirstRunWizard.this.myComponentsPath.shouldDownloadingComponentsStepBeShown());
        }
    }
}

