/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.Downloader;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.installer.PackageInstaller;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.meta.DetailsTypes;
import com.android.tools.idea.sdkv2.StudioDownloader;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.StudioSdkUtil;
import com.android.tools.idea.sdkv2.StudioSettingsController;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallSelectedPackagesStep
extends ModelWizardStep.WithoutModel {
    private final BoolProperty myInstallFailed;
    private final BoolProperty myInstallationFinished;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myContentPanel;
    private JBLabel myLabelSdkPath;
    private JBLabel myProgressOverallLabel;
    private JTextArea mySdkManagerOutput;
    private JProgressBar myProgressBar;
    private JBLabel myProgressDetailLabel;
    private List<RemotePackage> myInstallRequests;
    private final RepoManager myRepoManager;
    private final AndroidSdkHandler mySdkHandler;
    private CustomLogger myCustomLogger;
    private static final Object LOGGER_LOCK = new Object();
    @NotNull
    private final SettingsController mySettings;
    @NotNull
    private final Runnable myOnError;

    public InstallSelectedPackagesStep(@NotNull List<RemotePackage> installRequests, @NotNull RepoManager mgr, @NotNull AndroidSdkHandler sdkHandler) {
        if (installRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installRequests", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep", "<init>"));
        }
        if (mgr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep", "<init>"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep", "<init>"));
        }
        super("Component Installer");
        this.$$$setupUI$$$();
        this.myInstallFailed = new BoolValueProperty();
        this.myInstallationFinished = new BoolValueProperty();
        this.mySettings = StudioSettingsController.getInstance();
        this.myOnError = new Runnable(){

            @Override
            public void run() {
                InstallSelectedPackagesStep.this.myInstallFailed.set(true);
                InstallSelectedPackagesStep.this.myProgressBar.setEnabled(false);
            }
        };
        this.myInstallRequests = installRequests;
        this.myRepoManager = mgr;
        this.mySdkHandler = sdkHandler;
        this.myValidatorPanel = new ValidatorPanel(this, this.myContentPanel);
        this.myStudioPanel = new StudioWizardStepPanel(this.myValidatorPanel, "Installing Requested Components");
    }

    private static void checkForUpgrades(@Nullable List<? extends RepoPackage> completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (RepoPackage repoPackage : completedChanges) {
            int api;
            TypeDetails details = repoPackage.getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (api = ((DetailsTypes.PlatformDetailsType)details).getApiLevel()) <= highestNewApiLevel) continue;
            highestNewApiLevel = api;
        }
        if (highestNewApiLevel > 0) {
            PropertiesComponent.getInstance().setValue(WizardConstants.NEWLY_INSTALLED_API_KEY.name, highestNewApiLevel, -1);
        }
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep", "onWizardStarting"));
        }
        this.myValidatorPanel.registerValidator(this.myInstallationFinished, new Validator<Boolean>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Boolean value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$2", "validate"));
                }
                Validator.Result result = value != false ? Validator.Result.OK : new Validator.Result(Validator.Severity.INFO, "Please wait until the installation finishes to continue");
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$2", "validate"));
                }
                return result;
            }
        });
        this.myValidatorPanel.registerValidator(this.myInstallFailed, new Validator<Boolean>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Boolean value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$3", "validate"));
                }
                String error = "Install Failed. Please check your network connection and try again. You may continue with creating your project, but it will not compile correctly without the missing components.";
                Validator.Result result = value != false ? new Validator.Result(Validator.Severity.ERROR, error) : Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$3", "validate"));
                }
                return result;
            }
        });
    }

    @Override
    protected void onEntering() {
        this.mySdkManagerOutput.setText("");
        this.myLabelSdkPath.setText(this.myRepoManager.getLocalPath().getPath());
        this.startSdkInstall();
    }

    @Override
    protected boolean shouldShow() {
        return this.myInstallRequests.size() > 0;
    }

    @Override
    public boolean canGoBack() {
        return false;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        BoolProperty boolProperty = this.myInstallationFinished;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep", "canGoForward"));
        }
        return boolProperty;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myStudioPanel;
        if (studioWizardStepPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep", "getComponent"));
        }
        return studioWizardStepPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = LOGGER_LOCK;
        synchronized (object) {
            if (this.myCustomLogger != null) {
                this.myCustomLogger.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSdkInstall() {
        Object object = LOGGER_LOCK;
        synchronized (object) {
            this.myCustomLogger = new CustomLogger();
        }
        InstallTask task = new InstallTask(this.myInstallRequests, this.myCustomLogger);
        boolean hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
        Object indicator = hasOpenProjects ? new BackgroundableProcessIndicator((Task.Backgroundable)task) : new EmptyProgressIndicator();
        this.myCustomLogger.setIndicator((ProgressIndicator)indicator);
        this.myCustomLogger.logInfo("To install:");
        for (RemotePackage p : this.myInstallRequests) {
            this.myCustomLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
        }
        this.myCustomLogger.logInfo("");
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JTextArea jTextArea;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySdkManagerOutput = jTextArea = new JTextArea();
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myProgressOverallLabel = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myProgressDetailLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setBackground(new Color(-3355444));
        jBLabel.setVerticalAlignment(1);
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private final class CustomLogger
    implements com.android.repository.api.ProgressIndicator {
        private ProgressIndicator myIndicator;
        private boolean myCancelled;
        private Logger myLogger = Logger.getInstance(this.getClass());

        private CustomLogger() {
        }

        public void setText(final @Nullable String s) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    InstallSelectedPackagesStep.this.myProgressOverallLabel.setText(s);
                }
            });
            if (this.myIndicator != null) {
                this.myIndicator.setText(s);
            }
        }

        public boolean isCanceled() {
            return this.myCancelled;
        }

        public void cancel() {
            this.myCancelled = true;
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }

        public void setCancellable(boolean cancellable) {
        }

        public boolean isCancellable() {
            return true;
        }

        public void setIndeterminate(final boolean indeterminate) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(indeterminate);
                }
            });
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(indeterminate);
            }
        }

        public boolean isIndeterminate() {
            return false;
        }

        public void setFraction(final double v) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    InstallSelectedPackagesStep.this.myProgressBar.setValue((int)(v * (double)(InstallSelectedPackagesStep.this.myProgressBar.getMaximum() - InstallSelectedPackagesStep.this.myProgressBar.getMinimum())));
                }
            });
            if (this.myIndicator != null) {
                this.myIndicator.setFraction(v);
            }
        }

        public double getFraction() {
            return InstallSelectedPackagesStep.this.myProgressBar.getPercentComplete();
        }

        public void setSecondaryText(final @Nullable String s) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    InstallSelectedPackagesStep.this.myProgressDetailLabel.setText(s);
                }
            });
            if (this.myIndicator != null) {
                this.myIndicator.setText2(s);
            }
        }

        public void logWarning(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger", "logWarning"));
            }
            this.appendText(s);
            this.myLogger.warn(s);
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger", "logWarning"));
            }
            this.appendText(s);
            this.myLogger.warn(s, e);
        }

        public void logError(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger", "logError"));
            }
            this.appendText(s);
            this.myLogger.error(s);
        }

        public void logError(@NotNull String s, @Nullable Throwable e) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger", "logError"));
            }
            this.appendText(s);
            this.myLogger.error(s, e);
        }

        public void logInfo(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger", "logInfo"));
            }
            this.appendText(s);
            this.myLogger.info(s);
        }

        private void appendText(final @NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$CustomLogger", "appendText"));
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    String current = InstallSelectedPackagesStep.this.mySdkManagerOutput.getText();
                    if (current == null) {
                        current = "";
                    }
                    InstallSelectedPackagesStep.this.mySdkManagerOutput.setText(current + "\n" + s);
                }
            });
        }

        public void setIndicator(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }
    }

    private class InstallTask
    extends Task.Backgroundable {
        @NotNull
        private final List<RemotePackage> myRequestedPackages;
        @NotNull
        private final com.android.repository.api.ProgressIndicator myProgress;

        public void onCancel() {
            this.myProgress.cancel();
        }

        private InstallTask(@NotNull List<RemotePackage> requestedPackages, com.android.repository.api.ProgressIndicator progress) {
            if (requestedPackages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$InstallTask", "<init>"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$InstallTask", "<init>"));
            }
            super(null, "Installing Android SDK", true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.myRequestedPackages = requestedPackages;
            this.myProgress = progress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            ArrayList failures;
            block17: {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdk/wizard/InstallSelectedPackagesStep$InstallTask", "run"));
                }
                failures = Lists.newArrayList();
                try {
                    for (RemotePackage remote : this.myRequestedPackages) {
                        PackageInstaller installer = StudioSdkUtil.findBestInstaller((RepoPackage)remote);
                        InstallSelectedPackagesStep.this.myCustomLogger.logInfo(String.format("Installing %1$s", remote.getDisplayName()));
                        boolean success = false;
                        try {
                            success = installer.install(remote, (Downloader)new StudioDownloader(indicator), InstallSelectedPackagesStep.this.mySettings, this.myProgress, InstallSelectedPackagesStep.this.myRepoManager, InstallSelectedPackagesStep.this.mySdkHandler.getFileOp());
                        }
                        catch (Exception e) {
                            Logger.getInstance(((Object)((Object)this)).getClass()).warn((Throwable)e);
                        }
                        if (!success) {
                            InstallSelectedPackagesStep.this.myCustomLogger.logInfo(String.format("Failed to install %1$s!", remote.getDisplayName()));
                            failures.add(remote);
                        } else {
                            InstallSelectedPackagesStep.this.myCustomLogger.logInfo(String.format("Installation of %1$s complete.", remote.getDisplayName()));
                        }
                        InstallSelectedPackagesStep.this.myCustomLogger.logInfo("");
                    }
                    if (failures.isEmpty()) break block17;
                    InstallSelectedPackagesStep.this.myCustomLogger.logInfo("Failed packages:");
                }
                catch (Throwable throwable) {
                    if (!failures.isEmpty()) {
                        InstallSelectedPackagesStep.this.myCustomLogger.logInfo("Failed packages:");
                        for (RemotePackage p : failures) {
                            InstallSelectedPackagesStep.this.myCustomLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                        }
                    }
                    Iterator iterator = LOGGER_LOCK;
                    synchronized (iterator) {
                        InstallSelectedPackagesStep.this.myCustomLogger = null;
                    }
                    throw throwable;
                }
                for (RemotePackage p : failures) {
                    InstallSelectedPackagesStep.this.myCustomLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                }
            }
            Iterator iterator = LOGGER_LOCK;
            synchronized (iterator) {
                InstallSelectedPackagesStep.this.myCustomLogger = null;
            }
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
            InstallSelectedPackagesStep.this.myRepoManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (com.android.repository.api.ProgressIndicator)progress, null, StudioSettingsController.getInstance());
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    InstallSelectedPackagesStep.this.myProgressBar.setValue(100);
                    InstallSelectedPackagesStep.this.myProgressOverallLabel.setText("");
                    if (!failures.isEmpty()) {
                        InstallSelectedPackagesStep.this.myInstallFailed.set(true);
                        InstallSelectedPackagesStep.this.myProgressBar.setEnabled(false);
                    } else {
                        InstallSelectedPackagesStep.this.myProgressDetailLabel.setText("Done");
                        InstallSelectedPackagesStep.checkForUpgrades(InstallTask.this.myRequestedPackages);
                    }
                    InstallSelectedPackagesStep.this.myInstallationFinished.set(true);
                    VirtualFile sdkDir = LocalFileSystem.getInstance().findFileByIoFile(InstallSelectedPackagesStep.this.myRepoManager.getLocalPath());
                    if (sdkDir != null) {
                        sdkDir.refresh(true, true);
                    }
                }
            });
        }
    }
}

