/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationError
implements Comparable<ValidationError> {
    @NotNull
    private final Severity mySeverity;
    @NotNull
    private final String myMessage;
    @Nullable
    private final Runnable myQuickfix;

    private ValidationError(@NotNull Severity severity, @NotNull String message, @Nullable Runnable quickfix) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/run/ValidationError", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ValidationError", "<init>"));
        }
        this.mySeverity = severity;
        this.myMessage = message;
        this.myQuickfix = quickfix;
    }

    @NotNull
    public static ValidationError fatal(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ValidationError", "fatal"));
        }
        ValidationError validationError = ValidationError.fatal(message, null);
        if (validationError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "fatal"));
        }
        return validationError;
    }

    @NotNull
    public static ValidationError fatal(@NotNull String message, @Nullable Runnable quickfix) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ValidationError", "fatal"));
        }
        ValidationError validationError = new ValidationError(Severity.FATAL, message, quickfix);
        if (validationError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "fatal"));
        }
        return validationError;
    }

    @NotNull
    public static ValidationError warning(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ValidationError", "warning"));
        }
        ValidationError validationError = ValidationError.warning(message, null);
        if (validationError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "warning"));
        }
        return validationError;
    }

    @NotNull
    public static ValidationError warning(@NotNull String message, @Nullable Runnable quickfix) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ValidationError", "warning"));
        }
        ValidationError validationError = new ValidationError(Severity.WARNING, message, quickfix);
        if (validationError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "warning"));
        }
        return validationError;
    }

    @NotNull
    public static ValidationError fromException(@NotNull RuntimeConfigurationException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/run/ValidationError", "fromException"));
        }
        if (e instanceof RuntimeConfigurationError) {
            ValidationError validationError = ValidationError.fatal(e.getMessage(), e.getQuickFix());
            if (validationError == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "fromException"));
            }
            return validationError;
        }
        ValidationError validationError = ValidationError.warning(e.getMessage(), e.getQuickFix());
        if (validationError == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "fromException"));
        }
        return validationError;
    }

    @NotNull
    public Severity getSeverity() {
        Severity severity = this.mySeverity;
        if (severity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "getSeverity"));
        }
        return severity;
    }

    @NotNull
    public String getMessage() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ValidationError", "getMessage"));
        }
        return string;
    }

    @Nullable
    public Runnable getQuickfix() {
        return this.myQuickfix;
    }

    public boolean isFatal() {
        return this.mySeverity.equals((Object)Severity.FATAL);
    }

    @Override
    public int compareTo(ValidationError o) {
        return this.mySeverity.compareTo(o.getSeverity());
    }

    public static enum Severity {
        WARNING,
        FATAL;

    }
}

