/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.run.DeviceStateCache;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstalledPatchCache
implements Disposable {
    private final DeviceStateCache<PatchState> myCache = new DeviceStateCache(this);

    public long getInstalledManifestTimestamp(@NotNull IDevice device, @NotNull String pkgName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "getInstalledManifestTimestamp"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "getInstalledManifestTimestamp"));
        }
        PatchState state = this.getState(device, pkgName, false);
        return state == null ? 0L : state.manifestModified;
    }

    public void setInstalledManifestTimestamp(@NotNull IDevice device, @NotNull String pkgName, long timestamp) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "setInstalledManifestTimestamp"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "setInstalledManifestTimestamp"));
        }
        this.getState((IDevice)device, (String)pkgName, (boolean)true).manifestModified = timestamp;
    }

    @Nullable
    public HashCode getInstalledManifestResourcesHash(@NotNull IDevice device, @NotNull String pkgName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "getInstalledManifestResourcesHash"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "getInstalledManifestResourcesHash"));
        }
        PatchState state = this.getState(device, pkgName, false);
        return state == null ? null : state.manifestResources;
    }

    public void setInstalledManifestResourcesHash(@NotNull IDevice device, @NotNull String pkgName, HashCode hash) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "setInstalledManifestResourcesHash"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "setInstalledManifestResourcesHash"));
        }
        this.getState((IDevice)device, (String)pkgName, (boolean)true).manifestResources = hash;
    }

    @Contract(value="!null, !null, true -> !null")
    @Nullable
    private PatchState getState(@NotNull IDevice device, @NotNull String pkgName, boolean create) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledPatchCache", "getState"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledPatchCache", "getState"));
        }
        PatchState state = this.myCache.get(device, pkgName);
        if (state == null && create) {
            state = new PatchState();
            this.myCache.put(device, pkgName, state);
        }
        return state;
    }

    @NotNull
    public static HashCode computeManifestResources(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/InstalledPatchCache", "computeManifestResources"));
        }
        File manifest = InstantRunManager.findMergedManifestFile(facet);
        if (manifest != null) {
            HashFunction hashFunction = Hashing.goodFastHash((int)32);
            final AppResourceRepository resources = AppResourceRepository.getAppResources(facet, true);
            final Hasher hasher = hashFunction.newHasher();
            try {
                String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
                xml = xml.replace("        android:name=\"com.android.tools.fd.runtime.BootstrapApplication\"\n", "");
                hasher.putString((CharSequence)xml, Charsets.UTF_8);
                final Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document != null && document.getDocumentElement() != null) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            InstalledPatchCache.hashResources(document.getDocumentElement(), hasher, resources);
                        }
                    });
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            HashCode hashCode = hasher.hash();
            if (hashCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/InstalledPatchCache", "computeManifestResources"));
            }
            return hashCode;
        }
        HashCode hashCode = HashCode.fromInt((int)0);
        if (hashCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/InstalledPatchCache", "computeManifestResources"));
        }
        return hashCode;
    }

    private static void hashResources(Element element, Hasher hasher, AppResourceRepository resources) {
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            List items;
            ResourceUrl url;
            Node attribute = attributes.item(i);
            String value = attribute.getNodeValue();
            if (!value.startsWith("@") || (url = ResourceUrl.parse((String)value)) == null || url.framework || (items = resources.getResourceItem(url.type, url.name)) == null) continue;
            for (ResourceItem item : items) {
                String text;
                ResourceValue resourceValue = item.getResourceValue(false);
                if (resourceValue == null || (text = resourceValue.getValue()) == null) continue;
                hasher.putString((CharSequence)text, Charsets.UTF_8);
            }
        }
        NodeList children = element.getChildNodes();
        int n2 = children.getLength();
        for (int i = 0; i < n2; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            InstalledPatchCache.hashResources((Element)child, hasher, resources);
        }
    }

    public void dispose() {
    }

    private static class PatchState {
        public long manifestModified;
        @Nullable
        public HashCode manifestResources;

        private PatchState() {
        }
    }
}

