/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ApkInstaller {
    private static final Logger LOG = Logger.getInstance(ApkInstaller.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final LaunchOptions myLaunchOptions;
    @NotNull
    private final InstalledApkCache myInstalledApkCache;
    @NotNull
    private final ConsolePrinter myPrinter;

    public ApkInstaller(@NotNull AndroidFacet facet, @NotNull LaunchOptions options, @NotNull InstalledApkCache installedApkCache, @NotNull ConsolePrinter printer) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/ApkInstaller", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/run/ApkInstaller", "<init>"));
        }
        if (installedApkCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installedApkCache", "com/android/tools/idea/run/ApkInstaller", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/ApkInstaller", "<init>"));
        }
        this.myFacet = facet;
        this.myProject = facet.getModule().getProject();
        this.myLaunchOptions = options;
        this.myInstalledApkCache = installedApkCache;
        this.myPrinter = printer;
    }

    public boolean uploadAndInstallApk(@NotNull IDevice device, @NotNull String packageName, @NotNull File localFile, @NotNull LaunchStatus launchStatus) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "uploadAndInstallApk"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/ApkInstaller", "uploadAndInstallApk"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/android/tools/idea/run/ApkInstaller", "uploadAndInstallApk"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/ApkInstaller", "uploadAndInstallApk"));
        }
        if (!this.needsInstall(device, localFile, packageName)) {
            return true;
        }
        String remotePath = "/data/local/tmp/" + packageName;
        this.myPrinter.stdout("$ adb push " + localFile + " " + remotePath);
        try {
            device.pushFile(localFile.getPath(), remotePath);
            boolean installed = this.installApp(device, remotePath, packageName, launchStatus);
            if (installed) {
                this.myInstalledApkCache.setInstalled(device, localFile, packageName);
            }
            return installed;
        }
        catch (Exception e) {
            this.myPrinter.stderr(e.toString());
            return false;
        }
    }

    boolean needsInstall(@NotNull IDevice device, @NotNull File localFile, @NotNull String packageName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "needsInstall"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/android/tools/idea/run/ApkInstaller", "needsInstall"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/ApkInstaller", "needsInstall"));
        }
        if (!this.myLaunchOptions.isSkipNoopApkInstallations()) {
            return true;
        }
        try {
            if (!this.myInstalledApkCache.isInstalled(device, localFile, packageName)) {
                return true;
            }
        }
        catch (IOException e) {
            return true;
        }
        this.myPrinter.stdout("No apk changes detected since last installation, skipping installation of " + localFile.getPath());
        if (this.myLaunchOptions.isForceStopRunningApp()) {
            this.forceStopPackageSilently(device, packageName, true);
        }
        return false;
    }

    private void forceStopPackageSilently(@NotNull IDevice device, @NotNull String packageName, boolean ignoreErrors) {
        block4: {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "forceStopPackageSilently"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/ApkInstaller", "forceStopPackageSilently"));
            }
            String command = "am force-stop " + packageName;
            this.myPrinter.stdout("$ adb shell " + command);
            try {
                device.executeShellCommand(command, (IShellOutputReceiver)new NullOutputReceiver(), 1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (ignoreErrors) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    private boolean installApp(@NotNull IDevice device, @NotNull String remotePath, @NotNull String packageName, @NotNull LaunchStatus launchStatus) throws IOException, AdbCommandRejectedException, TimeoutException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "installApp"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/android/tools/idea/run/ApkInstaller", "installApp"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/ApkInstaller", "installApp"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/ApkInstaller", "installApp"));
        }
        InstallResult result = null;
        boolean retry = true;
        block11: while (!launchStatus.isLaunchTerminated() && retry) {
            result = this.installApp(device, remotePath, launchStatus);
            if (result.installOutput != null) {
                if (result.failureCode == InstallResult.FailureCode.NO_ERROR) {
                    this.myPrinter.stdout(result.installOutput);
                } else {
                    this.myPrinter.stderr(result.installOutput);
                }
            }
            switch (result.failureCode) {
                case DEVICE_NOT_RESPONDING: {
                    int waitTime = 2;
                    this.myPrinter.stdout("Device is not ready. Waiting for " + waitTime + " seconds.");
                    try {
                        TimeUnit.SECONDS.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Throwable)e);
                    }
                    retry = true;
                    continue block11;
                }
                case INSTALL_FAILED_VERSION_DOWNGRADE: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.version.downgrade", new Object[0]));
                    retry = this.showPrompt(reason) && this.uninstallPackage(device, packageName);
                    continue block11;
                }
                case INCONSISTENT_CERTIFICATES: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.different.signature", new Object[0]));
                    retry = this.showPrompt(reason) && this.uninstallPackage(device, packageName);
                    continue block11;
                }
                case INSTALL_FAILED_DEXOPT: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.dexopt", new Object[0]));
                    retry = this.showPrompt(reason) && this.uninstallPackage(device, packageName);
                    continue block11;
                }
                case NO_CERTIFICATE: {
                    this.myPrinter.stderr(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    this.showMessageDialog(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    retry = false;
                    continue block11;
                }
                case INSTALL_FAILED_OLDER_SDK: {
                    String reason = this.validateSdkVersion(device);
                    if (reason != null) {
                        if (this.showPrompt(reason)) {
                            this.openProjectStructure();
                        }
                        retry = false;
                        continue block11;
                    }
                }
                case UNTYPED_ERROR: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.generic.text", result.failureMessage);
                    retry = this.showPrompt(reason) && this.uninstallPackage(device, packageName);
                    continue block11;
                }
            }
            retry = false;
        }
        return result != null && result.failureCode == InstallResult.FailureCode.NO_ERROR;
    }

    private String validateSdkVersion(@NotNull IDevice device) {
        AndroidVersion minSdkVersion;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "validateSdkVersion"));
        }
        AndroidVersion deviceVersion = device.getVersion();
        if (!deviceVersion.canRun(minSdkVersion = this.myFacet.getAndroidModuleInfo().getRuntimeMinSdkVersion())) {
            this.myPrinter.stderr("Device API level: " + deviceVersion.toString());
            return AndroidBundle.message("deployment.failed.reason.oldersdk", minSdkVersion.toString(), deviceVersion.toString());
        }
        return null;
    }

    private void showMessageDialog(final @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/run/ApkInstaller", "showMessageDialog"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)ApkInstaller.this.myProject, (String)message, (String)AndroidBundle.message("deployment.failed.title", new Object[0]));
            }
        });
    }

    private boolean showPrompt(final String reason) {
        final AtomicBoolean ok = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int result = Messages.showOkCancelDialog((Project)ApkInstaller.this.myProject, (String)reason, (String)AndroidBundle.message("deployment.failed.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                ok.set(result == 0);
            }
        }, ModalityState.defaultModalityState());
        return ok.get();
    }

    private boolean uninstallPackage(@NotNull IDevice device, @NotNull String packageName) {
        String output;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "uninstallPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/run/ApkInstaller", "uninstallPackage"));
        }
        this.myPrinter.stdout("$ adb shell pm uninstall " + packageName);
        try {
            output = device.uninstallPackage(packageName);
        }
        catch (InstallException e) {
            return false;
        }
        if (output != null) {
            this.myPrinter.stderr(output);
            return false;
        }
        return true;
    }

    private InstallResult installApp(@NotNull IDevice device, @NotNull String remotePath, LaunchStatus launchStatus) throws AdbCommandRejectedException, TimeoutException, IOException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ApkInstaller", "installApp"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/android/tools/idea/run/ApkInstaller", "installApp"));
        }
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(launchStatus);
        String command = ApkInstaller.getPmInstallCommand(remotePath, this.myLaunchOptions.getPmInstallOptions());
        this.myPrinter.stdout("$ adb shell " + command);
        try {
            device.executeShellCommand(command, (IShellOutputReceiver)receiver);
        }
        catch (ShellCommandUnresponsiveException e) {
            LOG.info((Throwable)e);
            return new InstallResult(InstallResult.FailureCode.DEVICE_NOT_RESPONDING, null, null);
        }
        return InstallResult.forLaunchOutput(receiver);
    }

    @NotNull
    private static String getPmInstallCommand(@NotNull String remotePath, String pmInstallOptions) {
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/android/tools/idea/run/ApkInstaller", "getPmInstallCommand"));
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append("pm install ");
        if (!StringUtil.isEmpty((String)pmInstallOptions)) {
            sb.append(pmInstallOptions);
            sb.append(' ');
        }
        sb.append("-r \"");
        sb.append(remotePath);
        sb.append("\"");
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ApkInstaller", "getPmInstallCommand"));
        }
        return string;
    }

    private void openProjectStructure() {
        final ProjectSettingsService service = ProjectSettingsService.getInstance((Project)this.myFacet.getModule().getProject());
        if (service instanceof AndroidProjectSettingsService) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((AndroidProjectSettingsService)service).openAndSelectFlavorsEditor(ApkInstaller.this.myFacet.getModule());
                }
            });
        }
    }
}

