/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.HotSwapTasksProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.idea.run.tasks.NoChangesTasksProvider;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProviderFactory
implements LaunchTasksProviderFactory {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final ProcessHandler myPreviousSessionProcessHandler;

    public AndroidLaunchTasksProviderFactory(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions, @Nullable ProcessHandler processHandler) {
        if (runConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfig", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "<init>"));
        }
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myFacet = facet;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
        this.myPreviousSessionProcessHandler = processHandler;
    }

    @Override
    @NotNull
    public LaunchTasksProvider get() {
        InstantRunStatsService.get(this.myEnv.getProject()).notifyDeployStarted();
        if (InstantRunUtils.isInstantRunEnabled(this.myEnv)) {
            InstantRunBuildInfo buildInfo = this.getInstantRunBuildInfo();
            if (buildInfo != null) {
                InstantRunManager.LOG.info("Build timestamp: " + buildInfo.getTimeStamp() + ", verifier status: " + StringUtil.notNullize((String)buildInfo.getVerifierStatus(), (String)"empty"));
                if (this.myPreviousSessionProcessHandler != null && !this.myPreviousSessionProcessHandler.isProcessTerminated() && buildInfo.hasNoChanges()) {
                    NoChangesTasksProvider noChangesTasksProvider = new NoChangesTasksProvider(this.myFacet);
                    if (noChangesTasksProvider == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "get"));
                    }
                    return noChangesTasksProvider;
                }
                if (this.canHotSwap(buildInfo)) {
                    HotSwapTasksProvider hotSwapTasksProvider = new HotSwapTasksProvider(this.myRunConfig, this.myEnv, this.myFacet, this.myApkProvider, this.myLaunchOptions);
                    if (hotSwapTasksProvider == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "get"));
                    }
                    return hotSwapTasksProvider;
                }
            } else {
                InstantRunManager.LOG.info("No build-info.xml file");
            }
        }
        AndroidLaunchTasksProvider androidLaunchTasksProvider = new AndroidLaunchTasksProvider(this.myRunConfig, this.myEnv, this.myFacet, this.myApkProvider, this.myLaunchOptions);
        if (androidLaunchTasksProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "get"));
        }
        return androidLaunchTasksProvider;
    }

    private boolean canHotSwap(@NotNull InstantRunBuildInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/run/AndroidLaunchTasksProviderFactory", "canHotSwap"));
        }
        if (this.myPreviousSessionProcessHandler == null) {
            InstantRunManager.LOG.info("Cannot hot swap since there is no active launch session for this config.");
            return false;
        }
        if (InstantRunUtils.needsFullBuild(this.myEnv) || !InstantRunUtils.isAppRunning(this.myEnv)) {
            return false;
        }
        boolean canHotswap = info.canHotswap();
        if (!canHotswap) {
            InstantRunManager.LOG.info("Cannot hot swap according to build-info.xml");
        }
        return canHotswap;
    }

    @Nullable
    private InstantRunBuildInfo getInstantRunBuildInfo() {
        AndroidGradleModel model = AndroidGradleModel.get(this.myFacet);
        return model == null ? null : InstantRunGradleUtils.getBuildInfo(model);
    }
}

