/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.BooleanStatus;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.fd.InstantRunUserFeedback;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ClearLogcatTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.DexDeployTask;
import com.android.tools.idea.run.tasks.DismissKeyguardTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.tasks.SplitApkDeployTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProvider
implements LaunchTasksProvider {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final Project myProject;
    private final AndroidFacet myFacet;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        if (runConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfig", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "<init>"));
        }
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        String packageName;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        if (consolePrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consolePrinter", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        ArrayList launchTasks = Lists.newArrayList();
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            launchTasks.add(new ClearLogcatTask(this.myProject));
        }
        launchTasks.add(new DismissKeyguardTask());
        LaunchTask deployTask = this.getDeployTask(device, launchStatus, consolePrinter);
        if (deployTask != null) {
            launchTasks.add(deployTask);
        }
        if (launchStatus.isLaunchTerminated()) {
            ArrayList arrayList = launchTasks;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
            }
            return arrayList;
        }
        try {
            packageName = this.myApkProvider.getPackageName();
            LaunchTask appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApkProvider, this.myFacet, this.myLaunchOptions.isDebug(), launchStatus);
            if (appLaunchTask != null) {
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to determine application id: " + e);
            List<LaunchTask> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
            }
            return list;
        }
        if (!this.myLaunchOptions.isDebug() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName));
        }
        ArrayList arrayList = launchTasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getTasks"));
        }
        return arrayList;
    }

    @Nullable
    private LaunchTask getDeployTask(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        AndroidGradleModel model;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTask"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTask"));
        }
        if (consolePrinter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consolePrinter", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getDeployTask"));
        }
        if (!this.myLaunchOptions.isDeploy()) {
            return null;
        }
        if (InstantRunUtils.isInstantRunEnabled(this.myEnv) && InstantRunSettings.isInstantRunEnabled() && (model = AndroidGradleModel.get(this.myFacet)) != null) {
            BooleanStatus status = InstantRunGradleUtils.getIrSupportStatus(model, device.getVersion());
            if (status.success) {
                String pkgName;
                InstantRunBuildInfo buildInfo = InstantRunGradleUtils.getBuildInfo(model);
                if (buildInfo == null) {
                    String reason = "Gradle build-info.xml not found for module " + this.myFacet.getModule().getName() + ". Please make sure that you are using gradle plugin '2.0.0-alpha4' or higher.";
                    launchStatus.terminateLaunch(reason);
                    return null;
                }
                try {
                    pkgName = ApkProviderUtil.computePackageName(this.myFacet);
                }
                catch (ApkProvisionException e) {
                    launchStatus.terminateLaunch("Unable to determine application id for module " + this.myFacet.getModule().getName());
                    return null;
                }
                if (!InstantRunSettings.isColdSwapEnabled() && !buildInfo.getVerifierStatus().isEmpty()) {
                    InstantRunManager.LOG.info("Coldswap disabled by user setting, restarting build.");
                    InstantRunManager.transferLocalIdToDeviceId(device, this.myFacet.getModule());
                    DeployApkTask.cacheManifestInstallationData(device, this.myFacet, pkgName);
                    this.restartBuild(device);
                    return null;
                }
                List artifacts = buildInfo.getArtifacts();
                if (artifacts.isEmpty()) {
                    InstantRunManager.transferLocalIdToDeviceId(device, this.myFacet.getModule());
                    DeployApkTask.cacheManifestInstallationData(device, this.myFacet, pkgName);
                    if (!buildInfo.getVerifierStatus().isEmpty()) {
                        InstantRunManager.LOG.info("Build info reports verifier failure, but no artifacts were provided. Restarting launch.");
                        launchStatus.terminateLaunch("Re-launching since we cannot push the current build results to device");
                        this.restartBuild(device);
                        return null;
                    }
                    consolePrinter.stdout("No local changes, not deploying APK");
                    InstantRunManager.LOG.info("List of artifacts is empty, no deployment necessary.");
                    new InstantRunUserFeedback(this.myFacet.getModule()).info("No changes to deploy");
                    return null;
                }
                if (buildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT}) || buildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT_MAIN})) {
                    InstantRunManager.LOG.info("Using split APK deploy task");
                    return new SplitApkDeployTask(pkgName, this.myFacet, buildInfo);
                }
                if (buildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.DEX, InstantRunArtifactType.RESOURCES})) {
                    InstantRunManager.LOG.info("Using Dex Deploy task");
                    return new DexDeployTask(this.myEnv, this.myFacet, buildInfo);
                }
            } else {
                InstantRunManager.LOG.info("Instant Run not supported: " + status.getCause());
            }
        }
        InstantRunManager.LOG.info("Using legacy/main APK deploy task");
        boolean instantRunAware = InstantRunUtils.isInstantRunEnabled(this.myEnv) && InstantRunSettings.isInstantRunEnabled() && InstantRunGradleUtils.getIrSupportStatus((Module)this.myFacet.getModule(), (AndroidVersion)device.getVersion()).success;
        return new DeployApkTask(this.myFacet, this.myLaunchOptions, this.myApkProvider, instantRunAware);
    }

    private void restartBuild(final @NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "restartBuild"));
        }
        InstantRunStatsService.get(this.myFacet.getModule().getProject()).incrementRestartLaunchCount();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                InstantRunUtils.setRestartSession(AndroidLaunchTasksProvider.this.myEnv, device);
                ExecutionUtil.restart((ExecutionEnvironment)AndroidLaunchTasksProvider.this.myEnv);
            }
        });
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus) {
        String packageName;
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/AndroidLaunchTasksProvider", "getConnectDebuggerTask"));
        }
        if (!this.myLaunchOptions.isDebug()) {
            return null;
        }
        HashSet packageIds = Sets.newHashSet();
        try {
            packageName = this.myApkProvider.getPackageName();
            packageIds.add(packageName);
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
        }
        try {
            packageName = this.myApkProvider.getTestPackageName();
            if (packageName != null) {
                packageIds.add(packageName);
            }
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).warn("Unable to obtain test package name, will not connect debugger if tests don't instantiate main application");
        }
        AndroidDebugger debugger = this.myRunConfig.getAndroidDebugger();
        Object androidDebuggerState = this.myRunConfig.getAndroidDebuggerState();
        if (debugger != null && androidDebuggerState != null) {
            return debugger.getConnectDebuggerTask(this.myEnv, packageIds, this.myFacet, androidDebuggerState, this.myRunConfig.getType().getId());
        }
        return null;
    }

    @Override
    public boolean createsNewProcess() {
        return true;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return this.myRunConfig.monitorRemoteProcess();
    }
}

