/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.DevicePickerListModel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class AndroidDeviceRenderer
extends ColoredListCellRenderer<DevicePickerEntry> {
    private final LaunchCompatibilityChecker myCompatibilityChecker;
    private final SpeedSearchBase mySpeedSearch;

    public AndroidDeviceRenderer(@NotNull LaunchCompatibilityChecker checker, @NotNull SpeedSearchBase speedSearch) {
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/android/tools/idea/run/AndroidDeviceRenderer", "<init>"));
        }
        if (speedSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/android/tools/idea/run/AndroidDeviceRenderer", "<init>"));
        }
        this.myCompatibilityChecker = checker;
        this.mySpeedSearch = speedSearch;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof DevicePickerEntry && ((DevicePickerEntry)value).isMarker()) {
            String marker = ((DevicePickerEntry)value).getMarker();
            assert (marker != null) : "device picker marker entry doesn't have a descriptive string";
            if (value == DevicePickerEntry.NONE) {
                return AndroidDeviceRenderer.renderEmptyMarker(marker);
            }
            return AndroidDeviceRenderer.renderTitledSeparator(marker);
        }
        return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
    }

    protected void customizeCellRenderer(JList list, DevicePickerEntry entry, int index, boolean selected, boolean hasFocus) {
        boolean compatible;
        AndroidDevice device = entry.getAndroidDevice();
        assert (device != null);
        LaunchCompatibility launchCompatibility = this.myCompatibilityChecker.validate(device);
        boolean bl = compatible = launchCompatibility.isCompatible() != ThreeState.NO;
        if (AndroidDeviceRenderer.shouldShowSerialNumbers(list, device)) {
            this.append("[" + device.getSerial() + "] ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        device.renderName((SimpleColoredComponent)this, compatible, this.mySpeedSearch.getEnteredPrefix());
        if (launchCompatibility.getReason() != null) {
            this.append(" (" + launchCompatibility.getReason() + ")", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        }
    }

    private static boolean shouldShowSerialNumbers(@NotNull JList list, @NotNull AndroidDevice device) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/run/AndroidDeviceRenderer", "shouldShowSerialNumbers"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidDeviceRenderer", "shouldShowSerialNumbers"));
        }
        if (device.isVirtual()) {
            return false;
        }
        ListModel model = list.getModel();
        if (model instanceof DevicePickerListModel) {
            return ((DevicePickerListModel)model).shouldShowSerialNumbers();
        }
        return false;
    }

    private static Component renderTitledSeparator(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/run/AndroidDeviceRenderer", "renderTitledSeparator"));
        }
        TitledSeparator separator = new TitledSeparator(title);
        separator.setBackground(UIUtil.getListBackground());
        separator.setTitleFont(UIUtil.getLabelFont());
        return separator;
    }

    private static Component renderEmptyMarker(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/run/AndroidDeviceRenderer", "renderEmptyMarker"));
        }
        return new JLabel(title);
    }
}

