/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view.nodes;

import com.android.tools.idea.profiling.capture.Capture;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;

public class CaptureNode
extends SimpleNode {
    @NotNull
    private final Capture myCapture;

    public CaptureNode(@NotNull Project project, @NotNull Capture capture) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/view/nodes/CaptureNode", "<init>"));
        }
        if (capture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "capture", "com/android/tools/idea/profiling/view/nodes/CaptureNode", "<init>"));
        }
        super(project);
        this.myCapture = capture;
        this.getTemplatePresentation().addText(this.myCapture.getDescription(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setIcon(this.myCapture.getType().getIcon());
    }

    public SimpleNode[] getChildren() {
        return new SimpleNode[0];
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    @NotNull
    public Capture getCapture() {
        Capture capture = this.myCapture;
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/nodes/CaptureNode", "getCapture"));
        }
        return capture;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        assert (this.myProject != null);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myCapture.getFile());
        try {
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void doUpdate() {
        this.getTemplatePresentation().clearText();
        this.getTemplatePresentation().addText(this.myCapture.getDescription(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

