/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameCaptureFileAction
extends DumbAwareAction {
    protected RenameCaptureFileAction(JComponent ancestorComponent) {
        super("Rename...", "Rename selected capture file", null);
        this.registerCustomShortcutSet(CommonShortcuts.getRename(), ancestorComponent);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        RenameDialog dialog = new RenameDialog(project, virtualFile);
        dialog.show();
    }

    protected static class RenameDialog
    extends DialogWrapper {
        private final Project myProject;
        private final VirtualFile myFile;
        private JBTextField myInput;

        protected RenameDialog(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/view/RenameCaptureFileAction$RenameDialog", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/profiling/view/RenameCaptureFileAction$RenameDialog", "<init>"));
            }
            super(project);
            this.myProject = project;
            this.myFile = file;
            this.setTitle("Rename");
            this.init();
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            String fileNameWithoutExtension = this.myFile.getNameWithoutExtension();
            JLabel description = new JLabel(String.format("Rename %1$s to", fileNameWithoutExtension));
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.fill = 2;
            panel.add((Component)description, constraints);
            this.myInput = new JBTextField(fileNameWithoutExtension);
            this.myInput.selectAll();
            constraints.gridy = 1;
            panel.add((Component)this.myInput, constraints);
            this.myInput.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent documentEvent) {
                    boolean isValid = VirtualFile.isValidName((String)RenameDialog.this.myInput.getText().trim());
                    RenameDialog.this.setErrorText(isValid ? null : String.format("'%1$s' is not valid", RenameDialog.this.myInput.getText()));
                    RenameDialog.this.myOKAction.setEnabled(isValid);
                }
            });
            return panel;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myInput;
        }

        protected void doOKAction() {
            String extension = this.myFile.getExtension();
            final String newName = this.myInput.getText().trim() + (extension != null && extension.length() > 0 ? "." + extension : "");
            String commandName = String.format("Rename %1$s to %2$s", this.myFile.getName(), newName);
            try {
                new WriteCommandAction(this.myProject, commandName, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/profiling/view/RenameCaptureFileAction$RenameDialog$2", "run"));
                        }
                        RenameDialog.this.myFile.rename((Object)this, newName);
                    }
                }.execute();
            }
            catch (Exception e) {
                this.setErrorText(String.format("Could not rename to %1$s: %2$s", newName, e.getCause().getMessage()));
                return;
            }
            super.doOKAction();
        }
    }
}

