/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.template.components.ComponentProvider;
import com.android.tools.idea.ui.properties.ObservableProperty;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.intellij.ui.ListCellRendererWrapper;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SourceSetComboProvider
extends ComponentProvider<JComboBox> {
    @NotNull
    private final List<SourceProvider> mySourceSets;

    public SourceSetComboProvider(@NotNull List<SourceProvider> sourceSets) {
        if (sourceSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSets", "com/android/tools/idea/npw/template/components/SourceSetComboProvider", "<init>"));
        }
        this.mySourceSets = sourceSets;
    }

    @Override
    @NotNull
    public JComboBox createComponent() {
        DefaultComboBoxModel<SourceProvider> comboBoxModel = new DefaultComboBoxModel<SourceProvider>();
        for (SourceProvider sourceSet : this.mySourceSets) {
            comboBoxModel.addElement(sourceSet);
        }
        JComboBox sourceSetCombo = new JComboBox(comboBoxModel);
        sourceSetCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setText(((SourceProvider)value).getName());
            }
        });
        sourceSetCombo.setToolTipText("<html>The source set within which to generate new project files.<br>If you specify a source set that does not yet exist on disk, a folder will be created for it.</html>");
        JComboBox jComboBox = sourceSetCombo;
        if (jComboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/components/SourceSetComboProvider", "createComponent"));
        }
        return jComboBox;
    }

    @Override
    @Nullable
    public ObservableProperty<?> createProperty(@NotNull JComboBox sourceSetCombo) {
        if (sourceSetCombo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSetCombo", "com/android/tools/idea/npw/template/components/SourceSetComboProvider", "createProperty"));
        }
        return new SelectedItemProperty(sourceSetCombo);
    }
}

