/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.assetstudiolib.NotificationIconGenerator;
import com.android.resources.Density;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CategoryIconMap {
    private static final Filter ACCEPT_ALL = new Filter(){

        @Override
        public boolean accept(@NotNull String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap$1", "accept"));
            }
            return true;
        }
    };
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    @NotNull
    private final Map<String, Map<String, BufferedImage>> myCategoryMap;

    public CategoryIconMap(@NotNull Map<String, Map<String, BufferedImage>> categoryMap) {
        if (categoryMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryMap", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "<init>"));
        }
        this.myCategoryMap = categoryMap;
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        if (iconPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconPath", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "pathToDensity"));
        }
        iconPath = FileUtil.toSystemIndependentName((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap() {
        Map<Density, BufferedImage> map = this.toDensityMap(ACCEPT_ALL);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "toDensityMap"));
        }
        return map;
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "toDensityMap"));
        }
        HashMap densityImageMap = Maps.newHashMap();
        for (String category : this.myCategoryMap.keySet()) {
            if (!filter.accept(category)) continue;
            Map<String, BufferedImage> pathImageMap = this.myCategoryMap.get(category);
            for (String path : pathImageMap.keySet()) {
                Density density = CategoryIconMap.pathToDensity(path);
                if (density == null) continue;
                BufferedImage image = pathImageMap.get(path);
                densityImageMap.put(density, image);
            }
        }
        HashMap hashMap = densityImageMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "toDensityMap"));
        }
        return hashMap;
    }

    @NotNull
    public Map<File, BufferedImage> toFileMap(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "toFileMap"));
        }
        HashMap outputMap = Maps.newHashMap();
        for (Map<String, BufferedImage> pathImageMap : this.myCategoryMap.values()) {
            for (Map.Entry<String, BufferedImage> pathImageEntry : pathImageMap.entrySet()) {
                outputMap.put(new File(rootDir, pathImageEntry.getKey()), pathImageEntry.getValue());
            }
        }
        HashMap hashMap = outputMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap", "toFileMap"));
        }
        return hashMap;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
    }

    public static final class NotificationFilter
    implements Filter {
        @NotNull
        private final NotificationIconGenerator.Version myVersion;

        public NotificationFilter(@NotNull NotificationIconGenerator.Version version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap$NotificationFilter", "<init>"));
            }
            this.myVersion = version;
        }

        @Override
        public boolean accept(@NotNull String category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap$NotificationFilter", "accept"));
            }
            return this.myVersion.getDisplayName().equals(category);
        }
    }

    public static interface Filter {
        public boolean accept(@NotNull String var1);
    }
}

